/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils.json.resourcerecords;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Record;
import org.xbill.DNS.Type;
import org.xbill.DNS.utils.json.exception.JsonSerializationException;
import org.xbill.DNS.utils.json.resourcerecords.ResourceRecordSerializationStrategy;

public abstract class AbstractRecordSerializer<T extends Record>
extends StdSerializer<T> {
    public AbstractRecordSerializer(Class<T> t) {
        super(t);
    }

    public void serialize(T value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        try {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("name", ((Record)value).getName().toString());
            jsonGenerator.writeStringField("class", DClass.string(((Record)value).getDClass()));
            jsonGenerator.writeStringField("ttl", this.formatNumber(((Record)value).getTTL()));
            jsonGenerator.writeStringField("type", Type.string(((Record)value).getType()));
            if (ResourceRecordSerializationStrategy.isRawRDataFormat().booleanValue()) {
                jsonGenerator.writeStringField("rdata", ((Record)value).rdataToString());
            } else {
                this.serializeRDataFields(value, jsonGenerator, serializerProvider);
            }
            jsonGenerator.writeEndObject();
        }
        catch (IOException e) {
            throw new JsonSerializationException(JsonSerializationException.JsonSerializationExceptionCode.unexpectedResourceRecordGenerationError, (Throwable)e, Type.string(((Record)value).getType()), ((Record)value).getName() != null ? ((Record)value).getName().toString() : "unknown", e.getMessage());
        }
    }

    protected abstract void serializeRDataFields(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException, JsonGenerationException;

    public String formatNumber(Number number) {
        return String.valueOf(number);
    }
}

