/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.HasBuiltinDelimiterForLicense;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.protobuf.BufStep;
import java.util.Objects;
import javax.inject.Inject;

public class ProtobufExtension
extends FormatExtension
implements HasBuiltinDelimiterForLicense {
    static final String NAME = "protobuf";

    @Inject
    public ProtobufExtension(SpotlessExtension spotless) {
        super(spotless);
    }

    @Override
    public FormatExtension.LicenseHeaderConfig licenseHeader(String licenseHeader) {
        return this.licenseHeader(licenseHeader, "syntax");
    }

    @Override
    public FormatExtension.LicenseHeaderConfig licenseHeaderFile(Object licenseHeaderFile) {
        return this.licenseHeaderFile(licenseHeaderFile, "syntax");
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            this.target = this.parseTarget("**/*.proto");
        }
        super.setupTask(task);
    }

    public BufFormatExtension buf(String version) {
        Objects.requireNonNull(version);
        return new BufFormatExtension(version);
    }

    public BufFormatExtension buf() {
        return this.buf(BufStep.defaultVersion());
    }

    public class BufFormatExtension {
        BufStep step;

        BufFormatExtension(String version) {
            this.step = BufStep.withVersion((String)version);
            if (!ProtobufExtension.this.steps.isEmpty()) {
                throw new IllegalArgumentException("buf() must be the first step, move other steps after it. Thumbs up [this issue](https://github.com/bufbuild/buf/issues/1035) for a resolution, see [here](https://github.com/diffplug/spotless/pull/1208#discussion_r1264439669) for more details on the problem.");
            }
            ProtobufExtension.this.addStep(this.createStep());
        }

        public BufFormatExtension pathToExe(String pathToExe) {
            this.step = this.step.withPathToExe(pathToExe);
            ProtobufExtension.this.replaceStep(this.createStep());
            return this;
        }

        private FormatterStep createStep() {
            return this.step.create();
        }
    }
}

