/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.xwpf;

import com.deepoove.poi.exception.ReflectionException;
import com.deepoove.poi.xwpf.XWPFStructuredDocumentTag;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.xwpf.usermodel.IRunBody;
import org.apache.poi.xwpf.usermodel.IRunElement;
import org.apache.poi.xwpf.usermodel.XWPFFieldRun;
import org.apache.poi.xwpf.usermodel.XWPFHyperlinkRun;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFSDT;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBookmark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTMarkupRange;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSimpleField;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.impl.CTPImpl;

public class XWPFParagraphWrapper {
    static final QName HYPER_QNAME = new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "hyperlink");
    static final QName FLDSIMPLE_QNAME = new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "fldSimple");
    static final QName R_QNAME = new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "r");
    static final QName BOOKMARK_START_QNAME = new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "bookmarkStart");
    static final QName BOOKMARK_END_QNAME = new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "bookmarkEnd");
    static final QName COMMENT_START_QNAME = new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "commentRangeStart");
    static final QName COMMENT_END_QNAME = new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "commentRangeEnd");
    static final QNameSet RUN_QNAME_SET = QNameSet.forArray((QName[])new QName[]{HYPER_QNAME, FLDSIMPLE_QNAME, R_QNAME});
    XWPFParagraph paragraph;
    List<XWPFStructuredDocumentTag> sdts = null;

    public XWPFParagraphWrapper(XWPFParagraph paragraph) {
        this.paragraph = paragraph;
        List<XWPFRun> runs = this.getRuns();
        List<IRunElement> iRuns = this.getIRuns();
        ArrayList<CTHyperlink> caches = new ArrayList<CTHyperlink>();
        Iterator<XWPFRun> iterator = runs.iterator();
        while (iterator.hasNext()) {
            XWPFRun next = iterator.next();
            if (!(next instanceof XWPFHyperlinkRun)) continue;
            CTHyperlink ctHyperlink = ((XWPFHyperlinkRun)next).getCTHyperlink();
            if (caches.contains(ctHyperlink)) {
                iterator.remove();
                iRuns.remove(next);
                continue;
            }
            caches.add(ctHyperlink);
        }
    }

    public XWPFRun insertNewHyperLinkRun(XWPFRun run, String link) {
        if (StringUtils.isBlank((CharSequence)link)) {
            throw new IllegalArgumentException("Hyperlink must not be Empty!");
        }
        if (link.startsWith("anchor:")) {
            return this.insertNewAnchor(this.getPosOfRun(run), link.substring("anchor:".length()));
        }
        return this.insertNewHyperLinkRun(this.getPosOfRun(run), link);
    }

    public XWPFHyperlinkRun insertNewHyperLinkRun(int pos, String link) {
        if (pos >= 0 && pos <= this.paragraph.getRuns().size()) {
            CTHyperlink hyperlink = this.insertNewHyperlink(pos);
            PackageRelationship relationship = this.paragraph.getPart().getPackagePart().addExternalRelationship(link, XWPFRelation.HYPERLINK.getRelation());
            hyperlink.setId(relationship.getId());
            CTR ctr = hyperlink.addNewR();
            XWPFHyperlinkRun newRun = new XWPFHyperlinkRun(hyperlink, ctr, (IRunBody)this.paragraph);
            this.updateRunsAndIRuns(pos, (XWPFRun)newRun);
            return newRun;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CTHyperlink insertNewHyperlink(int paramInt) {
        CTP ctp = this.paragraph.getCTP();
        Object object = ctp.monitor();
        synchronized (object) {
            CTHyperlink localCTHyperlink = null;
            localCTHyperlink = (CTHyperlink)((CTPImpl)ctp).get_store().insert_element_user(RUN_QNAME_SET, HYPER_QNAME, paramInt);
            return localCTHyperlink;
        }
    }

    public XWPFFieldRun insertNewAnchor(int pos, String anchorName) {
        if (pos >= 0 && pos <= this.paragraph.getRuns().size()) {
            XWPFFieldRun insertNewField = this.insertNewField(pos);
            insertNewField.setFieldInstruction("HYPERLINK \\l \"" + anchorName + "\"");
            return insertNewField;
        }
        return null;
    }

    public CTBookmark insertNewBookmark(XWPFRun run) {
        int pos = this.getPosOfRun(run);
        CTMarkupRange end = this.insertNewBookmarkEnd(pos + 1);
        CTBookmark start = this.insertNewBookmarkStart(pos);
        start.setId(BigInteger.valueOf(500 + new Random().nextInt(50000)));
        end.setId(start.getId());
        return start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CTMarkupRange insertNewBookmarkEnd(int paramInt) {
        CTP ctp = this.paragraph.getCTP();
        Object object = ctp.monitor();
        synchronized (object) {
            CTMarkupRange local = null;
            local = (CTMarkupRange)((CTPImpl)ctp).get_store().insert_element_user(RUN_QNAME_SET, BOOKMARK_END_QNAME, paramInt);
            return local;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CTBookmark insertNewBookmarkStart(int paramInt) {
        CTP ctp = this.paragraph.getCTP();
        Object object = ctp.monitor();
        synchronized (object) {
            CTBookmark local = null;
            local = (CTBookmark)((CTPImpl)ctp).get_store().insert_element_user(RUN_QNAME_SET, BOOKMARK_START_QNAME, paramInt);
            return local;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertNewCommentRangeStart(XWPFRun run, BigInteger cId) {
        int pos = this.getPosOfRun(run);
        CTP ctp = this.paragraph.getCTP();
        Object object = ctp.monitor();
        synchronized (object) {
            CTMarkupRange mark = (CTMarkupRange)((CTPImpl)ctp).get_store().insert_element_user(RUN_QNAME_SET, COMMENT_START_QNAME, pos);
            mark.setId(cId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertNewCommentRangeEnd(XWPFRun run, BigInteger cId) {
        int pos = this.getPosOfRun(run);
        CTP ctp = this.paragraph.getCTP();
        Object object = ctp.monitor();
        synchronized (object) {
            CTMarkupRange mark = (CTMarkupRange)((CTPImpl)ctp).get_store().insert_element_user(RUN_QNAME_SET, COMMENT_END_QNAME, pos);
            mark.setId(cId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CTR insertNewR(int paramInt) {
        CTP ctp = this.paragraph.getCTP();
        Object object = ctp.monitor();
        synchronized (object) {
            CTR localCTR = null;
            localCTR = (CTR)((CTPImpl)ctp).get_store().insert_element_user(RUN_QNAME_SET, R_QNAME, paramInt);
            return localCTR;
        }
    }

    public XWPFRun insertNewRun(int pos) {
        if (pos >= 0 && pos <= this.paragraph.getRuns().size()) {
            CTR ctRun = this.insertNewR(pos);
            XWPFRun newRun = new XWPFRun(ctRun, (IRunBody)this.paragraph);
            this.updateRunsAndIRuns(pos, newRun);
            return newRun;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CTSimpleField insertNewFldSimple(int paramInt) {
        CTP ctp = this.paragraph.getCTP();
        Object object = ctp.monitor();
        synchronized (object) {
            CTSimpleField localCTSimpleField = null;
            localCTSimpleField = (CTSimpleField)((CTPImpl)ctp).get_store().insert_element_user(RUN_QNAME_SET, FLDSIMPLE_QNAME, paramInt);
            return localCTSimpleField;
        }
    }

    public XWPFFieldRun insertNewField(int pos) {
        if (pos >= 0 && pos <= this.paragraph.getRuns().size()) {
            CTSimpleField ctSimpleField = this.insertNewFldSimple(pos);
            CTR addNewR = ctSimpleField.addNewR();
            XWPFFieldRun newRun = new XWPFFieldRun(ctSimpleField, addNewR, (IRunBody)this.paragraph);
            this.updateRunsAndIRuns(pos, (XWPFRun)newRun);
            return newRun;
        }
        return null;
    }

    private void updateRunsAndIRuns(int pos, XWPFRun newRun) {
        XWPFRun oldAtPos;
        int oldAt;
        List<IRunElement> iruns = this.getIRuns();
        List<XWPFRun> runs = this.getRuns();
        int iPos = iruns.size();
        if (pos < runs.size() && (oldAt = iruns.indexOf(oldAtPos = runs.get(pos))) != -1) {
            iPos = oldAt;
        }
        iruns.add(iPos, (IRunElement)newRun);
        runs.add(pos, newRun);
    }

    private int getPosOfRun(XWPFRun run) {
        int pos = -1;
        List runs = this.paragraph.getRuns();
        for (int i = 0; i < runs.size(); ++i) {
            if (run != runs.get(i)) continue;
            pos = i;
            break;
        }
        return pos;
    }

    private List<XWPFRun> getRuns() {
        try {
            Field runsField = XWPFParagraph.class.getDeclaredField("runs");
            runsField.setAccessible(true);
            return (List)runsField.get(this.paragraph);
        }
        catch (Exception e) {
            throw new ReflectionException("runs", XWPFParagraph.class, e);
        }
    }

    private List<IRunElement> getIRuns() {
        try {
            Field runsField = XWPFParagraph.class.getDeclaredField("iruns");
            runsField.setAccessible(true);
            return (List)runsField.get(this.paragraph);
        }
        catch (Exception e) {
            throw new ReflectionException("iruns", XWPFParagraph.class, e);
        }
    }

    public void setAndUpdateRun(XWPFRun xwpfRun, XWPFRun source, int insertPostionCursor) {
        int i;
        int rPos = 0;
        List<XWPFRun> runs = this.getRuns();
        if (insertPostionCursor >= 0 && insertPostionCursor <= runs.size()) {
            for (i = 0; i < insertPostionCursor; ++i) {
                XWPFRun currRun = runs.get(i);
                if (xwpfRun instanceof XWPFHyperlinkRun) {
                    if (!(currRun instanceof XWPFHyperlinkRun)) continue;
                    ++rPos;
                    continue;
                }
                if (xwpfRun instanceof XWPFFieldRun) {
                    if (!(currRun instanceof XWPFFieldRun)) continue;
                    ++rPos;
                    continue;
                }
                if (currRun instanceof XWPFHyperlinkRun || currRun instanceof XWPFFieldRun) continue;
                ++rPos;
            }
        }
        if (xwpfRun instanceof XWPFHyperlinkRun) {
            this.paragraph.getCTP().setHyperlinkArray(rPos, ((XWPFHyperlinkRun)xwpfRun).getCTHyperlink());
        } else if (xwpfRun instanceof XWPFFieldRun) {
            this.paragraph.getCTP().setFldSimpleArray(rPos, ((XWPFFieldRun)xwpfRun).getCTField());
        } else {
            this.paragraph.getCTP().setRArray(rPos, xwpfRun.getCTR());
        }
        for (i = 0; i < runs.size(); ++i) {
            XWPFRun ele = runs.get(i);
            if (ele != source) continue;
            runs.set(i, xwpfRun);
        }
        List<IRunElement> iruns = this.getIRuns();
        for (int i2 = 0; i2 < iruns.size(); ++i2) {
            IRunElement ele = iruns.get(i2);
            if (ele != source) continue;
            iruns.set(i2, (IRunElement)xwpfRun);
        }
    }

    public boolean removeRun(int pos) {
        List<IRunElement> iruns = this.getIRuns();
        List<XWPFRun> runs = this.getRuns();
        if (pos >= 0 && pos < runs.size()) {
            XWPFRun run = runs.get(pos);
            runs.remove(pos);
            iruns.remove(run);
            int rPos = 0;
            for (int i = 0; i < pos; ++i) {
                XWPFRun currRun = runs.get(i);
                if (run instanceof XWPFHyperlinkRun) {
                    if (!(currRun instanceof XWPFHyperlinkRun)) continue;
                    ++rPos;
                    continue;
                }
                if (run instanceof XWPFFieldRun) {
                    if (!(currRun instanceof XWPFFieldRun)) continue;
                    ++rPos;
                    continue;
                }
                if (currRun instanceof XWPFHyperlinkRun || currRun instanceof XWPFFieldRun) continue;
                ++rPos;
            }
            if (run instanceof XWPFHyperlinkRun) {
                this.paragraph.getCTP().removeHyperlink(rPos);
            } else if (run instanceof XWPFFieldRun) {
                this.paragraph.getCTP().removeFldSimple(rPos);
            } else {
                this.paragraph.getCTP().removeR(rPos);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<XWPFStructuredDocumentTag> getSDTs() {
        if (null != this.sdts) {
            return this.sdts;
        }
        this.sdts = new ArrayList<XWPFStructuredDocumentTag>();
        long count = this.paragraph.getIRuns().stream().filter(r -> r instanceof XWPFSDT).count();
        if (0L == count) {
            return this.sdts;
        }
        CTP ctp = this.paragraph.getCTP();
        XmlCursor c = ctp.newCursor();
        try {
            c.selectPath("child::*");
            while (c.toNextSelection()) {
                XWPFStructuredDocumentTag cc;
                XmlObject o = c.getObject();
                if (o instanceof CTSdtBlock) {
                    cc = new XWPFStructuredDocumentTag((CTSdtBlock)o, this.paragraph.getBody());
                    this.sdts.add(cc);
                }
                if (!(o instanceof CTSdtRun)) continue;
                cc = new XWPFStructuredDocumentTag((CTSdtRun)o, this.paragraph.getBody());
                this.sdts.add(cc);
            }
        }
        finally {
            c.dispose();
        }
        return this.sdts;
    }

    public XWPFParagraph getParagraph() {
        return this.paragraph;
    }
}

