/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.xml.parsers;

import com.databricks.spark.xml.XmlOptions;
import com.databricks.spark.xml.parsers.StaxXmlParserUtils$;
import com.databricks.spark.xml.util.DropMalformedMode$;
import com.databricks.spark.xml.util.FailFastMode$;
import com.databricks.spark.xml.util.ParseMode;
import com.databricks.spark.xml.util.PartialResultException;
import com.databricks.spark.xml.util.PermissiveMode$;
import com.databricks.spark.xml.util.TypeCast$;
import java.io.Serializable;
import java.io.StringReader;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class StaxXmlParser$
implements scala.Serializable {
    public static StaxXmlParser$ MODULE$;
    private final Logger logger;

    static {
        new StaxXmlParser$();
    }

    private Logger logger() {
        return this.logger;
    }

    public RDD<Row> parse(RDD<String> xml, StructType schema, XmlOptions options) {
        Option corruptFieldIndex = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> schema.fieldIndex(options.columnNameOfCorruptRecord())).toOption();
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StaxXmlParser$.$anonfun$parse$2(options, x$1))));
        Object[] resultRow = new Object[schema.length()];
        Function2 & Serializable & scala.Serializable toResultRow = (Function2 & Serializable & scala.Serializable)(row, badRecord) -> {
            IntRef i = IntRef.create((int)0);
            while (i.elem < actualSchema.length()) {
                StructField from = actualSchema.apply(i.elem);
                resultRow$1[schema$1.fieldIndex((String)from.name())] = row.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get(i$1.elem)).orNull(Predef$.MODULE$.$conforms());
                ++i.elem;
            }
            corruptFieldIndex.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
                resultRow$1[index] = badRecord;
            });
            return Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)resultRow));
        };
        return xml.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isNamespaceAware", BoxesRunTime.boxToBoolean((boolean)false));
            factory.setProperty("javax.xml.stream.isCoalescing", BoxesRunTime.boxToBoolean((boolean)true));
            EventFilter filter = new EventFilter(){

                public boolean accept(XMLEvent event) {
                    return event.getEventType() != 5;
                }
            };
            return iter.flatMap((Function1 & Serializable & scala.Serializable)xml -> {
                Iterable iterable;
                XMLEventReader eventReader = factory.createXMLEventReader(new StringReader((String)xml));
                XMLEventReader parser = factory.createFilteredReader(eventReader, filter);
                try {
                    XMLEvent rootEvent = StaxXmlParserUtils$.MODULE$.skipUntil(parser, 1);
                    Attribute[] rootAttributes = (Attribute[])((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(rootEvent.asStartElement().getAttributes()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> (Attribute)x$3).toArray(ClassTag$.MODULE$.apply(Attribute.class));
                    iterable = Option$.MODULE$.option2Iterable(new Some((Object)MODULE$.convertObject(parser, schema, options, rootAttributes)).orElse((Function0 & Serializable & scala.Serializable)() -> this.failedRecord$1((String)xml, StaxXmlParser$.failedRecord$default$2$1(), StaxXmlParser$.failedRecord$default$3$1(), options, toResultRow)));
                }
                catch (Throwable throwable) {
                    Iterable iterable2;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof PartialResultException) {
                        PartialResultException partialResultException = (PartialResultException)throwable2;
                        iterable2 = Option$.MODULE$.option2Iterable(this.failedRecord$1((String)xml, partialResultException.cause(), (Option)new Some((Object)partialResultException.partialResult()), options, toResultRow));
                    } else {
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            iterable2 = Option$.MODULE$.option2Iterable(this.failedRecord$1((String)xml, e, StaxXmlParser$.failedRecord$default$3$1(), options, toResultRow));
                        } else {
                            throw throwable;
                        }
                    }
                    iterable = iterable2;
                }
                return iterable;
            });
        }, xml.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object convertField(XMLEventReader parser, DataType dataType, XmlOptions options) {
        Tuple2 tuple2;
        while (true) {
            Object object;
            XMLEvent c;
            if ((tuple2 = new Tuple2((Object)parser.peek(), (Object)dataType)) != null) {
                DataType dt = (DataType)tuple2._2();
                if (tuple2._1() instanceof StartElement && dt != null) {
                    DataType dataType2 = dt;
                    return this.convertComplicatedType$1(dataType2, parser, options);
                }
            }
            if (tuple2 != null && tuple2._1() instanceof EndElement && tuple2._2() instanceof StringType) {
                if (options.treatEmptyValuesAsNulls()) return null;
                String string = options.nullValue();
                String string2 = "";
                if (string != null) {
                    if (!string.equals(string2)) return "";
                    return null;
                }
                if (string2 == null) return null;
                return "";
            }
            if (tuple2 != null && tuple2._1() instanceof EndElement && tuple2._2() != null) {
                return null;
            }
            if (tuple2 == null || !((c = (XMLEvent)tuple2._1()) instanceof Characters)) break;
            Characters characters = (Characters)c;
            if (tuple2._2() == null || !characters.isWhiteSpace()) break;
            String data = characters.getData();
            parser.next();
            boolean bl = false;
            EndElement endElement = null;
            XMLEvent xMLEvent = parser.peek();
            if (xMLEvent instanceof StartElement) {
                object = this.convertComplicatedType$1(dataType, parser, options);
                return object;
            }
            if (xMLEvent instanceof EndElement) {
                bl = true;
                endElement = (EndElement)xMLEvent;
                if (data.isEmpty()) {
                    return null;
                }
            }
            if (bl && options.treatEmptyValuesAsNulls()) {
                return null;
            }
            if (!bl) continue;
            object = data;
            return object;
        }
        if (tuple2 != null) {
            XMLEvent c = (XMLEvent)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (c instanceof Characters) {
                Characters characters = (Characters)c;
                if (dataType3 instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType3;
                    DataType st = arrayType.elementType();
                    return TypeCast$.MODULE$.convertTo(characters.getData(), st, options);
                }
            }
        }
        if (tuple2 != null) {
            XMLEvent c = (XMLEvent)tuple2._1();
            DataType st = (DataType)tuple2._2();
            if (c instanceof Characters) {
                Characters characters = (Characters)c;
                if (st instanceof StructType) {
                    StructType structType = (StructType)st;
                    DataType dt = ((StructField)((IterableLike)structType.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StaxXmlParser$.$anonfun$convertField$1(options, x$4)))).head()).dataType();
                    return TypeCast$.MODULE$.convertTo(characters.getData(), dt, options);
                }
            }
        }
        if (tuple2 != null) {
            XMLEvent c = (XMLEvent)tuple2._1();
            DataType dt = (DataType)tuple2._2();
            if (c instanceof Characters) {
                Characters characters = (Characters)c;
                if (dt != null) {
                    DataType dataType4 = dt;
                    return TypeCast$.MODULE$.convertTo(characters.getData(), dataType4, options);
                }
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        XMLEvent e = (XMLEvent)tuple2._1();
        DataType dt = (DataType)tuple2._2();
        if (e == null) throw new MatchError((Object)tuple2);
        XMLEvent xMLEvent = e;
        if (dt == null) throw new MatchError((Object)tuple2);
        DataType dataType5 = dt;
        throw new IllegalArgumentException(new StringBuilder(50).append("Failed to parse a value for data type ").append(dataType5).append(" with event ").append(xMLEvent.toString()).toString());
    }

    private Map<String, Object> convertMap(XMLEventReader parser, DataType valueType, XmlOptions options) {
        ArrayBuffer keys = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer values = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        boolean shouldStop = false;
        while (!shouldStop) {
            BoxedUnit boxedUnit;
            XMLEvent xMLEvent = parser.nextEvent();
            if (xMLEvent instanceof StartElement) {
                StartElement startElement = (StartElement)xMLEvent;
                keys.$plus$eq((Object)startElement.getName().getLocalPart());
                boxedUnit = values.$plus$eq(this.convertField(parser, valueType, options));
                continue;
            }
            if (xMLEvent instanceof EndElement) {
                shouldStop = StaxXmlParserUtils$.MODULE$.checkEndElement(parser);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return ((TraversableOnce)keys.zip((GenIterable)values, ArrayBuffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Map<String, Object> convertAttributes(Attribute[] attributes, StructType schema, XmlOptions options) {
        scala.collection.mutable.Map convertedValuesMap = Map$.MODULE$.empty();
        Map<String, String> valuesMap = StaxXmlParserUtils$.MODULE$.convertAttributesToValuesMap(attributes, options);
        valuesMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StaxXmlParser$.$anonfun$convertAttributes$1(schema, convertedValuesMap, options, x0$1);
            return BoxedUnit.UNIT;
        });
        return convertedValuesMap.toMap(Predef$.MODULE$.$conforms());
    }

    private Row convertObjectWithAttributes(XMLEventReader parser, StructType schema, XmlOptions options, Attribute[] attributes) {
        Map map;
        Object[] row = new Object[schema.length()];
        Map<String, Object> attributesMap = this.convertAttributes(attributes, schema, options);
        Object object = this.convertField(parser, (DataType)schema, options);
        if (object instanceof Row) {
            Row row2 = (Row)object;
            map = (Map)Predef$.MODULE$.Map().apply((Seq)((IterableLike)schema.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.name(), Seq$.MODULE$.canBuildFrom())).zip((GenIterable)row2.toSeq(), Seq$.MODULE$.canBuildFrom()));
        } else if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames())).contains((Object)options.valueTag())) {
            Map valuesMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames())).map((Function1 & Serializable & scala.Serializable)x$7 -> new Tuple2(x$7, null), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
            map = valuesMap.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)options.valueTag()), object));
        } else {
            map = Predef$.MODULE$.Map().empty();
        }
        Map fieldsMap = map;
        Map valuesMap = (Map)fieldsMap.$plus$plus(attributesMap, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        valuesMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StaxXmlParser$.$anonfun$convertObjectWithAttributes$3(schema, row, x0$1);
            return BoxedUnit.UNIT;
        });
        return valuesMap.isEmpty() ? Row$.MODULE$.fromSeq((Seq)Seq$.MODULE$.fill(schema.fieldNames().length, (Function0 & Serializable & scala.Serializable)() -> null)) : Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)row));
    }

    private Row convertObject(XMLEventReader parser, StructType schema, XmlOptions options, Attribute[] rootAttributes) {
        Object[] row = new Object[schema.length()];
        Map nameToIndex = ((TraversableOnce)((IterableLike)schema.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.name(), Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.convertAttributes(rootAttributes, schema, options).toSeq().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StaxXmlParser$.$anonfun$convertObject$2(nameToIndex, row, x0$1);
            return BoxedUnit.UNIT;
        });
        None$ badRecordException = None$.MODULE$;
        boolean shouldStop = false;
        while (!shouldStop) {
            BoxedUnit boxedUnit;
            XMLEvent xMLEvent;
            block22: {
                BoxedUnit boxedUnit2;
                xMLEvent = parser.nextEvent();
                if (!(xMLEvent instanceof StartElement)) break block22;
                StartElement startElement = (StartElement)xMLEvent;
                try {
                    BoxedUnit boxedUnit3;
                    Attribute[] attributes = (Attribute[])((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(startElement.getAttributes()).asScala()).map((Function1 & Serializable & scala.Serializable)x$12 -> (Attribute)x$12).toArray(ClassTag$.MODULE$.apply(Attribute.class));
                    String field = startElement.asStartElement().getName().getLocalPart();
                    Option option = nameToIndex.get((Object)field);
                    if (option instanceof Some) {
                        ArrayType arrayType;
                        DataType dt;
                        BoxedUnit boxedUnit4;
                        Some some = (Some)option;
                        int index = BoxesRunTime.unboxToInt((Object)some.value());
                        DataType dataType = schema.apply(index).dataType();
                        if (dataType instanceof StructType) {
                            StructType structType = (StructType)dataType;
                            row[index] = this.convertObjectWithAttributes(parser, structType, options, attributes);
                            boxedUnit4 = BoxedUnit.UNIT;
                        } else if (dataType instanceof ArrayType && (dt = (arrayType = (ArrayType)dataType).elementType()) != null) {
                            Object object;
                            DataType dataType2 = dt;
                            ArrayBuffer values = (ArrayBuffer)Option$.MODULE$.apply(row[index]).map((Function1 & Serializable & scala.Serializable)x$13 -> (ArrayBuffer)x$13).getOrElse((Function0 & Serializable & scala.Serializable)() -> (ArrayBuffer)ArrayBuffer$.MODULE$.empty());
                            DataType dataType3 = dataType2;
                            if (dataType3 instanceof StructType) {
                                StructType structType = (StructType)dataType3;
                                object = this.convertObjectWithAttributes(parser, structType, options, attributes);
                            } else if (dataType3 != null) {
                                DataType dataType4 = dataType3;
                                object = this.convertField(parser, dataType4, options);
                            } else {
                                throw new MatchError((Object)dataType3);
                            }
                            Object newValue = object;
                            row[index] = values.$colon$plus(newValue, ArrayBuffer$.MODULE$.canBuildFrom());
                            boxedUnit4 = BoxedUnit.UNIT;
                        } else if (dataType != null) {
                            DataType dataType5 = dataType;
                            row[index] = this.convertField(parser, dataType5, options);
                            boxedUnit4 = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError((Object)dataType);
                        }
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else if (None$.MODULE$.equals(option)) {
                        StaxXmlParserUtils$.MODULE$.skipChildren(parser);
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable exception;
                    block24: {
                        block23: {
                            Throwable throwable2 = throwable;
                            Option option = NonFatal$.MODULE$.unapply(throwable2);
                            if (option.isEmpty()) break block23;
                            exception = (Throwable)option.get();
                            ParseMode parseMode = options.parseMode();
                            PermissiveMode$ permissiveMode$ = PermissiveMode$.MODULE$;
                            if (!(parseMode != null ? !parseMode.equals(permissiveMode$) : permissiveMode$ != null)) break block24;
                        }
                        throw throwable;
                    }
                    badRecordException = badRecordException.orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)exception));
                    BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
                continue;
            }
            if (xMLEvent instanceof EndElement) {
                shouldStop = StaxXmlParserUtils$.MODULE$.checkEndElement(parser);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        if (!badRecordException.isEmpty()) {
            throw new PartialResultException(Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)row)), (Throwable)badRecordException.get());
        }
        return Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)row));
    }

    private Attribute[] convertObjectWithAttributes$default$4() {
        return (Attribute[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Attribute.class));
    }

    private Attribute[] convertObject$default$4() {
        return (Attribute[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Attribute.class));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$parse$2(XmlOptions options$1, StructField x$1) {
        String string = x$1.name();
        String string2 = options$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final Option failedRecord$1(String record, Throwable cause, Option partialResult, XmlOptions options$1, Function2 toResultRow$1) {
        Some some;
        ParseMode parseMode = options$1.parseMode();
        if (FailFastMode$.MODULE$.equals(parseMode)) {
            throw new IllegalArgumentException(new StringBuilder(33).append("Malformed line in FAILFAST mode: ").append(record.replaceAll("\n", "")).toString(), cause);
        }
        if (DropMalformedMode$.MODULE$.equals(parseMode)) {
            String reason = cause != null ? new StringBuilder(8).append("Reason: ").append(cause.getMessage()).toString() : "";
            this.logger().warn(new StringBuilder(27).append("Dropping malformed line: ").append(record.replaceAll("\n", "")).append(". ").append(reason).toString());
            this.logger().debug("Malformed line cause:", cause);
            some = None$.MODULE$;
        } else if (PermissiveMode$.MODULE$.equals(parseMode)) {
            this.logger().debug("Malformed line cause:", cause);
            some = new Some(toResultRow$1.apply((Object)partialResult, (Object)record));
        } else {
            throw new MatchError((Object)parseMode);
        }
        return some;
    }

    private static final Throwable failedRecord$default$2$1() {
        return null;
    }

    private static final Option failedRecord$default$3$1() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object convertComplicatedType$1(DataType dt, XMLEventReader parser$1, XmlOptions options$2) {
        DataType dataType = dt;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            return this.convertObject(parser$1, structType, options$2, this.convertObject$default$4());
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType dataType2 = mapType.keyType();
            DataType vt = mapType.valueType();
            if (StringType$.MODULE$.equals(dataType2)) {
                return this.convertMap(parser$1, vt, options$2);
            }
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType st = arrayType.elementType();
            return this.convertField(parser$1, st, options$2);
        }
        if (!(dataType instanceof StringType)) throw new MatchError((Object)dataType);
        return StaxXmlParserUtils$.MODULE$.currentStructureAsString(parser$1);
    }

    public static final /* synthetic */ boolean $anonfun$convertField$1(XmlOptions options$2, StructField x$4) {
        String string = x$4.name();
        String string2 = options$2.valueTag();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$convertAttributes$1(StructType schema$2, scala.collection.mutable.Map convertedValuesMap$1, XmlOptions options$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String f = (String)tuple2._1();
        String v = (String)tuple2._2();
        Map nameToIndex = ((TraversableOnce)((IterableLike)schema$2.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.name(), Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        nameToIndex.get((Object)f).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> convertedValuesMap$1.update((Object)f, TypeCast$.MODULE$.convertTo(v, schema$2.apply(i).dataType(), options$3)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$convertObjectWithAttributes$3(StructType schema$3, Object[] row$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String f = (String)tuple2._1();
        Object v = tuple2._2();
        Map nameToIndex = ((TraversableOnce)((IterableLike)schema$3.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.name(), Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        nameToIndex.get((Object)f).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$9 -> {
            row$1[x$9] = v;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$convertObject$2(Map nameToIndex$1, Object[] row$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String f = (String)tuple2._1();
        Object v = tuple2._2();
        nameToIndex$1.get((Object)f).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$11 -> {
            row$2[x$11] = v;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private StaxXmlParser$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

