/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.xml;

import com.databricks.spark.xml.XmlInputFormat$;
import com.databricks.spark.xml.XmlOptions$;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.SplitCompressionInputStream;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\tUa!B\u001a5\u0001Qb\u0004\"\u0002*\u0001\t\u0003!\u0006\"C,\u0001\u0001\u0004\u0005\r\u0011\"\u0003Y\u0011%1\u0007\u00011AA\u0002\u0013%q\rC\u0005o\u0001\u0001\u0007\t\u0011)Q\u00053\"Iq\u000e\u0001a\u0001\u0002\u0004%I\u0001\u0017\u0005\na\u0002\u0001\r\u00111A\u0005\nED\u0011b\u001d\u0001A\u0002\u0003\u0005\u000b\u0015B-\t\u0013Q\u0004\u0001\u0019!a\u0001\n\u0013A\u0006\"C;\u0001\u0001\u0004\u0005\r\u0011\"\u0003w\u0011%A\b\u00011A\u0001B\u0003&\u0011\fC\u0005z\u0001\u0001\u0007\t\u0019!C\u0005u\"I1\u0010\u0001a\u0001\u0002\u0004%I\u0001 \u0005\n}\u0002\u0001\r\u0011!Q!\n%C!b \u0001A\u0002\u0003\u0007I\u0011BA\u0001\u0011-\t\u0019\u0001\u0001a\u0001\u0002\u0004%I!!\u0002\t\u0015\u0005%\u0001\u00011A\u0001B\u0003&q\nC\u0006\u0002\f\u0001\u0001\r\u00111A\u0005\n\u00055\u0001bCA\u000b\u0001\u0001\u0007\t\u0019!C\u0005\u0003/A1\"a\u0007\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0010!Y\u0011Q\u0004\u0001A\u0002\u0003\u0007I\u0011BA\u0007\u0011-\ty\u0002\u0001a\u0001\u0002\u0004%I!!\t\t\u0017\u0005\u0015\u0002\u00011A\u0001B\u0003&\u0011q\u0002\u0005\f\u0003O\u0001\u0001\u0019!a\u0001\n\u0013\tI\u0003C\u0006\u0002:\u0001\u0001\r\u00111A\u0005\n\u0005m\u0002bCA \u0001\u0001\u0007\t\u0011)Q\u0005\u0003WA1\"!\u0011\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002D!Y\u0011\u0011\u000b\u0001A\u0002\u0003\u0007I\u0011BA*\u0011-\t9\u0006\u0001a\u0001\u0002\u0003\u0006K!!\u0012\t\u0017\u0005e\u0003\u00011AA\u0002\u0013%\u00111\f\u0005\f\u0003_\u0002\u0001\u0019!a\u0001\n\u0013\t\t\bC\u0006\u0002v\u0001\u0001\r\u0011!Q!\n\u0005u\u0003bCA<\u0001\u0001\u0007\t\u0019!C\u0005\u0003sB1\"a\"\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\n\"Y\u0011Q\u0012\u0001A\u0002\u0003\u0005\u000b\u0015BA>\u0011-\ty\t\u0001a\u0001\u0002\u0004%I!!%\t\u0017\u0005}\u0005\u00011AA\u0002\u0013%\u0011\u0011\u0015\u0005\f\u0003K\u0003\u0001\u0019!A!B\u0013\t\u0019\nC\u0005\u0002(\u0002\u0001\r\u0011\"\u0003\u0002*\"I\u00111\u0018\u0001A\u0002\u0013%\u0011Q\u0018\u0005\t\u0003\u0003\u0004\u0001\u0015)\u0003\u0002,\"9\u00111\u0019\u0001\u0005B\u0005\u0015\u0007bBAn\u0001\u0011%\u0011Q\u001c\u0005\b\u0003?\u0004A\u0011IAq\u0011\u001d\tI\u000f\u0001C\u0005\u0003WDq!!>\u0001\t\u0013\t\t\u000fC\u0004\u0002x\u0002!I!!?\t\u000f\u0005}\b\u0001\"\u0011\u0003\u0002!9!\u0011\u0002\u0001\u0005B\t-\u0001b\u0002B\u0007\u0001\u0011\u0005#q\u0002\u0005\b\u0005#\u0001A\u0011\u0001B\n\u0005=AV\u000e\u001c*fG>\u0014HMU3bI\u0016\u0014(BA\u001b7\u0003\rAX\u000e\u001c\u0006\u0003oa\nQa\u001d9be.T!!\u000f\u001e\u0002\u0015\u0011\fG/\u00192sS\u000e\\7OC\u0001<\u0003\r\u0019w.\\\n\u0003\u0001u\u0002BAP$J\u001f6\tqH\u0003\u0002A\u0003\u0006IQ.\u00199sK\u0012,8-\u001a\u0006\u0003\u0005\u000e\u000ba\u0001[1e_>\u0004(B\u0001#F\u0003\u0019\t\u0007/Y2iK*\ta)A\u0002pe\u001eL!\u0001S \u0003\u0019I+7m\u001c:e%\u0016\fG-\u001a:\u0011\u0005)kU\"A&\u000b\u00051\u000b\u0015AA5p\u0013\tq5J\u0001\u0007M_:<wK]5uC\ndW\r\u0005\u0002K!&\u0011\u0011k\u0013\u0002\u0005)\u0016DH/\u0001\u0004=S:LGOP\u0002\u0001)\u0005)\u0006C\u0001,\u0001\u001b\u0005!\u0014\u0001C:uCJ$H+Y4\u0016\u0003e\u0003\"AW2\u000f\u0005m\u000b\u0007C\u0001/`\u001b\u0005i&B\u00010T\u0003\u0019a$o\\8u})\t\u0001-A\u0003tG\u0006d\u0017-\u0003\u0002c?\u00061\u0001K]3eK\u001aL!\u0001Z3\u0003\rM#(/\u001b8h\u0015\t\u0011w,\u0001\u0007ti\u0006\u0014H\u000fV1h?\u0012*\u0017\u000f\u0006\u0002iYB\u0011\u0011N[\u0007\u0002?&\u00111n\u0018\u0002\u0005+:LG\u000fC\u0004n\u0007\u0005\u0005\t\u0019A-\u0002\u0007a$\u0013'A\u0005ti\u0006\u0014H\u000fV1hA\u0005y1-\u001e:sK:$8\u000b^1siR\u000bw-A\ndkJ\u0014XM\u001c;Ti\u0006\u0014H\u000fV1h?\u0012*\u0017\u000f\u0006\u0002ie\"9QNBA\u0001\u0002\u0004I\u0016\u0001E2veJ,g\u000e^*uCJ$H+Y4!\u0003\u0019)g\u000e\u001a+bO\u0006QQM\u001c3UC\u001e|F%Z9\u0015\u0005!<\bbB7\n\u0003\u0003\u0005\r!W\u0001\bK:$G+Y4!\u0003)\u0019WO\u001d:f]R\\U-_\u000b\u0002\u0013\u0006q1-\u001e:sK:$8*Z=`I\u0015\fHC\u00015~\u0011\u001diG\"!AA\u0002%\u000b1bY;se\u0016tGoS3zA\u0005a1-\u001e:sK:$h+\u00197vKV\tq*\u0001\tdkJ\u0014XM\u001c;WC2,Xm\u0018\u0013fcR\u0019\u0001.a\u0002\t\u000f5|\u0011\u0011!a\u0001\u001f\u0006i1-\u001e:sK:$h+\u00197vK\u0002\nQa\u001d;beR,\"!a\u0004\u0011\u0007%\f\t\"C\u0002\u0002\u0014}\u0013A\u0001T8oO\u0006I1\u000f^1si~#S-\u001d\u000b\u0004Q\u0006e\u0001\u0002C7\u0013\u0003\u0003\u0005\r!a\u0004\u0002\rM$\u0018M\u001d;!\u0003\r)g\u000eZ\u0001\bK:$w\fJ3r)\rA\u00171\u0005\u0005\t[V\t\t\u00111\u0001\u0002\u0010\u0005!QM\u001c3!\u0003\u0019\u0011X-\u00193feV\u0011\u00111\u0006\t\u0005\u0003[\t)$\u0004\u0002\u00020)\u0019A*!\r\u000b\u0005\u0005M\u0012\u0001\u00026bm\u0006LA!a\u000e\u00020\t1!+Z1eKJ\f!B]3bI\u0016\u0014x\fJ3r)\rA\u0017Q\b\u0005\t[b\t\t\u00111\u0001\u0002,\u00059!/Z1eKJ\u0004\u0013\u0001\u00044jY\u0016\u0004vn]5uS>tWCAA#!\u0011\t9%!\u0014\u000e\u0005\u0005%#bAA&\u0003\u0006\u0011am]\u0005\u0005\u0003\u001f\nIE\u0001\u0005TK\u0016\\\u0017M\u00197f\u0003A1\u0017\u000e\\3Q_NLG/[8o?\u0012*\u0017\u000fF\u0002i\u0003+B\u0001\"\\\u000e\u0002\u0002\u0003\u0007\u0011QI\u0001\u000eM&dW\rU8tSRLwN\u001c\u0011\u0002\u0015\r|WO\u001c;j]\u001eLe.\u0006\u0002\u0002^A!\u0011qLA6\u001b\t\t\tG\u0003\u0003\u0002d\u0005\u0015\u0014!B5oaV$(b\u0001'\u0002h)\u0019\u0011\u0011N\"\u0002\u000f\r|W.\\8og&!\u0011QNA1\u0005M\u0019u.\u001e8uS:<\u0017J\u001c9viN#(/Z1n\u00039\u0019w.\u001e8uS:<\u0017J\\0%KF$2\u0001[A:\u0011!ig$!AA\u0002\u0005u\u0013aC2pk:$\u0018N\\4J]\u0002\n\u0001C]3bI\u0016\u0014()\u001f;f\u0005V4g-\u001a:\u0016\u0005\u0005m\u0004\u0003BA?\u0003\u0007k!!a \u000b\t\u0005\u0005\u0015\u0011G\u0001\u0004]&|\u0017\u0002BAC\u0003\u007f\u0012!BQ=uK\n+hMZ3s\u0003Q\u0011X-\u00193fe\nKH/\u001a\"vM\u001a,'o\u0018\u0013fcR\u0019\u0001.a#\t\u00115\f\u0013\u0011!a\u0001\u0003w\n\u0011C]3bI\u0016\u0014()\u001f;f\u0005V4g-\u001a:!\u00031!WmY8naJ,7o]8s+\t\t\u0019\n\u0005\u0003\u0002\u0016\u0006mUBAAL\u0015\r\tIjS\u0001\tG>l\u0007O]3tg&!\u0011QTAL\u00051!UmY8naJ,7o]8s\u0003A!WmY8naJ,7o]8s?\u0012*\u0017\u000fF\u0002i\u0003GC\u0001\"\u001c\u0013\u0002\u0002\u0003\u0007\u00111S\u0001\u000eI\u0016\u001cw.\u001c9sKN\u001cxN\u001d\u0011\u0002\r\t,hMZ3s+\t\tY\u000b\u0005\u0003\u0002.\u0006]VBAAX\u0015\u0011\t\t,a-\u0002\u000f5,H/\u00192mK*\u0019\u0011QW0\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002:\u0006=&!D*ue&twMQ;jY\u0012,'/\u0001\u0006ck\u001a4WM]0%KF$2\u0001[A`\u0011!iw%!AA\u0002\u0005-\u0016a\u00022vM\u001a,'\u000fI\u0001\u000bS:LG/[1mSj,G#\u00025\u0002H\u0006E\u0007bBAeS\u0001\u0007\u00111Z\u0001\u0006gBd\u0017\u000e\u001e\t\u0004}\u00055\u0017bAAh\u007f\tQ\u0011J\u001c9viN\u0003H.\u001b;\t\u000f\u0005M\u0017\u00061\u0001\u0002V\u000691m\u001c8uKb$\bc\u0001 \u0002X&\u0019\u0011\u0011\\ \u0003%Q\u000b7o[!ui\u0016l\u0007\u000f^\"p]R,\u0007\u0010^\u0001\u0010O\u0016$h)\u001b7f!>\u001c\u0018\u000e^5p]R\u0011\u0011qB\u0001\r]\u0016DHoS3z-\u0006dW/\u001a\u000b\u0003\u0003G\u00042![As\u0013\r\t9o\u0018\u0002\b\u0005>|G.Z1o\u0003\u0011qW\r\u001f;\u0015\r\u0005\r\u0018Q^Ay\u0011\u0019\ty\u000f\fa\u0001\u0013\u0006\u00191.Z=\t\r\u0005MH\u00061\u0001P\u0003\u00151\u0018\r\\;f\u0003U\u0011X-\u00193V]RLGn\u0015;beR,E.Z7f]R\f1C]3bIVsG/\u001b7F]\u0012,E.Z7f]R$B!a9\u0002|\"9\u0011Q \u0018A\u0002\u0005\r\u0018AD:uCJ$H+Y4DY>\u001cX\rZ\u0001\fO\u0016$\bK]8he\u0016\u001c8\u000f\u0006\u0002\u0003\u0004A\u0019\u0011N!\u0002\n\u0007\t\u001dqLA\u0003GY>\fG/A\u0007hKR\u001cUO\u001d:f]R\\U-\u001f\u000b\u0002\u0013\u0006yq-\u001a;DkJ\u0014XM\u001c;WC2,X\rF\u0001P\u0003\u0015\u0019Gn\\:f)\u0005A\u0007")
public class XmlRecordReader
extends RecordReader<LongWritable, Text> {
    private String startTag;
    private String currentStartTag;
    private String endTag;
    private LongWritable currentKey;
    private Text currentValue;
    private long start;
    private long end;
    private Reader reader;
    private Seekable filePosition;
    private CountingInputStream countingIn;
    private ByteBuffer readerByteBuffer;
    private Decompressor decompressor;
    private scala.collection.mutable.StringBuilder buffer = new scala.collection.mutable.StringBuilder();

    private String startTag() {
        return this.startTag;
    }

    private void startTag_$eq(String x$1) {
        this.startTag = x$1;
    }

    private String currentStartTag() {
        return this.currentStartTag;
    }

    private void currentStartTag_$eq(String x$1) {
        this.currentStartTag = x$1;
    }

    private String endTag() {
        return this.endTag;
    }

    private void endTag_$eq(String x$1) {
        this.endTag = x$1;
    }

    private LongWritable currentKey() {
        return this.currentKey;
    }

    private void currentKey_$eq(LongWritable x$1) {
        this.currentKey = x$1;
    }

    private Text currentValue() {
        return this.currentValue;
    }

    private void currentValue_$eq(Text x$1) {
        this.currentValue = x$1;
    }

    private long start() {
        return this.start;
    }

    private void start_$eq(long x$1) {
        this.start = x$1;
    }

    private long end() {
        return this.end;
    }

    private void end_$eq(long x$1) {
        this.end = x$1;
    }

    private Reader reader() {
        return this.reader;
    }

    private void reader_$eq(Reader x$1) {
        this.reader = x$1;
    }

    private Seekable filePosition() {
        return this.filePosition;
    }

    private void filePosition_$eq(Seekable x$1) {
        this.filePosition = x$1;
    }

    private CountingInputStream countingIn() {
        return this.countingIn;
    }

    private void countingIn_$eq(CountingInputStream x$1) {
        this.countingIn = x$1;
    }

    private ByteBuffer readerByteBuffer() {
        return this.readerByteBuffer;
    }

    private void readerByteBuffer_$eq(ByteBuffer x$1) {
        this.readerByteBuffer = x$1;
    }

    private Decompressor decompressor() {
        return this.decompressor;
    }

    private void decompressor_$eq(Decompressor x$1) {
        this.decompressor = x$1;
    }

    private scala.collection.mutable.StringBuilder buffer() {
        return this.buffer;
    }

    private void buffer_$eq(scala.collection.mutable.StringBuilder x$1) {
        this.buffer = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initialize(InputSplit split, TaskAttemptContext context) {
        FileSplit fileSplit = (FileSplit)split;
        Configuration conf = context.getConfiguration();
        Charset charset = Charset.forName(conf.get(XmlInputFormat$.MODULE$.ENCODING_KEY(), XmlOptions$.MODULE$.DEFAULT_CHARSET()));
        this.startTag_$eq(conf.get(XmlInputFormat$.MODULE$.START_TAG_KEY()));
        this.endTag_$eq(conf.get(XmlInputFormat$.MODULE$.END_TAG_KEY()));
        this.start_$eq(fileSplit.getStart());
        this.end_$eq(this.start() + fileSplit.getLength());
        Path path = fileSplit.getPath();
        FileSystem fs = path.getFileSystem(conf);
        FSDataInputStream fsin = fs.open(fileSplit.getPath());
        CountingInputStream in = null;
        CompressionCodec codec = new CompressionCodecFactory(conf).getCodec(path);
        if (codec != null) {
            this.decompressor_$eq(CodecPool.getDecompressor((CompressionCodec)codec));
            CompressionCodec compressionCodec = codec;
            if (compressionCodec instanceof SplittableCompressionCodec) {
                SplittableCompressionCodec splittableCompressionCodec = (SplittableCompressionCodec)compressionCodec;
                SplitCompressionInputStream cIn = splittableCompressionCodec.createInputStream((InputStream)fsin, this.decompressor(), this.start(), this.end(), SplittableCompressionCodec.READ_MODE.BYBLOCK);
                this.start_$eq(cIn.getAdjustedStart());
                this.end_$eq(cIn.getAdjustedEnd());
                in = cIn;
                this.filePosition_$eq((Seekable)cIn);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if (compressionCodec == null) throw new MatchError((Object)compressionCodec);
                CompressionCodec compressionCodec2 = compressionCodec;
                if (this.start() != 0L) {
                    throw new IOException(new StringBuilder(33).append("Cannot seek in ").append(codec.getClass().getSimpleName()).append(" compressed stream").toString());
                }
                CompressionInputStream cIn = compressionCodec2.createInputStream((InputStream)fsin, this.decompressor());
                in = cIn;
                this.filePosition_$eq((Seekable)fsin);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            fsin.seek(this.start());
            this.countingIn_$eq(new CountingInputStream((InputStream)fsin));
            in = this.countingIn();
        }
        this.reader_$eq(new InputStreamReader((InputStream)in, charset));
        if (codec != null) return;
        Field sdField = this.reader().getClass().getDeclaredField("sd");
        sdField.setAccessible(true);
        Object sd = sdField.get(this.reader());
        Field bbField = sd.getClass().getDeclaredField("bb");
        bbField.setAccessible(true);
        this.readerByteBuffer_$eq((ByteBuffer)bbField.get(sd));
    }

    private long getFilePosition() {
        return this.filePosition() != null ? this.filePosition().getPos() : this.start() + this.countingIn().getByteCount() - (long)this.readerByteBuffer().remaining();
    }

    public boolean nextKeyValue() {
        this.currentKey_$eq(new LongWritable());
        this.currentValue_$eq(new Text());
        return this.next(this.currentKey(), this.currentValue());
    }

    private boolean next(LongWritable key, Text value) {
        block4: {
            if (this.readUntilStartElement()) {
                boolean bl;
                try {
                    this.buffer().append(this.currentStartTag());
                    if (!this.readUntilEndElement(this.currentStartTag().endsWith(">"))) break block4;
                    key.set(this.getFilePosition());
                    value.set(this.buffer().toString());
                    bl = true;
                }
                finally {
                    this.buffer_$eq(new scala.collection.mutable.StringBuilder());
                }
                return bl;
            }
        }
        return false;
    }

    private boolean readUntilStartElement() {
        this.currentStartTag_$eq(this.startTag());
        int i = 0;
        int cOrEOF;
        while ((cOrEOF = this.reader().read()) != -1 && (i != 0 || this.getFilePosition() <= this.end())) {
            char c = (char)cOrEOF;
            if (c == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.startTag()), i)) {
                if (i >= this.startTag().length() - 1) {
                    return true;
                }
                ++i;
                continue;
            }
            if (i == this.startTag().length() - 1 && Character.isWhitespace(c)) {
                this.currentStartTag_$eq(new StringBuilder(0).append((String)new StringOps(Predef$.MODULE$.augmentString(this.startTag())).dropRight(1)).append(c).toString());
                return true;
            }
            i = 0;
        }
        return false;
    }

    private boolean readUntilEndElement(boolean startTagClosed) {
        boolean canSelfClose;
        int si = 0;
        int ei = 0;
        int depth = 0;
        int prevC = 0;
        boolean bl = canSelfClose = !startTagClosed;
        int cOrEOF;
        while ((cOrEOF = this.reader().read()) != -1) {
            char c = (char)cOrEOF;
            this.buffer().append(c);
            if (c == '>' && prevC != 47) {
                canSelfClose = false;
            }
            if (c == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.startTag()), si)) {
                if (c == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.endTag()), ei)) {
                    ++si;
                    ++ei;
                } else if (si >= this.startTag().length() - 1) {
                    si = 0;
                    ei = 0;
                    ++depth;
                } else {
                    ++si;
                    ei = 0;
                }
            } else if (c == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.endTag()), ei)) {
                if (ei >= this.endTag().length() - 1) {
                    if (depth == 0) {
                        return true;
                    }
                    si = 0;
                    ei = 0;
                    --depth;
                } else {
                    si = 0;
                    ++ei;
                }
            } else if (c == '>' && prevC == 47 && canSelfClose) {
                if (depth == 0) {
                    return true;
                }
                si = 0;
                ei = 0;
                --depth;
            } else if (si == this.startTag().length() - 1 && Character.isWhitespace(c)) {
                si = 0;
                ei = 0;
                ++depth;
            } else {
                si = 0;
                ei = 0;
            }
            prevC = c;
        }
        return false;
    }

    public float getProgress() {
        return this.start() == this.end() ? 0.0f : package$.MODULE$.min(1.0f, (float)((double)(this.getFilePosition() - this.start()) / (double)(this.end() - this.start())));
    }

    public LongWritable getCurrentKey() {
        return this.currentKey();
    }

    public Text getCurrentValue() {
        return this.currentValue();
    }

    public void close() {
        try {
            if (this.reader() != null) {
                this.reader().close();
                this.reader_$eq(null);
            }
        }
        finally {
            if (this.decompressor() != null) {
                CodecPool.returnDecompressor((Decompressor)this.decompressor());
                this.decompressor_$eq(null);
            }
        }
    }
}

