/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.redshift;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import com.databricks.spark.redshift.DefaultJDBCWrapper$;
import com.databricks.spark.redshift.DefaultRedshiftWriter$;
import com.databricks.spark.redshift.Parameters;
import com.databricks.spark.redshift.Parameters$;
import com.databricks.spark.redshift.RedshiftInputFormat;
import com.databricks.spark.redshift.RedshiftRelation;
import com.databricks.spark.redshift.SchemaParser$;
import com.databricks.spark.redshift.package$;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001u<Q!\u0001\u0002\t\u0002-\tq\u0001]1dW\u0006<WM\u0003\u0002\u0004\t\u0005A!/\u001a3tQ&4GO\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\u000bI\u0006$\u0018M\u0019:jG.\u001c(\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0011\u00051iQ\"\u0001\u0002\u0007\u000b9\u0011\u0001\u0012A\b\u0003\u000fA\f7m[1hKN\u0011Q\u0002\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000b]iA\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005Ya\u0001\u0002\u000e\u000e\u0003m\u0011qBU3eg\"Lg\r^\"p]R,\u0007\u0010^\n\u00033AA\u0001\"H\r\u0003\u0002\u0003\u0006IAH\u0001\u000bgFd7i\u001c8uKb$\bCA\u0010(\u001b\u0005\u0001#BA\u0011#\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\rR!\u0001J\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0013aA8sO&\u0011\u0001\u0006\t\u0002\u000b'Fc5i\u001c8uKb$\b\"B\f\u001a\t\u0003QCCA\u0016.!\ta\u0013$D\u0001\u000e\u0011\u0015i\u0012\u00061\u0001\u001f\u0011\u0015y\u0013\u0004\"\u00011\u00031\u0011X\rZ:iS\u001a$h)\u001b7f)\r\tD'\u0010\t\u0003?IJ!a\r\u0011\u0003\u0013\u0011\u000bG/\u0019$sC6,\u0007\"B\u001b/\u0001\u00041\u0014\u0001\u00029bi\"\u0004\"a\u000e\u001e\u000f\u0005EA\u0014BA\u001d\u0013\u0003\u0019\u0001&/\u001a3fM&\u00111\b\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e\u0012\u0002\"\u0002 /\u0001\u0004y\u0014aB2pYVlgn\u001d\t\u0004\u0001\u001e3dBA!G\u001d\t\u0011U)D\u0001D\u0015\t!%\"\u0001\u0004=e>|GOP\u0005\u0002'%\u0011\u0011AE\u0005\u0003\u0011&\u00131aU3r\u0015\t\t!\u0003C\u000303\u0011\u00051\nF\u00022\u00196CQ!\u000e&A\u0002YBQA\u0014&A\u0002Y\naa]2iK6\f\u0007\u0006\u0002&Q'V\u0003\"!E)\n\u0005I\u0013\"A\u00033faJ,7-\u0019;fI\u0006\nA+\u0001\"Vg\u0016\u0004C-\u0019;bAM|WO]2fg\u0002\n\u0005+\u0013\u0011pe\u0002\u0002XM\u001d4pe6\u00043\u000f\u001e:j]\u001e\u0004SF\u0010\u0011eCR\f\u0007\u0005^=qK\u0002\u001a\u0017m\u001d;tAe|WO]:fY\u001a\f\u0013AV\u0001\u0006a9*d\u0006\r\u0005\u00061f!\t!W\u0001\u000ee\u0016$7\u000f[5giR\u000b'\r\\3\u0015\u0005ER\u0006\"B.X\u0001\u0004a\u0016A\u00039be\u0006lW\r^3sgB!q'\u0018\u001c7\u0013\tqFHA\u0002NCBDCa\u0016)a+\u0006\n\u0011-A\u000bVg\u0016\u00043/\u001d7D_:$X\r\u001f;/e\u0016\fG\rK\u0015\t\u000f\rl\u0011\u0011!C\u0002I\u0006y!+\u001a3tQ&4GoQ8oi\u0016DH\u000f\u0006\u0002,K\")QD\u0019a\u0001=\u0019!q-D\u0001i\u0005E\u0011V\rZ:iS\u001a$H)\u0019;b\rJ\fW.Z\n\u0003MBA\u0001B\u001b4\u0003\u0002\u0003\u0006I!M\u0001\nI\u0006$\u0018M\u0012:b[\u0016DQa\u00064\u0005\u00021$\"!\u001c8\u0011\u000512\u0007\"\u00026l\u0001\u0004\t\u0004\"\u00029g\t\u0003\t\u0018aE:bm\u0016\f5OU3eg\"Lg\r\u001e+bE2,GC\u0001:v!\t\t2/\u0003\u0002u%\t!QK\\5u\u0011\u0015Yv\u000e1\u0001]Q\u0011y\u0007k^+\"\u0003a\fQ#V:fA\u0011\u000bG/\u0019$sC6,gf\u001e:ji\u0016D\u0013\u0006C\u0004{\u001b\u0005\u0005I1A>\u0002#I+Gm\u001d5jMR$\u0015\r^1Ge\u0006lW\r\u0006\u0002ny\")!.\u001fa\u0001c\u0001")
public final class package {
    public static RedshiftDataFrame RedshiftDataFrame(DataFrame dataFrame) {
        return package$.MODULE$.RedshiftDataFrame(dataFrame);
    }

    public static RedshiftContext RedshiftContext(SQLContext sQLContext) {
        return package$.MODULE$.RedshiftContext(sQLContext);
    }

    public static class RedshiftContext {
        private final SQLContext sqlContext;

        public DataFrame redshiftFile(String path, Seq<String> columns) {
            SparkContext sc = this.sqlContext.sparkContext();
            RDD rdd = sc.newAPIHadoopFile(path, RedshiftInputFormat.class, Long.class, String[].class, sc.hadoopConfiguration());
            RDD nullable = RDD$.MODULE$.rddToPairRDDFunctions(rdd, ClassTag$.MODULE$.apply(Long.class), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())).values().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String[] apply(String[] x$1) {
                    return (String[])Predef$.MODULE$.refArrayOps((Object[])x$1).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String f) {
                            return f.isEmpty() ? null : f;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                }
            }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Row apply(String[] x) {
                    return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)x));
                }
            }, ClassTag$.MODULE$.apply(Row.class));
            StructType schema2 = StructType$.MODULE$.apply((Seq)columns.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final StructField apply(String c) {
                    return new StructField(c, (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
                }
            }, Seq$.MODULE$.canBuildFrom()));
            return this.sqlContext.createDataFrame(nullable, schema2);
        }

        public DataFrame redshiftFile(String path, String schema2) {
            StructType structType = SchemaParser$.MODULE$.parseSchema(schema2);
            Column[] casts = (Column[])Predef$.MODULE$.refArrayOps((Object[])structType.fields()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Column apply(StructField field) {
                    return functions$.MODULE$.col(field.name()).cast(field.dataType()).as(field.name());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
            return this.redshiftFile(path, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])structType.fieldNames())).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])casts));
        }

        public DataFrame redshiftTable(Map<String, String> parameters) {
            Parameters.MergedParameters params = Parameters$.MODULE$.mergeParameters(parameters);
            return this.sqlContext.baseRelationToDataFrame((BaseRelation)new RedshiftRelation(DefaultJDBCWrapper$.MODULE$, (Function1<AWSCredentials, AmazonS3Client>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final AmazonS3Client apply(AWSCredentials creds) {
                    return new AmazonS3Client(creds);
                }
            }, params, (Option<StructType>)None$.MODULE$, this.sqlContext));
        }

        public RedshiftContext(SQLContext sqlContext) {
            this.sqlContext = sqlContext;
        }
    }

    public static class RedshiftDataFrame {
        private final DataFrame dataFrame;

        public void saveAsRedshiftTable(Map<String, String> parameters) {
            Parameters.MergedParameters params = Parameters$.MODULE$.mergeParameters(parameters);
            SaveMode saveMode = params.overwrite() ? SaveMode.Overwrite : SaveMode.Append;
            DefaultRedshiftWriter$.MODULE$.saveToRedshift(this.dataFrame.sqlContext(), this.dataFrame, saveMode, params);
        }

        public RedshiftDataFrame(DataFrame dataFrame) {
            this.dataFrame = dataFrame;
        }
    }
}

