/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.redshift;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;

class S3Credentials {
    private String accessKey;
    private String secretAccessKey;

    S3Credentials() {
    }

    public void initialize(URI uRI, Configuration configuration) {
        if (uRI.getHost() == null) {
            throw new IllegalArgumentException("Invalid hostname in URI " + uRI);
        }
        String string = uRI.getUserInfo();
        if (string != null) {
            int n = string.indexOf(58);
            if (n != -1) {
                this.accessKey = string.substring(0, n);
                this.secretAccessKey = string.substring(n + 1);
            } else {
                this.accessKey = string;
            }
        }
        String string2 = uRI.getScheme();
        String string3 = String.format("fs.%s.awsAccessKeyId", string2);
        String string4 = String.format("fs.%s.awsSecretAccessKey", string2);
        if (this.accessKey == null) {
            this.accessKey = configuration.get(string3);
        }
        if (this.secretAccessKey == null) {
            this.secretAccessKey = configuration.get(string4);
        }
        if (this.accessKey == null && this.secretAccessKey == null) {
            throw new IllegalArgumentException("AWS Access Key ID and Secret Access Key must be specified as the username or password (respectively) of a " + string2 + " URL, or by setting the " + string3 + " or " + string4 + " properties (respectively).");
        }
        if (this.accessKey == null) {
            throw new IllegalArgumentException("AWS Access Key ID must be specified as the username of a " + string2 + " URL, or by setting the " + string3 + " property.");
        }
        if (this.secretAccessKey == null) {
            throw new IllegalArgumentException("AWS Secret Access Key must be specified as the password of a " + string2 + " URL, or by setting the " + string4 + " property.");
        }
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }
}

