/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.spark.redshift;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.databricks.spark.redshift.Parameters;
import com.databricks.spark.redshift.S3Credentials;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.StringBuilder;

public final class AWSCredentialsUtils$ {
    public static final AWSCredentialsUtils$ MODULE$;

    static {
        new AWSCredentialsUtils$();
    }

    public String getRedshiftCredentialsString(Parameters.MergedParameters params, AWSCredentials awsCredentials) {
        return (String)params.iamRole().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String role) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aws_iam_role=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{role}));
            }
        }).getOrElse((Function0)new Serializable(awsCredentials){
            public static final long serialVersionUID = 0L;
            private final AWSCredentials awsCredentials$1;

            public final String apply() {
                String string;
                AWSCredentials aWSCredentials = this.awsCredentials$1;
                if (aWSCredentials instanceof AWSSessionCredentials) {
                    AWSSessionCredentials aWSSessionCredentials = (AWSSessionCredentials)aWSCredentials;
                    string = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aws_access_key_id=", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{aWSSessionCredentials.getAWSAccessKeyId()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aws_secret_access_key=", ";token=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{aWSSessionCredentials.getAWSSecretKey(), aWSSessionCredentials.getSessionToken()}))).toString();
                } else {
                    string = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aws_access_key_id=", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{aWSCredentials.getAWSAccessKeyId()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aws_secret_access_key=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{aWSCredentials.getAWSSecretKey()}))).toString();
                }
                return string;
            }
            {
                this.awsCredentials$1 = awsCredentials$1;
            }
        });
    }

    public AWSCredentials load(Parameters.MergedParameters params, Configuration hadoopConfiguration) {
        return (AWSCredentials)params.temporaryAWSCredentials().getOrElse((Function0)new Serializable(params, hadoopConfiguration){
            public static final long serialVersionUID = 0L;
            private final Parameters.MergedParameters params$1;
            private final Configuration hadoopConfiguration$1;

            public final AWSCredentials apply() {
                return AWSCredentialsUtils$.MODULE$.com$databricks$spark$redshift$AWSCredentialsUtils$$loadFromURI(this.params$1.rootTempDir(), this.hadoopConfiguration$1);
            }
            {
                this.params$1 = params$1;
                this.hadoopConfiguration$1 = hadoopConfiguration$1;
            }
        });
    }

    public AWSCredentials com$databricks$spark$redshift$AWSCredentialsUtils$$loadFromURI(String tempPath, Configuration hadoopConfiguration) {
        String string;
        block4: {
            BasicAWSCredentials basicAWSCredentials;
            block3: {
                URI uri;
                block2: {
                    uri = new URI(tempPath);
                    string = uri.getScheme();
                    boolean bl = "s3".equals(string) ? true : "s3n".equals(string);
                    if (!bl) break block2;
                    S3Credentials creds = new S3Credentials();
                    creds.initialize(uri, hadoopConfiguration);
                    basicAWSCredentials = new BasicAWSCredentials(creds.getAccessKey(), creds.getSecretAccessKey());
                    break block3;
                }
                if (!"s3a".equals(string)) break block4;
                basicAWSCredentials = (AWSCredentials)Option$.MODULE$.apply((Object)uri.getUserInfo()).flatMap((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Option<BasicAWSCredentials> apply(String userInfo) {
                        None$ none$;
                        if (userInfo.contains(":")) {
                            Tuple2 tuple2;
                            String[] stringArray = userInfo.split(":");
                            Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) throw new MatchError((Object)stringArray);
                            String accessKey = (String)((SeqLike)option.get()).apply(0);
                            String secretKey = (String)((SeqLike)option.get()).apply(1);
                            Tuple2 tuple22 = tuple2 = new Tuple2((Object)accessKey, (Object)secretKey);
                            String accessKey2 = (String)tuple22._1();
                            String secretKey2 = (String)tuple22._2();
                            none$ = new Some((Object)new BasicAWSCredentials(accessKey2, secretKey2));
                            return none$;
                        } else {
                            none$ = None$.MODULE$;
                        }
                        return none$;
                    }
                }).orElse((Function0)new Serializable(hadoopConfiguration){
                    public static final long serialVersionUID = 0L;
                    private final Configuration hadoopConfiguration$2;

                    public final Option<BasicAWSCredentials> apply() {
                        String accessKey = this.hadoopConfiguration$2.get("fs.s3a.access.key", null);
                        String secretKey = this.hadoopConfiguration$2.get("fs.s3a.secret.key", null);
                        return accessKey == null || secretKey == null ? None$.MODULE$ : new Some((Object)new BasicAWSCredentials(accessKey, secretKey));
                    }
                    {
                        this.hadoopConfiguration$2 = hadoopConfiguration$2;
                    }
                }).getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final AWSCredentials apply() {
                        return new InstanceProfileCredentialsProvider().getCredentials();
                    }
                });
            }
            return basicAWSCredentials;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unrecognized scheme ", "; expected s3, s3n, or s3a"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
    }

    private AWSCredentialsUtils$() {
        MODULE$ = this;
    }
}

