/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.deltaoms.process;

import com.databricks.labs.deltaoms.common.BatchOMSRunner;
import com.databricks.labs.deltaoms.common.OMSInitializer;
import com.databricks.labs.deltaoms.common.OMSOperations;
import com.databricks.labs.deltaoms.common.OMSRunner;
import com.databricks.labs.deltaoms.common.Schemas;
import com.databricks.labs.deltaoms.common.Utils$;
import com.databricks.labs.deltaoms.configuration.ConfigurationSettings;
import com.databricks.labs.deltaoms.configuration.Environment;
import com.databricks.labs.deltaoms.configuration.OMSConfig;
import com.databricks.labs.deltaoms.configuration.SparkSettings;
import com.databricks.labs.deltaoms.model.PathConfig;
import com.databricks.labs.deltaoms.model.SourceConfig;
import com.databricks.labs.deltaoms.model.StreamTargetInfo;
import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$implicits$;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;

public final class OMSProcessRawActions$
implements BatchOMSRunner {
    public static OMSProcessRawActions$ MODULE$;
    private final SparkSession$implicits$ implicits;
    private final String OMS_VERSION;
    private final StructType rawAction;
    private final StructType commitSnapshot;
    private final StructType addFile;
    private final StructType actionSnapshot;
    private final StructType pathConfig;
    private final StructType sourceConfig;
    private final StructType processedHistory;
    private final SparkSession sparkSession;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new OMSProcessRawActions$();
    }

    @Override
    public OMSConfig getValidatedOMSConfig(OMSConfig config) {
        return BatchOMSRunner.getValidatedOMSConfig$(this, config);
    }

    @Override
    public void setTrackingHeader() {
        OMSRunner.setTrackingHeader$(this);
    }

    @Override
    public OMSConfig consolidateOMSConfig() {
        return OMSRunner.consolidateOMSConfig$(this);
    }

    @Override
    public void updateOMSPathConfigFromSourceConfig(OMSConfig config) {
        OMSOperations.updateOMSPathConfigFromSourceConfig$(this, config);
    }

    @Override
    public SourceConfig[] fetchSourceConfigForProcessing(OMSConfig config) {
        return OMSOperations.fetchSourceConfigForProcessing$(this, config);
    }

    @Override
    public Dataset<SourceConfig> processWildcardDirectories(Dataset<Row> sourceConfigs) {
        return OMSOperations.processWildcardDirectories$(this, sourceConfigs);
    }

    @Override
    public void updateOMSPathConfigFromList(Seq<SourceConfig> sourceConfigs, String pathConfigTableName, boolean truncate) {
        OMSOperations.updateOMSPathConfigFromList$(this, sourceConfigs, pathConfigTableName, truncate);
    }

    @Override
    public boolean updateOMSPathConfigFromList$default$3() {
        return OMSOperations.updateOMSPathConfigFromList$default$3$(this);
    }

    @Override
    public Dataset<PathConfig> tablePathToPathConfig(Dataset<Row> tablePaths) {
        return OMSOperations.tablePathToPathConfig$(this, tablePaths);
    }

    @Override
    public void updatePathConfigToOMS(Dataset<PathConfig> pathConfigs, String pathConfigTableName, boolean truncate) {
        OMSOperations.updatePathConfigToOMS$(this, pathConfigs, pathConfigTableName, truncate);
    }

    @Override
    public boolean updatePathConfigToOMS$default$3() {
        return OMSOperations.updatePathConfigToOMS$default$3$(this);
    }

    @Override
    public void streamingUpdateRawDeltaActionsToOMS(OMSConfig config) {
        OMSOperations.streamingUpdateRawDeltaActionsToOMS$(this, config);
    }

    @Override
    public Tuple2<String, StreamingQuery> processDeltaLogStreams(Tuple2<Dataset<Row>, StreamTargetInfo> streamTargetAndLog, Option<String> triggerIntervalOption) {
        return OMSOperations.processDeltaLogStreams$(this, streamTargetAndLog, triggerIntervalOption);
    }

    @Override
    public void insertRawDeltaLogs(String rawActionsTableUrl, Dataset<Row> newDeltaLogDF, long batchId) {
        OMSOperations.insertRawDeltaLogs$(this, rawActionsTableUrl, newDeltaLogDF, batchId);
    }

    @Override
    public Seq<Tuple2<String, String>> fetchPathForStreamProcessing(String pathConfigTableUrl, boolean useWildCardPath, int startingStream, int endingStream) {
        return OMSOperations.fetchPathForStreamProcessing$(this, pathConfigTableUrl, useWildCardPath, startingStream, endingStream);
    }

    @Override
    public boolean fetchPathForStreamProcessing$default$2() {
        return OMSOperations.fetchPathForStreamProcessing$default$2$(this);
    }

    @Override
    public int fetchPathForStreamProcessing$default$3() {
        return OMSOperations.fetchPathForStreamProcessing$default$3$(this);
    }

    @Override
    public int fetchPathForStreamProcessing$default$4() {
        return OMSOperations.fetchPathForStreamProcessing$default$4$(this);
    }

    @Override
    public Dataset<PathConfig> fetchPathConfigForProcessing(String pathConfigTableUrl) {
        return OMSOperations.fetchPathConfigForProcessing$(this, pathConfigTableUrl);
    }

    @Override
    public Option<Tuple2<Dataset<Row>, StreamTargetInfo>> fetchStreamTargetAndDeltaLogForPath(Tuple2<String, String> pathInfo, String checkpointBaseDir, String checkpointSuffix, String rawActionsTableUrl, boolean useAutoLoader, String maxFilesPerTrigger) {
        return OMSOperations.fetchStreamTargetAndDeltaLogForPath$(this, pathInfo, checkpointBaseDir, checkpointSuffix, rawActionsTableUrl, useAutoLoader, maxFilesPerTrigger);
    }

    @Override
    public Option<Dataset<Row>> fetchStreamingDeltaLogForPath(String path, boolean useAutoloader, String maxFilesPerTrigger) {
        return OMSOperations.fetchStreamingDeltaLogForPath$(this, path, useAutoloader, maxFilesPerTrigger);
    }

    @Override
    public boolean fetchStreamingDeltaLogForPath$default$2() {
        return OMSOperations.fetchStreamingDeltaLogForPath$default$2$(this);
    }

    @Override
    public String fetchStreamingDeltaLogForPath$default$3() {
        return OMSOperations.fetchStreamingDeltaLogForPath$default$3$(this);
    }

    @Override
    public Option<Dataset<Row>> getDeltaLogs(StructType schema, String path, String maxFilesPerTrigger) {
        return OMSOperations.getDeltaLogs$(this, schema, path, maxFilesPerTrigger);
    }

    @Override
    public String getDeltaLogs$default$3() {
        return OMSOperations.getDeltaLogs$default$3$(this);
    }

    @Override
    public long getCurrentRawActionsVersion(String rawActionsTableUrl) {
        return OMSOperations.getCurrentRawActionsVersion$(this, rawActionsTableUrl);
    }

    @Override
    public long getLastProcessedRawActionsVersion(String processedHistoryTableUrl, String rawActionTable) {
        return OMSOperations.getLastProcessedRawActionsVersion$(this, processedHistoryTableUrl, rawActionTable);
    }

    @Override
    public long getLatestRawActionsVersion(Dataset<Row> rawActions) {
        return OMSOperations.getLatestRawActionsVersion$(this, rawActions);
    }

    @Override
    public void updateLastProcessedRawActions(long latestVersion, String rawActionTable, String processedHistoryTableUrl) {
        OMSOperations.updateLastProcessedRawActions$(this, latestVersion, rawActionTable, processedHistoryTableUrl);
    }

    @Override
    public Dataset<Row> getUpdatedRawActions(long lastProcessedVersion, String rawActionsTableUrl) {
        return OMSOperations.getUpdatedRawActions$(this, lastProcessedVersion, rawActionsTableUrl);
    }

    @Override
    public void processCommitInfoFromRawActions(Dataset<Row> rawActions, String commitSnapshotTableUrl) {
        OMSOperations.processCommitInfoFromRawActions$(this, rawActions, commitSnapshotTableUrl);
    }

    @Override
    public void processActionSnapshotsFromRawActions(Dataset<Row> rawActions, String actionSnapshotTableUrl) {
        OMSOperations.processActionSnapshotsFromRawActions$(this, rawActions, actionSnapshotTableUrl);
    }

    @Override
    public Dataset<Row> computeActionSnapshotFromRawActions(Dataset<Row> rawActions, boolean snapshotEmpty, String actionSnapshotTableUrl) {
        return OMSOperations.computeActionSnapshotFromRawActions$(this, rawActions, snapshotEmpty, actionSnapshotTableUrl);
    }

    @Override
    public Dataset<Row> prepareAddRemoveActionsFromRawActions(Dataset<Row> rawActions) {
        return OMSOperations.prepareAddRemoveActionsFromRawActions$(this, rawActions);
    }

    @Override
    public Dataset<Row> computeCumulativeFilesFromAddRemoveActions(Dataset<Row> addRemoveActions) {
        return OMSOperations.computeCumulativeFilesFromAddRemoveActions$(this, addRemoveActions);
    }

    @Override
    public Dataset<Row> deriveActionSnapshotFromCumulativeActions(Dataset<Row> cumulativeAddRemoveFiles) {
        return OMSOperations.deriveActionSnapshotFromCumulativeActions$(this, cumulativeAddRemoveFiles);
    }

    @Override
    public void initializeOMS(OMSConfig config, boolean dropAndRecreate) {
        OMSInitializer.initializeOMS$(this, config, dropAndRecreate);
    }

    @Override
    public boolean initializeOMS$default$2() {
        return OMSInitializer.initializeOMS$default$2$(this);
    }

    @Override
    public void createOMSSchema(OMSConfig config) {
        OMSInitializer.createOMSSchema$(this, config);
    }

    @Override
    public void createOMSTables(OMSConfig config) {
        OMSInitializer.createOMSTables$(this, config);
    }

    @Override
    public void cleanupOMS(OMSConfig config) {
        OMSInitializer.cleanupOMS$(this, config);
    }

    @Override
    public SparkSession spark() {
        return SparkSettings.spark$(this);
    }

    @Override
    public OMSConfig omsConfig() {
        return ConfigurationSettings.omsConfig$(this);
    }

    @Override
    public OMSConfig omsConfigSource() {
        return ConfigurationSettings.omsConfigSource$(this);
    }

    @Override
    public Environment environment() {
        return ConfigurationSettings.environment$(this);
    }

    @Override
    public String environmentType() {
        return ConfigurationSettings.environmentType$(this);
    }

    @Override
    public void validateOMSConfig(OMSConfig omsConfig, boolean isBatch) {
        ConfigurationSettings.validateOMSConfig$(this, omsConfig, isBatch);
    }

    @Override
    public boolean validateOMSConfig$default$2() {
        return ConfigurationSettings.validateOMSConfig$default$2$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public SparkSession$implicits$ implicits() {
        return this.implicits;
    }

    @Override
    public void com$databricks$labs$deltaoms$common$OMSOperations$_setter_$implicits_$eq(SparkSession$implicits$ x$1) {
        this.implicits = x$1;
    }

    @Override
    public final String OMS_VERSION() {
        return this.OMS_VERSION;
    }

    @Override
    public final StructType rawAction() {
        return this.rawAction;
    }

    @Override
    public final StructType commitSnapshot() {
        return this.commitSnapshot;
    }

    @Override
    public StructType addFile() {
        return this.addFile;
    }

    @Override
    public final StructType actionSnapshot() {
        return this.actionSnapshot;
    }

    @Override
    public final StructType pathConfig() {
        return this.pathConfig;
    }

    @Override
    public final StructType sourceConfig() {
        return this.sourceConfig;
    }

    @Override
    public final StructType processedHistory() {
        return this.processedHistory;
    }

    @Override
    public final void com$databricks$labs$deltaoms$common$Schemas$_setter_$OMS_VERSION_$eq(String x$1) {
        this.OMS_VERSION = x$1;
    }

    @Override
    public final void com$databricks$labs$deltaoms$common$Schemas$_setter_$rawAction_$eq(StructType x$1) {
        this.rawAction = x$1;
    }

    @Override
    public final void com$databricks$labs$deltaoms$common$Schemas$_setter_$commitSnapshot_$eq(StructType x$1) {
        this.commitSnapshot = x$1;
    }

    @Override
    public void com$databricks$labs$deltaoms$common$Schemas$_setter_$addFile_$eq(StructType x$1) {
        this.addFile = x$1;
    }

    @Override
    public final void com$databricks$labs$deltaoms$common$Schemas$_setter_$actionSnapshot_$eq(StructType x$1) {
        this.actionSnapshot = x$1;
    }

    @Override
    public final void com$databricks$labs$deltaoms$common$Schemas$_setter_$pathConfig_$eq(StructType x$1) {
        this.pathConfig = x$1;
    }

    @Override
    public final void com$databricks$labs$deltaoms$common$Schemas$_setter_$sourceConfig_$eq(StructType x$1) {
        this.sourceConfig = x$1;
    }

    @Override
    public final void com$databricks$labs$deltaoms$common$Schemas$_setter_$processedHistory_$eq(StructType x$1) {
        this.processedHistory = x$1;
    }

    @Override
    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    @Override
    public void com$databricks$labs$deltaoms$configuration$SparkSettings$_setter_$sparkSession_$eq(SparkSession x$1) {
        this.sparkSession = x$1;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void main(String[] args) {
        block0: {
            this.spark().conf().set("spark.databricks.labs.deltaoms.class", this.getClass().getCanonicalName());
            OMSConfig consolidatedOMSConfig = this.consolidateOMSConfig();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Starting processing the OMS Raw Data : ").append(consolidatedOMSConfig).toString());
            long currentRawActionsVersion = this.getCurrentRawActionsVersion(Utils$.MODULE$.getRawActionsTableUrl(consolidatedOMSConfig));
            long lastProcessedRawActionsVersion = this.getLastProcessedRawActionsVersion(Utils$.MODULE$.getProcessedHistoryTableUrl(consolidatedOMSConfig), consolidatedOMSConfig.rawActionTable());
            if (currentRawActionsVersion != 0L && lastProcessedRawActionsVersion >= currentRawActionsVersion) break block0;
            Dataset<Row> newRawActions = this.getUpdatedRawActions(lastProcessedRawActionsVersion, Utils$.MODULE$.getRawActionsTableUrl(consolidatedOMSConfig));
            this.processCommitInfoFromRawActions(newRawActions, Utils$.MODULE$.getCommitSnapshotsTableUrl(consolidatedOMSConfig));
            this.processActionSnapshotsFromRawActions(newRawActions, Utils$.MODULE$.getActionSnapshotsTableUrl(consolidatedOMSConfig));
            long latestRawActionVersion = this.getLatestRawActionsVersion(newRawActions);
            this.updateLastProcessedRawActions(latestRawActionVersion, consolidatedOMSConfig.rawActionTable(), Utils$.MODULE$.getProcessedHistoryTableUrl(consolidatedOMSConfig));
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    private OMSProcessRawActions$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        ConfigurationSettings.$init$(this);
        SparkSettings.$init$(this);
        OMSInitializer.$init$(this);
        Schemas.$init$(this);
        OMSOperations.$init$(this);
        OMSRunner.$init$(this);
        BatchOMSRunner.$init$(this);
    }
}

