/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.workspace;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.workspace.AclItem;
import com.databricks.sdk.service.workspace.AclPermission;
import com.databricks.sdk.service.workspace.CreateScope;
import com.databricks.sdk.service.workspace.DeleteAcl;
import com.databricks.sdk.service.workspace.DeleteScope;
import com.databricks.sdk.service.workspace.DeleteSecret;
import com.databricks.sdk.service.workspace.GetAclRequest;
import com.databricks.sdk.service.workspace.GetSecretRequest;
import com.databricks.sdk.service.workspace.GetSecretResponse;
import com.databricks.sdk.service.workspace.ListAclsRequest;
import com.databricks.sdk.service.workspace.ListAclsResponse;
import com.databricks.sdk.service.workspace.ListScopesResponse;
import com.databricks.sdk.service.workspace.ListSecretsRequest;
import com.databricks.sdk.service.workspace.ListSecretsResponse;
import com.databricks.sdk.service.workspace.PutAcl;
import com.databricks.sdk.service.workspace.PutSecret;
import com.databricks.sdk.service.workspace.SecretMetadata;
import com.databricks.sdk.service.workspace.SecretScope;
import com.databricks.sdk.service.workspace.SecretsImpl;
import com.databricks.sdk.service.workspace.SecretsService;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class SecretsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(SecretsAPI.class);
    private final SecretsService impl;

    public SecretsAPI(ApiClient apiClient) {
        this.impl = new SecretsImpl(apiClient);
    }

    public SecretsAPI(SecretsService mock) {
        this.impl = mock;
    }

    public void createScope(String scope) {
        this.createScope(new CreateScope().setScope(scope));
    }

    public void createScope(CreateScope request) {
        this.impl.createScope(request);
    }

    public void deleteAcl(String scope, String principal) {
        this.deleteAcl(new DeleteAcl().setScope(scope).setPrincipal(principal));
    }

    public void deleteAcl(DeleteAcl request) {
        this.impl.deleteAcl(request);
    }

    public void deleteScope(String scope) {
        this.deleteScope(new DeleteScope().setScope(scope));
    }

    public void deleteScope(DeleteScope request) {
        this.impl.deleteScope(request);
    }

    public void deleteSecret(String scope, String key) {
        this.deleteSecret(new DeleteSecret().setScope(scope).setKey(key));
    }

    public void deleteSecret(DeleteSecret request) {
        this.impl.deleteSecret(request);
    }

    public AclItem getAcl(String scope, String principal) {
        return this.getAcl(new GetAclRequest().setScope(scope).setPrincipal(principal));
    }

    public AclItem getAcl(GetAclRequest request) {
        return this.impl.getAcl(request);
    }

    public GetSecretResponse getSecret(String scope, String key) {
        return this.getSecret(new GetSecretRequest().setScope(scope).setKey(key));
    }

    public GetSecretResponse getSecret(GetSecretRequest request) {
        return this.impl.getSecret(request);
    }

    public Iterable<AclItem> listAcls(String scope) {
        return this.listAcls(new ListAclsRequest().setScope(scope));
    }

    public Iterable<AclItem> listAcls(ListAclsRequest request) {
        return new Paginator(request, this.impl::listAcls, ListAclsResponse::getItems, response -> null);
    }

    public Iterable<SecretScope> listScopes() {
        return new Paginator(null, v -> this.impl.listScopes(), ListScopesResponse::getScopes, response -> null);
    }

    public Iterable<SecretMetadata> listSecrets(String scope) {
        return this.listSecrets(new ListSecretsRequest().setScope(scope));
    }

    public Iterable<SecretMetadata> listSecrets(ListSecretsRequest request) {
        return new Paginator(request, this.impl::listSecrets, ListSecretsResponse::getSecrets, response -> null);
    }

    public void putAcl(String scope, String principal, AclPermission permission) {
        this.putAcl(new PutAcl().setScope(scope).setPrincipal(principal).setPermission(permission));
    }

    public void putAcl(PutAcl request) {
        this.impl.putAcl(request);
    }

    public void putSecret(String scope, String key) {
        this.putSecret(new PutSecret().setScope(scope).setKey(key));
    }

    public void putSecret(PutSecret request) {
        this.impl.putSecret(request);
    }

    public SecretsService impl() {
        return this.impl;
    }
}

