/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.vectorsearch;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.service.vectorsearch.CreateEndpoint;
import com.databricks.sdk.service.vectorsearch.DeleteEndpointRequest;
import com.databricks.sdk.service.vectorsearch.EndpointInfo;
import com.databricks.sdk.service.vectorsearch.EndpointStatusState;
import com.databricks.sdk.service.vectorsearch.EndpointType;
import com.databricks.sdk.service.vectorsearch.GetEndpointRequest;
import com.databricks.sdk.service.vectorsearch.ListEndpointResponse;
import com.databricks.sdk.service.vectorsearch.ListEndpointsRequest;
import com.databricks.sdk.service.vectorsearch.VectorSearchEndpointsImpl;
import com.databricks.sdk.service.vectorsearch.VectorSearchEndpointsService;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import com.databricks.sdk.support.Wait;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class VectorSearchEndpointsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(VectorSearchEndpointsAPI.class);
    private final VectorSearchEndpointsService impl;

    public VectorSearchEndpointsAPI(ApiClient apiClient) {
        this.impl = new VectorSearchEndpointsImpl(apiClient);
    }

    public VectorSearchEndpointsAPI(VectorSearchEndpointsService mock) {
        this.impl = mock;
    }

    public EndpointInfo waitGetEndpointVectorSearchEndpointOnline(String endpointName) throws TimeoutException {
        return this.waitGetEndpointVectorSearchEndpointOnline(endpointName, Duration.ofMinutes(20L), null);
    }

    public EndpointInfo waitGetEndpointVectorSearchEndpointOnline(String endpointName, Duration timeout, Consumer<EndpointInfo> callback) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        List<EndpointStatusState> targetStates = Arrays.asList(EndpointStatusState.ONLINE);
        List<EndpointStatusState> failureStates = Arrays.asList(EndpointStatusState.OFFLINE);
        String statusMessage = "polling...";
        int attempt = 1;
        while (System.currentTimeMillis() < deadline) {
            EndpointInfo poll = this.getEndpoint(new GetEndpointRequest().setEndpointName(endpointName));
            EndpointStatusState status = poll.getEndpointStatus().getState();
            statusMessage = String.format("current status: %s", new Object[]{status});
            if (poll.getEndpointStatus() != null) {
                statusMessage = poll.getEndpointStatus().getMessage();
            }
            if (targetStates.contains((Object)status)) {
                return poll;
            }
            if (callback != null) {
                callback.accept(poll);
            }
            if (failureStates.contains((Object)status)) {
                String msg = String.format("failed to reach ONLINE, got %s: %s", new Object[]{status, statusMessage});
                throw new IllegalStateException(msg);
            }
            String prefix = String.format("endpointName=%s", endpointName);
            int sleep = attempt;
            if (sleep > 10) {
                sleep = 10;
            }
            LOG.info("{}: ({}) {} (sleeping ~{}s)", new Object[]{prefix, status, statusMessage, sleep});
            try {
                Thread.sleep((long)((double)((long)sleep * 1000L) + Math.random() * 1000.0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DatabricksException("Current thread was interrupted", e);
            }
            ++attempt;
        }
        throw new TimeoutException(String.format("timed out after %s: %s", timeout, statusMessage));
    }

    public Wait<EndpointInfo, EndpointInfo> createEndpoint(String name, EndpointType endpointType) {
        return this.createEndpoint(new CreateEndpoint().setName(name).setEndpointType(endpointType));
    }

    public Wait<EndpointInfo, EndpointInfo> createEndpoint(CreateEndpoint request) {
        EndpointInfo response = this.impl.createEndpoint(request);
        return new Wait<EndpointInfo, EndpointInfo>((timeout, callback) -> this.waitGetEndpointVectorSearchEndpointOnline(response.getName(), timeout, callback), response);
    }

    public void deleteEndpoint(String endpointName) {
        this.deleteEndpoint(new DeleteEndpointRequest().setEndpointName(endpointName));
    }

    public void deleteEndpoint(DeleteEndpointRequest request) {
        this.impl.deleteEndpoint(request);
    }

    public EndpointInfo getEndpoint(String endpointName) {
        return this.getEndpoint(new GetEndpointRequest().setEndpointName(endpointName));
    }

    public EndpointInfo getEndpoint(GetEndpointRequest request) {
        return this.impl.getEndpoint(request);
    }

    public Iterable<EndpointInfo> listEndpoints(ListEndpointsRequest request) {
        return new Paginator(request, this.impl::listEndpoints, ListEndpointResponse::getEndpoints, response -> {
            String token = response.getNextPageToken();
            if (token == null) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public VectorSearchEndpointsService impl() {
        return this.impl;
    }
}

