/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.sql;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.sql.DeleteQueryRequest;
import com.databricks.sdk.service.sql.GetQueryRequest;
import com.databricks.sdk.service.sql.ListQueriesRequest;
import com.databricks.sdk.service.sql.QueriesImpl;
import com.databricks.sdk.service.sql.QueriesService;
import com.databricks.sdk.service.sql.Query;
import com.databricks.sdk.service.sql.QueryEditContent;
import com.databricks.sdk.service.sql.QueryList;
import com.databricks.sdk.service.sql.QueryPostContent;
import com.databricks.sdk.service.sql.RestoreQueryRequest;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class QueriesAPI {
    private static final Logger LOG = LoggerFactory.getLogger(QueriesAPI.class);
    private final QueriesService impl;

    public QueriesAPI(ApiClient apiClient) {
        this.impl = new QueriesImpl(apiClient);
    }

    public QueriesAPI(QueriesService mock) {
        this.impl = mock;
    }

    public Query create(QueryPostContent request) {
        return this.impl.create(request);
    }

    public void delete(String queryId) {
        this.delete(new DeleteQueryRequest().setQueryId(queryId));
    }

    public void delete(DeleteQueryRequest request) {
        this.impl.delete(request);
    }

    public Query get(String queryId) {
        return this.get(new GetQueryRequest().setQueryId(queryId));
    }

    public Query get(GetQueryRequest request) {
        return this.impl.get(request);
    }

    public Iterable<Query> list(ListQueriesRequest request) {
        request.setPage(1L);
        return new Paginator<ListQueriesRequest, QueryList, Query>(request, this.impl::list, QueryList::getResults, response -> {
            Long page = request.getPage();
            if (page == null) {
                page = 1L;
            }
            return request.setPage(page + 1L);
        }).withDedupe(Query::getId);
    }

    public void restore(String queryId) {
        this.restore(new RestoreQueryRequest().setQueryId(queryId));
    }

    public void restore(RestoreQueryRequest request) {
        this.impl.restore(request);
    }

    public Query update(String queryId) {
        return this.update(new QueryEditContent().setQueryId(queryId));
    }

    public Query update(QueryEditContent request) {
        return this.impl.update(request);
    }

    public QueriesService impl() {
        return this.impl;
    }
}

