/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.marketplace;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.marketplace.ConsumerInstallationsService;
import com.databricks.sdk.service.marketplace.CreateInstallationRequest;
import com.databricks.sdk.service.marketplace.DeleteInstallationRequest;
import com.databricks.sdk.service.marketplace.DeleteInstallationResponse;
import com.databricks.sdk.service.marketplace.Installation;
import com.databricks.sdk.service.marketplace.ListAllInstallationsRequest;
import com.databricks.sdk.service.marketplace.ListAllInstallationsResponse;
import com.databricks.sdk.service.marketplace.ListInstallationsRequest;
import com.databricks.sdk.service.marketplace.ListInstallationsResponse;
import com.databricks.sdk.service.marketplace.UpdateInstallationRequest;
import com.databricks.sdk.service.marketplace.UpdateInstallationResponse;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class ConsumerInstallationsImpl
implements ConsumerInstallationsService {
    private final ApiClient apiClient;

    public ConsumerInstallationsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public Installation create(CreateInstallationRequest request) {
        String path = String.format("/api/2.1/marketplace-consumer/listings/%s/installations", request.getListingId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, Installation.class, headers);
    }

    @Override
    public void delete(DeleteInstallationRequest request) {
        String path = String.format("/api/2.1/marketplace-consumer/listings/%s/installations/%s", request.getListingId(), request.getInstallationId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.DELETE(path, request, DeleteInstallationResponse.class, headers);
    }

    @Override
    public ListAllInstallationsResponse list(ListAllInstallationsRequest request) {
        String path = "/api/2.1/marketplace-consumer/installations";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListAllInstallationsResponse.class, headers);
    }

    @Override
    public ListInstallationsResponse listListingInstallations(ListInstallationsRequest request) {
        String path = String.format("/api/2.1/marketplace-consumer/listings/%s/installations", request.getListingId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListInstallationsResponse.class, headers);
    }

    @Override
    public UpdateInstallationResponse update(UpdateInstallationRequest request) {
        String path = String.format("/api/2.1/marketplace-consumer/listings/%s/installations/%s", request.getListingId(), request.getInstallationId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PUT(path, request, UpdateInstallationResponse.class, headers);
    }
}

