/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.CancelRefreshRequest;
import com.databricks.sdk.service.catalog.CreateMonitor;
import com.databricks.sdk.service.catalog.DeleteLakehouseMonitorRequest;
import com.databricks.sdk.service.catalog.GetLakehouseMonitorRequest;
import com.databricks.sdk.service.catalog.GetRefreshRequest;
import com.databricks.sdk.service.catalog.LakehouseMonitorsImpl;
import com.databricks.sdk.service.catalog.LakehouseMonitorsService;
import com.databricks.sdk.service.catalog.ListRefreshesRequest;
import com.databricks.sdk.service.catalog.MonitorInfo;
import com.databricks.sdk.service.catalog.MonitorRefreshInfo;
import com.databricks.sdk.service.catalog.RunRefreshRequest;
import com.databricks.sdk.service.catalog.UpdateMonitor;
import com.databricks.sdk.support.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class LakehouseMonitorsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(LakehouseMonitorsAPI.class);
    private final LakehouseMonitorsService impl;

    public LakehouseMonitorsAPI(ApiClient apiClient) {
        this.impl = new LakehouseMonitorsImpl(apiClient);
    }

    public LakehouseMonitorsAPI(LakehouseMonitorsService mock) {
        this.impl = mock;
    }

    public void cancelRefresh(String tableName, String refreshId) {
        this.cancelRefresh(new CancelRefreshRequest().setTableName(tableName).setRefreshId(refreshId));
    }

    public void cancelRefresh(CancelRefreshRequest request) {
        this.impl.cancelRefresh(request);
    }

    public MonitorInfo create(String tableName, String assetsDir, String outputSchemaName) {
        return this.create(new CreateMonitor().setTableName(tableName).setAssetsDir(assetsDir).setOutputSchemaName(outputSchemaName));
    }

    public MonitorInfo create(CreateMonitor request) {
        return this.impl.create(request);
    }

    public void delete(String tableName) {
        this.delete(new DeleteLakehouseMonitorRequest().setTableName(tableName));
    }

    public void delete(DeleteLakehouseMonitorRequest request) {
        this.impl.delete(request);
    }

    public MonitorInfo get(String tableName) {
        return this.get(new GetLakehouseMonitorRequest().setTableName(tableName));
    }

    public MonitorInfo get(GetLakehouseMonitorRequest request) {
        return this.impl.get(request);
    }

    public MonitorRefreshInfo getRefresh(String tableName, String refreshId) {
        return this.getRefresh(new GetRefreshRequest().setTableName(tableName).setRefreshId(refreshId));
    }

    public MonitorRefreshInfo getRefresh(GetRefreshRequest request) {
        return this.impl.getRefresh(request);
    }

    public Iterable<MonitorRefreshInfo> listRefreshes(String tableName) {
        return this.listRefreshes(new ListRefreshesRequest().setTableName(tableName));
    }

    public Iterable<MonitorRefreshInfo> listRefreshes(ListRefreshesRequest request) {
        return this.impl.listRefreshes(request);
    }

    public MonitorRefreshInfo runRefresh(String tableName) {
        return this.runRefresh(new RunRefreshRequest().setTableName(tableName));
    }

    public MonitorRefreshInfo runRefresh(RunRefreshRequest request) {
        return this.impl.runRefresh(request);
    }

    public MonitorInfo update(String tableName, String outputSchemaName) {
        return this.update(new UpdateMonitor().setTableName(tableName).setOutputSchemaName(outputSchemaName));
    }

    public MonitorInfo update(UpdateMonitor request) {
        return this.impl.update(request);
    }

    public LakehouseMonitorsService impl() {
        return this.impl;
    }
}

