/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.commons;

import com.databricks.sdk.core.DatabricksConfig;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.ProxyConfig;
import com.databricks.sdk.core.http.HttpClient;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.core.http.Response;
import com.databricks.sdk.core.utils.CustomCloseInputStream;
import com.databricks.sdk.core.utils.ProxyUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonsHttpClient
implements HttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(CommonsHttpClient.class);
    private final PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
    private final CloseableHttpClient hc;
    private int timeout;

    public CommonsHttpClient(int timeoutSeconds) {
        this.timeout = timeoutSeconds * 1000;
        this.connectionManager.setMaxTotal(100);
        this.hc = this.makeClosableHttpClient();
    }

    public CommonsHttpClient(DatabricksConfig databricksConfig) {
        this(databricksConfig.getHttpTimeoutSeconds() == null ? 300 : databricksConfig.getHttpTimeoutSeconds(), new ProxyConfig(databricksConfig));
    }

    public CommonsHttpClient(int timeoutSeconds, ProxyConfig proxyConfig) {
        this.timeout = timeoutSeconds * 1000;
        this.connectionManager.setMaxTotal(100);
        this.hc = this.makeClosableHttpClient(proxyConfig);
    }

    private RequestConfig makeRequestConfig() {
        return RequestConfig.custom().setConnectionRequestTimeout(this.timeout).setConnectTimeout(this.timeout).setSocketTimeout(this.timeout).build();
    }

    private CloseableHttpClient makeClosableHttpClient() {
        return HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)this.connectionManager).setDefaultRequestConfig(this.makeRequestConfig()).build();
    }

    private CloseableHttpClient makeClosableHttpClient(ProxyConfig proxyConfig) {
        HttpClientBuilder builder = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)this.connectionManager).setDefaultRequestConfig(this.makeRequestConfig());
        ProxyUtils.setupProxy(proxyConfig, builder);
        return builder.build();
    }

    @Override
    public Response execute(Request in) throws IOException {
        HttpUriRequest request = this.transformRequest(in);
        boolean handleRedirects = in.getRedirectionBehavior().orElse(true);
        if (!handleRedirects) {
            request.getParams().setParameter("http.protocol.handle-redirects", (Object)false);
        }
        in.getHeaders().forEach((arg_0, arg_1) -> ((HttpUriRequest)request).setHeader(arg_0, arg_1));
        CloseableHttpResponse response = this.hc.execute(request);
        return this.computeResponse(in, response);
    }

    /*
     * Loose catch block
     */
    private Response computeResponse(Request in, CloseableHttpResponse response) throws IOException {
        boolean streamResponse;
        HttpEntity entity = response.getEntity();
        StatusLine statusLine = response.getStatusLine();
        Map<String, List<String>> hs = Arrays.stream(response.getAllHeaders()).collect(Collectors.groupingBy(NameValuePair::getName, Collectors.mapping(NameValuePair::getValue, Collectors.toList())));
        if (entity == null) {
            response.close();
            return new Response(in, statusLine.getStatusCode(), statusLine.getReasonPhrase(), hs);
        }
        boolean bl = streamResponse = in.getHeaders().containsKey("Accept") && !ContentType.APPLICATION_JSON.getMimeType().equals(in.getHeaders().get("Accept")) && !ContentType.APPLICATION_JSON.getMimeType().equals(response.getFirstHeader("Content-Type").getValue());
        if (streamResponse) {
            CustomCloseInputStream inputStream = new CustomCloseInputStream(entity.getContent(), () -> {
                try {
                    response.close();
                }
                catch (Exception e) {
                    throw new DatabricksException("Unable to close connection", e);
                }
            });
            return new Response(in, statusLine.getStatusCode(), statusLine.getReasonPhrase(), hs, inputStream);
        }
        try {
            try (InputStream inputStream = entity.getContent();){
                String body = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                Response response2 = new Response(in, statusLine.getStatusCode(), statusLine.getReasonPhrase(), hs, body);
                return response2;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            response.close();
        }
    }

    private HttpUriRequest transformRequest(Request in) {
        switch (in.getMethod()) {
            case "GET": {
                return new HttpGet(in.getUri());
            }
            case "HEAD": {
                return new HttpHead(in.getUri());
            }
            case "DELETE": {
                return new HttpDelete(in.getUri());
            }
            case "POST": {
                return this.withEntity((HttpEntityEnclosingRequestBase)new HttpPost(in.getUri()), in);
            }
            case "PUT": {
                return this.withEntity((HttpEntityEnclosingRequestBase)new HttpPut(in.getUri()), in);
            }
            case "PATCH": {
                return this.withEntity((HttpEntityEnclosingRequestBase)new HttpPatch(in.getUri()), in);
            }
        }
        throw new IllegalArgumentException("Unknown method: " + in.getMethod());
    }

    private HttpRequestBase withEntity(HttpEntityEnclosingRequestBase request, Request in) {
        if (in.isBodyString()) {
            request.setEntity((HttpEntity)new StringEntity(in.getBodyString(), StandardCharsets.UTF_8));
        } else if (in.isBodyStreaming()) {
            request.setEntity((HttpEntity)new InputStreamEntity(in.getBodyStream()));
        } else {
            LOG.warn("withEntity called with a request with no body, so no request entity will be set. URI: {}", (Object)in.getUri());
        }
        return request;
    }
}

