/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl;

import com.databricks.jdbc.api.impl.DatabricksConnection;
import com.databricks.jdbc.api.impl.DatabricksParameterMetaData;
import com.databricks.jdbc.api.impl.DatabricksResultSet;
import com.databricks.jdbc.api.impl.ImmutableSqlParameter;
import com.databricks.jdbc.common.StatementType;
import com.databricks.jdbc.common.util.InsertStatementParser;
import com.databricks.jdbc.common.util.SQLInterpolator;
import com.databricks.jdbc.exception.DatabricksBatchUpdateException;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PreparedStatementBatchExecutor {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(PreparedStatementBatchExecutor.class);
    private final String sql;
    private final DatabricksConnection connection;
    private final boolean interpolateParameters;
    private final StatementExecutor statementExecutor;

    PreparedStatementBatchExecutor(String sql, DatabricksConnection connection, boolean interpolateParameters, StatementExecutor statementExecutor) {
        this.sql = sql;
        this.connection = connection;
        this.interpolateParameters = interpolateParameters;
        this.statementExecutor = statementExecutor;
    }

    long[] executeBatch(List<DatabricksParameterMetaData> batchParameterMetaData) throws DatabricksBatchUpdateException {
        if (batchParameterMetaData.isEmpty()) {
            return new long[0];
        }
        if (this.canUseBatchedInsert()) {
            return this.executeBatchedInsert(batchParameterMetaData);
        }
        return this.executeIndividualStatements(batchParameterMetaData);
    }

    private boolean canUseBatchedInsert() {
        if (!this.connection.getConnectionContext().isBatchedInsertsEnabled()) {
            return false;
        }
        try {
            InsertStatementParser.parseInsertStrict(this.sql);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private long[] executeBatchedInsert(List<DatabricksParameterMetaData> batchParameterMetaData) throws DatabricksBatchUpdateException {
        LOGGER.debug("Executing batched INSERT with {} rows", batchParameterMetaData.size());
        try {
            int maxRowsPerChunk;
            InsertStatementParser.InsertInfo insertInfo = InsertStatementParser.parseInsertStrict(this.sql);
            int parametersPerRow = insertInfo.getColumnCount();
            if (this.interpolateParameters) {
                int configuredBatchSize = this.connection.getConnectionContext().getBatchInsertSize();
                if (configuredBatchSize < 1) {
                    throw new DatabricksSQLException("BatchInsertSize must be at least 1, got: " + configuredBatchSize, DatabricksDriverErrorCode.INVALID_STATE);
                }
                maxRowsPerChunk = Math.min(configuredBatchSize, batchParameterMetaData.size());
            } else {
                int maxRowsByParameterLimit = 256 / parametersPerRow;
                maxRowsPerChunk = maxRowsByParameterLimit < 1 ? 1 : maxRowsByParameterLimit;
            }
            long[] allUpdateCounts = new long[batchParameterMetaData.size()];
            for (int startIndex = 0; startIndex < batchParameterMetaData.size(); startIndex += maxRowsPerChunk) {
                int endIndex = Math.min(startIndex + maxRowsPerChunk, batchParameterMetaData.size());
                int chunkSize = endIndex - startIndex;
                String multiRowSql = InsertStatementParser.generateMultiRowInsert(insertInfo, chunkSize);
                HashMap<Integer, ImmutableSqlParameter> chunkParams = new HashMap<Integer, ImmutableSqlParameter>();
                int paramIndex = 1;
                for (int i = startIndex; i < endIndex; ++i) {
                    DatabricksParameterMetaData batchParams = batchParameterMetaData.get(i);
                    Map<Integer, ImmutableSqlParameter> rowParams = batchParams.getParameterBindings();
                    for (int j = 1; j <= rowParams.size(); ++j) {
                        if (!rowParams.containsKey(j)) continue;
                        chunkParams.put(paramIndex++, rowParams.get(j));
                    }
                }
                String sqlToExecute = this.interpolateParameters ? SQLInterpolator.interpolateSQL(multiRowSql, chunkParams) : multiRowSql;
                HashMap<Integer, ImmutableSqlParameter> paramsToSend = this.interpolateParameters ? new HashMap<Integer, ImmutableSqlParameter>() : chunkParams;
                this.statementExecutor.execute(sqlToExecute, paramsToSend, StatementType.UPDATE, false);
                for (int i = startIndex; i < endIndex; ++i) {
                    allUpdateCounts[i] = 1L;
                }
            }
            return allUpdateCounts;
        }
        catch (DatabricksBatchUpdateException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error executing batched INSERT: {}", e.getMessage(), e);
            long[] failedCounts = new long[batchParameterMetaData.size()];
            for (int i = 0; i < failedCounts.length; ++i) {
                failedCounts[i] = -3L;
            }
            throw new DatabricksBatchUpdateException(e.getMessage(), DatabricksDriverErrorCode.BATCH_EXECUTE_EXCEPTION, failedCounts);
        }
    }

    private long[] executeIndividualStatements(List<DatabricksParameterMetaData> batchParameterMetaData) throws DatabricksBatchUpdateException {
        LOGGER.debug("Executing batch individually with {} statements", batchParameterMetaData.size());
        long[] largeUpdateCount = new long[batchParameterMetaData.size()];
        for (int sqlQueryIndex = 0; sqlQueryIndex < batchParameterMetaData.size(); ++sqlQueryIndex) {
            DatabricksParameterMetaData databricksParameterMetaData = batchParameterMetaData.get(sqlQueryIndex);
            try {
                DatabricksResultSet resultSet = this.statementExecutor.execute(this.sql, databricksParameterMetaData.getParameterBindings(), StatementType.UPDATE, false);
                largeUpdateCount[sqlQueryIndex] = resultSet.getUpdateCount();
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Error executing batch update for index {}: {}", sqlQueryIndex, e.getMessage(), e);
                largeUpdateCount[sqlQueryIndex] = -3L;
                for (int i = sqlQueryIndex + 1; i < largeUpdateCount.length; ++i) {
                    largeUpdateCount[i] = -3L;
                }
                throw new DatabricksBatchUpdateException(e.getMessage(), DatabricksDriverErrorCode.BATCH_EXECUTE_EXCEPTION, largeUpdateCount);
            }
        }
        return largeUpdateCount;
    }

    @FunctionalInterface
    static interface StatementExecutor {
        public DatabricksResultSet execute(String var1, Map<Integer, ImmutableSqlParameter> var2, StatementType var3, boolean var4) throws SQLException;
    }
}

