/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl;

import com.databricks.jdbc.api.internal.IDatabricksSession;
import com.databricks.jdbc.dbclient.impl.common.StatementId;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.core.ResultData;
import com.databricks.jdbc.model.core.ResultManifest;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class JsonChunkProvider {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(JsonChunkProvider.class);
    private final StatementId statementId;
    private final IDatabricksSession session;
    private final ResultManifest resultManifest;
    private final List<List<Object>> allData;
    private boolean isClosed = false;

    public JsonChunkProvider(ResultManifest resultManifest, ResultData initialResultData, StatementId statementId, IDatabricksSession session) throws DatabricksSQLException {
        this.resultManifest = resultManifest;
        this.statementId = statementId;
        this.session = session;
        this.allData = new ArrayList<List<Object>>();
        this.fetchAndCombineAllChunks(initialResultData);
    }

    private void fetchAndCombineAllChunks(ResultData initialResultData) throws DatabricksSQLException {
        LOGGER.debug("Starting to fetch and combine JSON chunks for statement: {}", this.statementId);
        this.addDataFromChunk(initialResultData);
        Long totalChunkCount = Objects.requireNonNullElse(this.resultManifest.getTotalChunkCount(), 0L);
        if (totalChunkCount > 1L) {
            LOGGER.debug("Total chunks to fetch: {}", totalChunkCount);
            for (long chunkIndex = 1L; chunkIndex < totalChunkCount; ++chunkIndex) {
                if (this.isClosed) {
                    LOGGER.warn("Provider closed while fetching chunk {}", chunkIndex);
                    break;
                }
                try {
                    LOGGER.debug("Fetching chunk {} of {}", chunkIndex, totalChunkCount);
                    ResultData chunkData = this.session.getDatabricksClient().getResultChunksData(this.statementId, chunkIndex);
                    this.addDataFromChunk(chunkData);
                    continue;
                }
                catch (DatabricksSQLException e) {
                    LOGGER.error("Failed to fetch chunk {} for statement {}", chunkIndex, this.statementId, e);
                    throw new DatabricksSQLException(String.format("Failed to fetch chunk %d: %s", chunkIndex, e.getMessage()), (Throwable)e, DatabricksDriverErrorCode.CHUNK_DOWNLOAD_ERROR);
                }
            }
        }
        LOGGER.debug("Successfully combined {} total rows from {} chunks", this.allData.size(), totalChunkCount);
    }

    private void addDataFromChunk(ResultData chunkData) {
        if (chunkData == null || chunkData.getDataArray() == null) {
            LOGGER.debug("Chunk data or data array is null, skipping");
            return;
        }
        Collection<Collection<String>> dataArray = chunkData.getDataArray();
        LOGGER.debug("Adding {} rows from chunk {}", dataArray.size(), chunkData.getChunkIndex() != null ? chunkData.getChunkIndex() : "unknown");
        for (Collection<String> row : dataArray) {
            if (row != null) {
                this.allData.add(new ArrayList<String>(row));
                continue;
            }
            this.allData.add(new ArrayList());
        }
    }

    public List<List<Object>> getAllData() {
        return this.allData;
    }

    public long getChunkCount() {
        LOGGER.debug("Getting total chunk count");
        return Objects.requireNonNullElse(this.resultManifest.getTotalChunkCount(), 0L);
    }

    public void close() {
        this.isClosed = true;
        this.allData.clear();
        LOGGER.debug("JsonChunkProvider closed for statement: {}", this.statementId);
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

