/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl;

import com.databricks.internal.apache.http.entity.InputStreamEntity;
import com.databricks.internal.google.common.annotations.VisibleForTesting;
import com.databricks.internal.sdk.support.ToStringer;
import com.databricks.jdbc.api.IDatabricksResultSet;
import com.databricks.jdbc.api.IExecutionStatus;
import com.databricks.jdbc.api.impl.ComplexDataTypeParser;
import com.databricks.jdbc.api.impl.DatabricksArray;
import com.databricks.jdbc.api.impl.DatabricksResultSetMetaData;
import com.databricks.jdbc.api.impl.DatabricksStruct;
import com.databricks.jdbc.api.impl.ExecutionResultFactory;
import com.databricks.jdbc.api.impl.ExecutionStatus;
import com.databricks.jdbc.api.impl.IExecutionResult;
import com.databricks.jdbc.api.impl.LazyThriftResult;
import com.databricks.jdbc.api.impl.arrow.ArrowStreamResult;
import com.databricks.jdbc.api.impl.converters.ConverterHelper;
import com.databricks.jdbc.api.impl.converters.ObjectConverter;
import com.databricks.jdbc.api.impl.volume.VolumeOperationResult;
import com.databricks.jdbc.api.internal.IDatabricksResultSetInternal;
import com.databricks.jdbc.api.internal.IDatabricksSession;
import com.databricks.jdbc.api.internal.IDatabricksStatementInternal;
import com.databricks.jdbc.common.Nullable;
import com.databricks.jdbc.common.StatementType;
import com.databricks.jdbc.common.util.WarningUtil;
import com.databricks.jdbc.dbclient.impl.common.StatementId;
import com.databricks.jdbc.exception.DatabricksParsingException;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.exception.DatabricksSQLFeatureNotSupportedException;
import com.databricks.jdbc.exception.DatabricksValidationException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.client.thrift.generated.TFetchResultsResp;
import com.databricks.jdbc.model.core.ColumnMetadata;
import com.databricks.jdbc.model.core.ResultData;
import com.databricks.jdbc.model.core.ResultManifest;
import com.databricks.jdbc.model.core.StatementStatus;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import com.databricks.jdbc.telemetry.latency.TelemetryCollector;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class DatabricksResultSet
implements IDatabricksResultSet,
IDatabricksResultSetInternal {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksResultSet.class);
    protected static final String AFFECTED_ROWS_COUNT = "num_affected_rows";
    private final ExecutionStatus executionStatus;
    private final StatementId statementId;
    private final IExecutionResult executionResult;
    private final DatabricksResultSetMetaData resultSetMetaData;
    private final StatementType statementType;
    private final IDatabricksStatementInternal parentStatement;
    private Long updateCount;
    private boolean isClosed;
    private SQLWarning warnings = null;
    private boolean wasNull;
    private boolean silenceNonTerminalExceptions = false;
    private ResultSetType resultSetType = ResultSetType.UNASSIGNED;
    private boolean complexDatatypeSupport = false;

    public DatabricksResultSet(StatementStatus statementStatus, StatementId statementId, ResultData resultData, ResultManifest resultManifest, StatementType statementType, IDatabricksSession session, IDatabricksStatementInternal parentStatement) throws DatabricksSQLException {
        this.executionStatus = new ExecutionStatus(statementStatus);
        this.statementId = statementId;
        if (resultData != null) {
            this.executionResult = ExecutionResultFactory.getResultSet(resultData, resultManifest, statementId, session, parentStatement);
            this.resultSetMetaData = new DatabricksResultSetMetaData(statementId, resultManifest, resultData.getExternalLinks() != null, session.getConnectionContext());
            switch (resultManifest.getFormat()) {
                case ARROW_STREAM: {
                    this.resultSetType = ResultSetType.SEA_ARROW_ENABLED;
                    break;
                }
                case JSON_ARRAY: {
                    this.resultSetType = ResultSetType.SEA_INLINE;
                }
            }
        } else {
            this.executionResult = null;
            this.resultSetMetaData = null;
        }
        this.complexDatatypeSupport = session.getConnectionContext().isComplexDatatypeSupportEnabled();
        this.statementType = statementType;
        this.updateCount = null;
        this.parentStatement = parentStatement;
        this.isClosed = false;
        this.wasNull = false;
    }

    @VisibleForTesting
    public DatabricksResultSet(StatementStatus statementStatus, StatementId statementId, StatementType statementType, IDatabricksStatementInternal parentStatement, IExecutionResult executionResult, DatabricksResultSetMetaData resultSetMetaData, boolean complexDatatypeSupport) {
        this.executionStatus = new ExecutionStatus(statementStatus);
        this.statementId = statementId;
        this.executionResult = executionResult;
        this.resultSetMetaData = resultSetMetaData;
        this.statementType = statementType;
        this.updateCount = null;
        this.parentStatement = parentStatement;
        this.isClosed = false;
        this.wasNull = false;
        this.complexDatatypeSupport = complexDatatypeSupport;
    }

    public DatabricksResultSet(StatementStatus statementStatus, StatementId statementId, TFetchResultsResp resultsResp, StatementType statementType, IDatabricksStatementInternal parentStatement, IDatabricksSession session) throws SQLException {
        this.executionStatus = new ExecutionStatus(statementStatus);
        this.statementId = statementId;
        if (resultsResp != null) {
            this.executionResult = ExecutionResultFactory.getResultSet(resultsResp, session, parentStatement);
            long rowSize = this.executionResult.getRowCount();
            List<String> arrowMetadata = null;
            if (this.executionResult instanceof ArrowStreamResult) {
                arrowMetadata = ((ArrowStreamResult)this.executionResult).getArrowMetadata();
            }
            this.resultSetMetaData = new DatabricksResultSetMetaData(statementId, resultsResp.getResultSetMetadata(), rowSize, this.executionResult.getChunkCount(), arrowMetadata, session.getConnectionContext());
            switch (resultsResp.getResultSetMetadata().getResultFormat()) {
                case COLUMN_BASED_SET: {
                    this.resultSetType = ResultSetType.THRIFT_INLINE;
                    break;
                }
                case URL_BASED_SET: 
                case ARROW_BASED_SET: {
                    this.resultSetType = ResultSetType.THRIFT_ARROW_ENABLED;
                }
            }
        } else {
            this.executionResult = null;
            this.resultSetMetaData = null;
        }
        this.complexDatatypeSupport = session.getConnectionContext().isComplexDatatypeSupportEnabled();
        this.statementType = statementType;
        this.updateCount = null;
        this.parentStatement = parentStatement;
        this.isClosed = false;
        this.wasNull = false;
    }

    public DatabricksResultSet(StatementStatus statementStatus, StatementId statementId, List<String> columnNames, List<String> columnTypeText, int[] columnTypes, int[] columnTypePrecisions, int[] isNullables, Object[][] rows, StatementType statementType) {
        this.executionStatus = new ExecutionStatus(statementStatus);
        this.statementId = statementId;
        this.executionResult = ExecutionResultFactory.getResultSet(rows);
        this.resultSetMetaData = new DatabricksResultSetMetaData(statementId, columnNames, columnTypeText, columnTypes, columnTypePrecisions, isNullables, (long)rows.length);
        this.statementType = statementType;
        this.updateCount = null;
        this.parentStatement = null;
        this.isClosed = false;
        this.wasNull = false;
    }

    public DatabricksResultSet(StatementStatus statementStatus, StatementId statementId, List<String> columnNames, List<String> columnTypeText, List<Integer> columnTypes, List<Integer> columnTypePrecisions, List<Nullable> columnNullables, List<List<Object>> rows, StatementType statementType) {
        this.executionStatus = new ExecutionStatus(statementStatus);
        this.statementId = statementId;
        this.executionResult = ExecutionResultFactory.getResultSet(rows);
        this.resultSetMetaData = new DatabricksResultSetMetaData(statementId, columnNames, columnTypeText, columnTypes, columnTypePrecisions, columnNullables, (long)rows.size());
        this.statementType = statementType;
        this.updateCount = null;
        this.parentStatement = null;
        this.isClosed = false;
        this.wasNull = false;
    }

    public DatabricksResultSet(StatementStatus statementStatus, StatementId statementId, List<ColumnMetadata> columnMetadataList, List<List<Object>> rows, StatementType statementType) {
        this.executionStatus = new ExecutionStatus(statementStatus);
        this.statementId = statementId;
        this.executionResult = ExecutionResultFactory.getResultSet(rows);
        this.resultSetMetaData = new DatabricksResultSetMetaData(statementId, columnMetadataList, rows.size());
        this.statementType = statementType;
        this.updateCount = null;
        this.parentStatement = null;
        this.isClosed = false;
        this.wasNull = false;
    }

    @Override
    public boolean next() throws SQLException {
        this.checkIfClosed();
        boolean hasNext = this.executionResult.next();
        TelemetryCollector.getInstance().recordResultSetIteration(this.statementId.toSQLExecStatementId(), this.resultSetMetaData.getChunkCount(), hasNext);
        return hasNext;
    }

    @Override
    public void close() throws DatabricksSQLException {
        this.isClosed = true;
        this.executionResult.close();
        if (this.parentStatement != null) {
            this.parentStatement.handleResultSetClose(this);
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkIfClosed();
        return this.wasNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.getConvertedObject(columnIndex, ObjectConverter::toString, () -> null);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.getConvertedObject(columnIndex, ObjectConverter::toBoolean, () -> false);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.getConvertedObject(columnIndex, ObjectConverter::toByte, () -> (byte)0);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.getConvertedObject(columnIndex, ObjectConverter::toShort, () -> (short)0);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.getConvertedObject(columnIndex, ObjectConverter::toInt, () -> 0);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.getConvertedObject(columnIndex, ObjectConverter::toLong, () -> 0L);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.getConvertedObject(columnIndex, ObjectConverter::toFloat, () -> Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.getConvertedObject(columnIndex, ObjectConverter::toDouble, () -> 0.0);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getConvertedObject(columnIndex, (converter, object) -> {
            BigDecimal bd = converter.toBigDecimal(object);
            return this.applyScaleToBigDecimal(bd, columnIndex, scale);
        }, () -> null);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.getConvertedObject(columnIndex, ObjectConverter::toByteArray, () -> null);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getConvertedObject(columnIndex, ObjectConverter::toDate, () -> null);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getConvertedObject(columnIndex, ObjectConverter::toTime, () -> null);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getConvertedObject(columnIndex, ObjectConverter::toTimestamp, () -> null);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getConvertedObject(columnIndex, ObjectConverter::toAsciiStream, () -> null);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.getConvertedObject(columnIndex, ObjectConverter::toUnicodeStream, () -> null);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.getConvertedObject(columnIndex, ObjectConverter::toBinaryStream, () -> null);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.getColumnNameIndex(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.getColumnNameIndex(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.getColumnNameIndex(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.getColumnNameIndex(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.getColumnNameIndex(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.getColumnNameIndex(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.getColumnNameIndex(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.getColumnNameIndex(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.getColumnNameIndex(columnLabel));
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.getColumnNameIndex(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.getColumnNameIndex(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.getColumnNameIndex(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.getColumnNameIndex(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.getColumnNameIndex(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.getColumnNameIndex(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.getColumnNameIndex(columnLabel));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkIfClosed();
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkIfClosed();
        this.warnings = null;
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkIfClosed();
        return "";
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.resultSetMetaData;
    }

    private static boolean isComplexType(String typeName) {
        return typeName.startsWith("ARRAY") || typeName.startsWith("MAP") || typeName.startsWith("STRUCT") || typeName.startsWith("GEOMETRY") || typeName.startsWith("GEOGRAPHY");
    }

    private static boolean isGeospatialType(String typeName) {
        return typeName.startsWith("GEOMETRY") || typeName.startsWith("GEOGRAPHY");
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkIfClosed();
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        String columnTypeName = this.resultSetMetaData.getColumnTypeName(columnIndex);
        if (DatabricksResultSet.isComplexType(columnTypeName)) {
            return this.handleComplexDataTypes(obj, columnTypeName);
        }
        if ("VARIANT".equals(columnTypeName) && !(obj instanceof String)) {
            throw new DatabricksValidationException("VARIANT type only supports String objects, got: " + obj.getClass().getSimpleName());
        }
        return ConverterHelper.convertSqlTypeToJavaType(columnType, obj);
    }

    private Object handleComplexDataTypes(Object obj, String columnName) throws DatabricksParsingException {
        if (this.complexDatatypeSupport) {
            return obj;
        }
        if (this.resultSetType == ResultSetType.SEA_INLINE) {
            return this.handleComplexDataTypesForSEAInline(obj, columnName);
        }
        return obj.toString();
    }

    private Object handleComplexDataTypesForSEAInline(Object obj, String columnName) throws DatabricksParsingException {
        ComplexDataTypeParser parser = new ComplexDataTypeParser();
        if (columnName.startsWith("ARRAY")) {
            return parser.parseJsonStringToDbArray(obj.toString(), columnName).toString();
        }
        if (columnName.startsWith("MAP")) {
            return parser.parseJsonStringToDbMap(obj.toString(), columnName).toString();
        }
        if (columnName.startsWith("STRUCT")) {
            return parser.parseJsonStringToDbStruct(obj.toString(), columnName).toString();
        }
        if (columnName.startsWith("GEOMETRY")) {
            return obj;
        }
        if (columnName.startsWith("GEOGRAPHY")) {
            return obj;
        }
        throw new DatabricksParsingException("Unexpected metadata format. Type is not a COMPLEX: " + columnName, DatabricksDriverErrorCode.JSON_PARSING_ERROR, this.silenceNonTerminalExceptions);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        this.checkIfClosed();
        return this.getObject(this.getColumnNameIndex(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkIfClosed();
        int columnIndex = this.getColumnNameIndex(columnLabel);
        if (columnIndex == -1) {
            LOGGER.error("Column not found: {}", columnLabel);
            throw new DatabricksSQLException("Column not found: " + columnLabel, DatabricksDriverErrorCode.RESULT_SET_ERROR, this.silenceNonTerminalExceptions);
        }
        return columnIndex;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkIfClosed();
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        ObjectConverter converter = ConverterHelper.getConverterForSqlType(columnType);
        return converter.toCharacterStream(obj);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.getColumnNameIndex(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getBigDecimal(columnIndex, this.resultSetMetaData.getScale(columnIndex));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.getColumnNameIndex(columnLabel));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkIfClosed();
        return this.executionResult.getCurrentRow() == -1L;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkIfClosed();
        return this.executionResult.getCurrentRow() >= this.resultSetMetaData.getTotalRows();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkIfClosed();
        return this.executionResult.getCurrentRow() == 0L;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkIfClosed();
        if (this.executionResult instanceof LazyThriftResult) {
            return this.executionResult.getCurrentRow() >= 0L && !this.executionResult.hasNext();
        }
        return this.executionResult.getCurrentRow() == this.resultSetMetaData.getTotalRows() - 1L;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC does not support random access (beforeFirst)");
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC does not support random access (afterLast)");
    }

    @Override
    public boolean first() throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC does not support random access (first)");
    }

    @Override
    public boolean last() throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC does not support random access (last)");
    }

    @Override
    public int getRow() throws SQLException {
        this.checkIfClosed();
        return (int)this.executionResult.getCurrentRow() + 1;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkIfClosed();
        if (row < 1 || (long)row < this.executionResult.getCurrentRow()) {
            throw new DatabricksSQLFeatureNotSupportedException("Invalid operation for forward only ResultSets");
        }
        while (this.executionResult.getCurrentRow() < (long)(row - 1)) {
            if (this.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC does not support random access (relative)");
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC does not support random access (previous)");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkIfClosed();
        if (direction != 1000) {
            throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC only supports FETCH_FORWARD direction");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkIfClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        LOGGER.debug("public void setFetchSize(int rows = {})", rows);
        this.checkIfClosed();
        this.addWarningAndLog("As FetchSize is not supported in the Databricks JDBC, ignoring it");
    }

    @Override
    public int getFetchSize() throws SQLException {
        LOGGER.debug("public int getFetchSize()");
        this.checkIfClosed();
        this.addWarningAndLog("As FetchSize is not supported in the Databricks JDBC, we don't set it in the first place");
        return 0;
    }

    @Override
    public int getType() throws SQLException {
        this.checkIfClosed();
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkIfClosed();
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support the function : rowUpdated");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support the function : rowInserted");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support the function : rowDeleted");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateNull");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateBoolean");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateByte");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateShort");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateInt");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateLong");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateFloat");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateDouble");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateBigDecimal");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateString");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateBytes");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateDate");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateTime");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateTimestamp");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateCharacterStream");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateObject");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateObject");
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        LOGGER.debug("public void updateObject(int columnIndex = {}, Object x = {}, SQLType targetSqlType = {}, int scaleOrLength = {})", columnIndex, x, targetSqlType, scaleOrLength);
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength)");
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        LOGGER.debug("public void updateObject(String columnLabel = {}, Object x = {}, SQLType targetSqlType = {}, int scaleOrLength = {})", columnLabel, x, targetSqlType, scaleOrLength);
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength)");
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType) throws SQLException {
        LOGGER.debug("public void updateObject(int columnIndex = {}, Object x = {}, SQLType targetSqlType = {})", columnIndex, x, targetSqlType);
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateObject(int columnIndex, Object x, SQLType targetSqlType)");
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType) throws SQLException {
        LOGGER.debug("public void updateObject(String columnLabel = {}, Object x = {}, SQLType targetSqlType = {})", columnLabel, x, targetSqlType);
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateObject(String columnLabel, Object x, SQLType targetSqlType)");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateNull");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateBoolean");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateByte");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateShort");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateInt");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateLong");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateFloat");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateDouble");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateBigDecimal");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateString");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateBytes");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateDate");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateTime");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateTimestamp");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateCharacterStream");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateObject");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateObject");
    }

    @Override
    public void insertRow() throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support insert function : insertRow");
    }

    @Override
    public void updateRow() throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateRow");
    }

    @Override
    public void deleteRow() throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support deleteRow.");
    }

    @Override
    public void refreshRow() throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : refreshRow");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support any row updates in the first place.");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support moveToInsertRow.");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support deleteRow.");
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkIfClosed();
        return this.parentStatement != null ? this.parentStatement.getStatement() : null;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        this.checkIfClosed();
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return null;
        }
        int columnSqlType = this.resultSetMetaData.getColumnType(columnIndex);
        String columnTypeText = this.resultSetMetaData.getColumnTypeName(columnIndex);
        Class<?> returnObjectType = map.get(columnTypeText);
        if (returnObjectType != null) {
            try {
                return ConverterHelper.convertSqlTypeToSpecificJavaType(returnObjectType, columnSqlType, obj);
            }
            catch (Exception e) {
                this.addWarningAndLog("Exception occurred while converting object into corresponding return object type using getObject(int columnIndex, Map<String, Class<?>> map). Returning null. Exception: " + e.getMessage());
                return null;
            }
        }
        this.addWarningAndLog("Corresponding return object type not found while using getObject(int columnIndex, Map<String, Class<?>> map). Returning null. Object type: " + columnTypeText);
        return null;
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksResultSet - getRef(int columnIndex)");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksResultSet - getBlob(int columnIndex)");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksResultSet - getClob(int columnIndex)");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        LOGGER.debug("Getting Array from column index: {}", columnIndex);
        if (!this.complexDatatypeSupport) {
            LOGGER.error("Complex datatype support support is disabled. Use connection parameter `EnableComplexDatatypeSupport=1` to enable it.");
            throw new DatabricksSQLException("Complex datatype support support is disabled. Use connection parameter `EnableComplexDatatypeSupport=1` to enable it.", DatabricksDriverErrorCode.COMPLEX_DATA_TYPE_ARRAY_CONVERSION_ERROR, this.silenceNonTerminalExceptions);
        }
        if (this.resultSetType.equals((Object)ResultSetType.THRIFT_INLINE) || this.resultSetType.equals((Object)ResultSetType.SEA_INLINE)) {
            LOGGER.error("Complex data types are not supported in inline mode");
            throw new DatabricksSQLException("Complex data types are not supported in inline mode", DatabricksDriverErrorCode.COMPLEX_DATA_TYPE_ARRAY_CONVERSION_ERROR, this.silenceNonTerminalExceptions);
        }
        this.checkIfClosed();
        Object obj = this.getObjectInternal(columnIndex);
        return (DatabricksArray)obj;
    }

    @Override
    public Struct getStruct(int columnIndex) throws SQLException {
        LOGGER.debug("Getting Struct from column index: {}", columnIndex);
        if (!this.complexDatatypeSupport) {
            LOGGER.error("Complex datatype support support is disabled. Use connection parameter `EnableComplexDatatypeSupport=1` to enable it.");
            throw new DatabricksSQLException("Complex datatype support support is disabled. Use connection parameter `EnableComplexDatatypeSupport=1` to enable it.", DatabricksDriverErrorCode.COMPLEX_DATA_TYPE_STRUCT_CONVERSION_ERROR, this.silenceNonTerminalExceptions);
        }
        if (this.resultSetType.equals((Object)ResultSetType.THRIFT_INLINE) || this.resultSetType.equals((Object)ResultSetType.SEA_INLINE)) {
            LOGGER.error("Complex data types are not supported in inline mode");
            throw new DatabricksSQLException("Complex data types are not supported in inline mode", DatabricksDriverErrorCode.COMPLEX_DATA_TYPE_STRUCT_CONVERSION_ERROR, this.silenceNonTerminalExceptions);
        }
        this.checkIfClosed();
        Object obj = this.getObjectInternal(columnIndex);
        return (DatabricksStruct)obj;
    }

    public Map getMap(int columnIndex) throws SQLException {
        LOGGER.debug("Getting Map from column index: {}", columnIndex);
        if (!this.complexDatatypeSupport) {
            LOGGER.error("Complex datatype support support is disabled. Use connection parameter `EnableComplexDatatypeSupport=1` to enable it.");
            throw new DatabricksSQLException("Complex datatype support support is disabled. Use connection parameter `EnableComplexDatatypeSupport=1` to enable it.", DatabricksDriverErrorCode.COMPLEX_DATA_TYPE_MAP_CONVERSION_ERROR, this.silenceNonTerminalExceptions);
        }
        if (this.resultSetType.equals((Object)ResultSetType.THRIFT_INLINE) || this.resultSetType.equals((Object)ResultSetType.SEA_INLINE)) {
            LOGGER.error("Complex data types are not supported in inline mode");
            throw new DatabricksSQLException("Complex data types are not supported in inline mode", DatabricksDriverErrorCode.COMPLEX_DATA_TYPE_MAP_CONVERSION_ERROR, this.silenceNonTerminalExceptions);
        }
        this.checkIfClosed();
        Object obj = this.getObjectInternal(columnIndex);
        return (Map)obj;
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.getColumnNameIndex(columnLabel), map);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        this.checkIfClosed();
        return this.getRef(this.getColumnNameIndex(columnLabel));
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        this.checkIfClosed();
        return this.getBlob(this.getColumnNameIndex(columnLabel));
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        this.checkIfClosed();
        return this.getClob(this.getColumnNameIndex(columnLabel));
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        this.checkIfClosed();
        return this.getArray(this.getColumnNameIndex(columnLabel));
    }

    @Override
    public Struct getStruct(String columnLabel) throws SQLException {
        this.checkIfClosed();
        return this.getStruct(this.getColumnNameIndex(columnLabel));
    }

    public Map getMap(String columnLabel) throws SQLException {
        this.checkIfClosed();
        return this.getMap(this.getColumnNameIndex(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date date = this.getDate(columnIndex);
        if (date != null && cal != null) {
            Calendar useCal = (Calendar)cal.clone();
            LocalDate ld = date.toLocalDate();
            useCal.set(1, ld.getYear());
            useCal.set(2, ld.getMonthValue() - 1);
            useCal.set(5, ld.getDayOfMonth());
            useCal.set(11, 0);
            useCal.set(12, 0);
            useCal.set(13, 0);
            useCal.set(14, 0);
            return new Date(useCal.getTimeInMillis());
        }
        return date;
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        this.checkIfClosed();
        return this.getDate(this.getColumnNameIndex(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time time = this.getTime(columnIndex);
        if (time != null && cal != null) {
            Calendar useCal = (Calendar)cal.clone();
            LocalTime lt = time.toLocalTime();
            useCal.set(1, 1970);
            useCal.set(2, 0);
            useCal.set(5, 1);
            useCal.set(11, lt.getHour());
            useCal.set(12, lt.getMinute());
            useCal.set(13, lt.getSecond());
            useCal.set(14, (int)time.getTime() % 1000);
            return new Time(useCal.getTimeInMillis());
        }
        return time;
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        this.checkIfClosed();
        return this.getTime(this.getColumnNameIndex(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp timestamp = this.getTimestamp(columnIndex);
        if (timestamp != null && cal != null) {
            Calendar useCal = (Calendar)cal.clone();
            LocalDateTime ldt = timestamp.toLocalDateTime();
            useCal.set(1, ldt.getYear());
            useCal.set(2, ldt.getMonthValue() - 1);
            useCal.set(5, ldt.getDayOfMonth());
            useCal.set(11, ldt.getHour());
            useCal.set(12, ldt.getMinute());
            useCal.set(13, ldt.getSecond());
            useCal.set(14, 0);
            Timestamp ts = new Timestamp(useCal.getTimeInMillis());
            ts.setNanos(timestamp.getNanos());
            return ts;
        }
        return timestamp;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.getColumnNameIndex(columnLabel), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksResultSet - getURL(int columnIndex)");
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksResultSet - getURL(String columnLabel)");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksResultSet - updateRef(int columnIndex, Ref x)");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksResultSet - updateRef(String columnLabel, Ref x)");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksResultSet - updateBlob(int columnIndex, Blob x)");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksResultSet - updateBlob(String columnLabel, Blob x)");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksResultSet - updateClob(int columnIndex, Clob x)");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksResultSet - updateClob(String columnLabel, Clob x)");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksResultSet - updateArray(int columnIndex, Array x)");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksResultSet - updateArray(String columnLabel, Array x)");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksResultSet - getRowId(int columnIndex)");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksResultSet - getRowId(String columnLabel)");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksResultSet - updateRowId(int columnIndex, RowId x)");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksResultSet - updateRowId(String columnLabel, RowId x)");
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkIfClosed();
        return 2;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateNString");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateNString");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateNClob");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksResultSet - getNClob(int columnIndex)");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksResultSet - getNClob(String columnLabel)");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksResultSet - getSQLXML(int columnIndex)");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksResultSet - getSQLXML(String columnLabel)");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateSQLXML");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateSQLXML");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksResultSet - getNString(int columnIndex)");
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksResultSet - getNString(String columnLabel)");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksResultSet - getNCharacterStream(int columnIndex)");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksResultSet - getNCharacterStream(String columnLabel)");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateNCharacterStream");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateCharacterStream");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateCharacterStream");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateBlob");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateBlob");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateClob");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateNClob");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateNCharacterStream");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateCharacterStream");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateCharacterStream");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateBlob");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateBlob");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateClob");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Databricks JDBC has ResultSet as CONCUR_READ_ONLY. Doesn't support update function : updateNClob");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        this.checkIfClosed();
        Object obj = this.getObjectInternal(columnIndex);
        int columnSqlType = this.resultSetMetaData.getColumnType(columnIndex);
        try {
            return (T)ConverterHelper.convertSqlTypeToSpecificJavaType(type, columnSqlType, obj);
        }
        catch (Exception e) {
            String errorMessage = String.format("Exception occurred while converting object into corresponding return object type using getObject(int columnIndex, Class<T> type). ErrorMessage: %s", e.getMessage());
            LOGGER.error(errorMessage);
            throw new DatabricksSQLException(errorMessage, (Throwable)e, DatabricksDriverErrorCode.INVALID_STATE);
        }
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.getColumnNameIndex(columnLabel), type);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        LOGGER.debug("public <T> T unwrap(Class<T> iface)");
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw new DatabricksValidationException(String.format("Class {%s} cannot be wrapped from {%s}", this.getClass().getName(), iface.getName()));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        LOGGER.debug("public boolean isWrapperFor(Class<?> iface)");
        return iface.isInstance(this);
    }

    @Override
    public String getStatementId() {
        return this.statementId.toString();
    }

    @Override
    public StatementStatus getStatementStatus() {
        return this.executionStatus.getSdkStatus();
    }

    @Override
    public IExecutionStatus getExecutionStatus() {
        return this.executionStatus;
    }

    @Override
    public long getUpdateCount() throws SQLException {
        this.checkIfClosed();
        if (this.updateCount != null) {
            return this.updateCount;
        }
        if (this.statementType == StatementType.METADATA || this.statementType == StatementType.QUERY) {
            this.updateCount = 0L;
        } else if (this.hasUpdateCount()) {
            long rowsUpdated = 0L;
            while (this.next()) {
                rowsUpdated += this.getLong(AFFECTED_ROWS_COUNT);
            }
            this.updateCount = rowsUpdated;
        } else {
            this.updateCount = 0L;
        }
        return this.updateCount;
    }

    @Override
    public boolean hasUpdateCount() throws SQLException {
        this.checkIfClosed();
        if (this.statementType == StatementType.UPDATE) {
            return true;
        }
        return this.resultSetMetaData.getColumnNameIndex(AFFECTED_ROWS_COUNT) > -1 && this.resultSetMetaData.getTotalRows() == 1L;
    }

    @Override
    public InputStreamEntity getVolumeOperationInputStream() throws SQLException {
        this.checkIfClosed();
        if (this.executionResult instanceof VolumeOperationResult) {
            return ((VolumeOperationResult)this.executionResult).getVolumeOperationInputStream();
        }
        throw new DatabricksValidationException("Invalid volume operation");
    }

    @Override
    public void setSilenceNonTerminalExceptions() {
        this.silenceNonTerminalExceptions = true;
    }

    @Override
    public void unsetSilenceNonTerminalExceptions() {
        this.silenceNonTerminalExceptions = false;
    }

    private void addWarningAndLog(String warningMessage) {
        LOGGER.warn(warningMessage);
        this.warnings = WarningUtil.addWarning(this.warnings, warningMessage);
    }

    private Object getObjectInternal(int columnIndex) throws SQLException {
        if (columnIndex <= 0) {
            throw new DatabricksSQLException("Invalid column index", DatabricksDriverErrorCode.INVALID_STATE, this.silenceNonTerminalExceptions);
        }
        Object object = this.executionResult.getObject(columnIndex - 1);
        this.wasNull = object == null;
        return object;
    }

    private int getColumnNameIndex(String columnName) {
        return this.resultSetMetaData.getColumnNameIndex(columnName);
    }

    private void checkIfClosed() throws SQLException {
        if (this.isClosed) {
            throw new DatabricksSQLException("Operation not allowed - ResultSet is closed", DatabricksDriverErrorCode.RESULT_SET_CLOSED);
        }
    }

    private <T> T getConvertedObject(int columnIndex, ConverterFunction<T> convertMethod, Supplier<T> defaultValue) throws SQLException {
        this.checkIfClosed();
        Object obj = this.getObjectInternal(columnIndex);
        if (obj == null) {
            return defaultValue.get();
        }
        int columnType = this.resultSetMetaData.getColumnType(columnIndex);
        String columnTypeName = this.resultSetMetaData.getColumnTypeName(columnIndex);
        ObjectConverter converter = ConverterHelper.getConverterForColumnType(columnType, columnTypeName);
        return convertMethod.apply(converter, obj);
    }

    private BigDecimal applyScaleToBigDecimal(BigDecimal bigDecimal, int columnIndex, int scale) throws SQLException {
        if (bigDecimal == null) {
            return null;
        }
        if (this.resultSetMetaData.getColumnType(columnIndex) == 8 || this.resultSetMetaData.getColumnType(columnIndex) == 6) {
            return bigDecimal;
        }
        return bigDecimal.setScale(scale, RoundingMode.HALF_UP);
    }

    public String toString() {
        return new ToStringer(DatabricksResultSet.class).add("statementStatus", this.executionStatus).add("statementId", this.statementId).add("statementType", (Object)this.statementType).add("updateCount", this.updateCount).add("isClosed", this.isClosed).add("wasNull", this.wasNull).add("resultSetType", (Object)this.resultSetType).toString();
    }

    @FunctionalInterface
    private static interface ConverterFunction<T> {
        public T apply(ObjectConverter var1, Object var2) throws SQLException;
    }

    static enum ResultSetType {
        SEA_ARROW_ENABLED,
        SEA_INLINE,
        THRIFT_ARROW_ENABLED,
        THRIFT_INLINE,
        UNASSIGNED;

    }
}

