/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.iam;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.iam.DeleteWorkspaceAssignmentRequest;
import com.databricks.internal.sdk.service.iam.GetWorkspaceAssignmentRequest;
import com.databricks.internal.sdk.service.iam.ListWorkspaceAssignmentRequest;
import com.databricks.internal.sdk.service.iam.PermissionAssignment;
import com.databricks.internal.sdk.service.iam.PermissionAssignments;
import com.databricks.internal.sdk.service.iam.UpdateWorkspaceAssignments;
import com.databricks.internal.sdk.service.iam.WorkspaceAssignmentImpl;
import com.databricks.internal.sdk.service.iam.WorkspaceAssignmentService;
import com.databricks.internal.sdk.service.iam.WorkspacePermissions;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;

@Generated
public class WorkspaceAssignmentAPI {
    private static final Logger LOG = LoggerFactory.getLogger(WorkspaceAssignmentAPI.class);
    private final WorkspaceAssignmentService impl;

    public WorkspaceAssignmentAPI(ApiClient apiClient) {
        this.impl = new WorkspaceAssignmentImpl(apiClient);
    }

    public WorkspaceAssignmentAPI(WorkspaceAssignmentService mock) {
        this.impl = mock;
    }

    public void delete(long workspaceId, long principalId) {
        this.delete(new DeleteWorkspaceAssignmentRequest().setWorkspaceId(workspaceId).setPrincipalId(principalId));
    }

    public void delete(DeleteWorkspaceAssignmentRequest request) {
        this.impl.delete(request);
    }

    public WorkspacePermissions get(long workspaceId) {
        return this.get(new GetWorkspaceAssignmentRequest().setWorkspaceId(workspaceId));
    }

    public WorkspacePermissions get(GetWorkspaceAssignmentRequest request) {
        return this.impl.get(request);
    }

    public Iterable<PermissionAssignment> list(long workspaceId) {
        return this.list(new ListWorkspaceAssignmentRequest().setWorkspaceId(workspaceId));
    }

    public Iterable<PermissionAssignment> list(ListWorkspaceAssignmentRequest request) {
        return new Paginator(request, this.impl::list, PermissionAssignments::getPermissionAssignments, response -> null);
    }

    public PermissionAssignment update(UpdateWorkspaceAssignments request) {
        return this.impl.update(request);
    }

    public WorkspaceAssignmentService impl() {
        return this.impl;
    }
}

