/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.core.utils;

import com.databricks.internal.apache.http.HttpException;
import com.databricks.internal.apache.http.HttpHost;
import com.databricks.internal.apache.http.HttpRequest;
import com.databricks.internal.apache.http.conn.routing.HttpRoute;
import com.databricks.internal.apache.http.conn.routing.HttpRoutePlanner;
import com.databricks.internal.apache.http.impl.conn.DefaultProxyRoutePlanner;
import com.databricks.internal.apache.http.protocol.HttpContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CustomRoutePlanner
implements HttpRoutePlanner {
    private final DefaultProxyRoutePlanner defaultRoutePlanner;
    private final List<Pattern> nonProxyHostRegex;

    public CustomRoutePlanner(HttpHost proxy, String nonProxyHosts) {
        this.defaultRoutePlanner = new DefaultProxyRoutePlanner(proxy);
        this.nonProxyHostRegex = nonProxyHosts == null || nonProxyHosts.isEmpty() ? new ArrayList<Pattern>() : Arrays.stream(nonProxyHosts.split("\\|")).map(host -> host.replace(".", "\\.").replace("*", ".*")).map(Pattern::compile).collect(Collectors.toList());
    }

    @Override
    public HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        String targetHostName = target.getHostName();
        if (this.nonProxyHostRegex.stream().anyMatch(pattern -> pattern.matcher(targetHostName).matches())) {
            return new HttpRoute(target);
        }
        return this.defaultRoutePlanner.determineRoute(target, request, context);
    }
}

