/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.core;

import com.databricks.internal.google.auth.oauth2.GoogleCredentials;
import com.databricks.internal.google.auth.oauth2.IdTokenCredentials;
import com.databricks.internal.google.auth.oauth2.IdTokenProvider;
import com.databricks.internal.google.auth.oauth2.ImpersonatedCredentials;
import com.databricks.internal.sdk.core.CredentialsProvider;
import com.databricks.internal.sdk.core.DatabricksConfig;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.HeaderFactory;
import com.databricks.internal.sdk.core.utils.GoogleUtils;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class GoogleIdCredentialsProvider
implements CredentialsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleIdCredentialsProvider.class);

    @Override
    public String authType() {
        return "google-id";
    }

    @Override
    public HeaderFactory configure(DatabricksConfig config) {
        GoogleCredentials googleCredentials;
        String host = config.getHost();
        String googleServiceAccount = config.getGoogleServiceAccount();
        if (host == null || googleServiceAccount == null || !config.isGcp()) {
            return null;
        }
        try {
            googleCredentials = GoogleCredentials.getApplicationDefault();
        }
        catch (IOException e) {
            LOG.warn("Failed to get Google application default credential." + e);
            return null;
        }
        ImpersonatedCredentials impersonatedCredentials = ImpersonatedCredentials.create(googleCredentials, googleServiceAccount, null, new ArrayList<String>(), 3600);
        IdTokenCredentials idTokenCredentials = IdTokenCredentials.newBuilder().setIdTokenProvider(impersonatedCredentials).setTargetAudience(host).setOptions(Collections.singletonList(IdTokenProvider.Option.INCLUDE_EMAIL)).build();
        ImpersonatedCredentials gcpScopedCredentials = ImpersonatedCredentials.create(googleCredentials, googleServiceAccount, null, GoogleUtils.GCP_SCOPES, 3600);
        return () -> {
            HashMap<String, String> headers = new HashMap<String, String>();
            try {
                headers.put("Authorization", String.format("Bearer %s", idTokenCredentials.refreshAccessToken().getTokenValue()));
            }
            catch (IOException e) {
                String message = "Failed to refresh access token from id token credentials.";
                LOG.error(message + e);
                throw new DatabricksException(message, e);
            }
            if (config.isAccountClient()) {
                try {
                    headers.put(GoogleUtils.SA_ACCESS_TOKEN_HEADER, gcpScopedCredentials.refreshAccessToken().getTokenValue());
                }
                catch (IOException e) {
                    String message = "Failed to refresh access token from scoped id token credentials.";
                    LOG.error(message + e);
                    throw new DatabricksException(message, e);
                }
            }
            return headers;
        };
    }
}

