/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.operation.relateng;

import com.databricks.internal.jts.geom.Envelope;
import com.databricks.internal.jts.index.chain.MonotoneChain;
import com.databricks.internal.jts.index.chain.MonotoneChainBuilder;
import com.databricks.internal.jts.index.hprtree.HPRtree;
import com.databricks.internal.jts.noding.SegmentString;
import com.databricks.internal.jts.operation.relateng.EdgeSegmentIntersector;
import com.databricks.internal.jts.operation.relateng.EdgeSegmentOverlapAction;
import com.databricks.internal.jts.operation.relateng.RelateSegmentString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class EdgeSetIntersector {
    private HPRtree index = new HPRtree();
    private Envelope envelope;
    private List<MonotoneChain> monoChains = new ArrayList<MonotoneChain>();
    private int idCounter = 0;

    public EdgeSetIntersector(List<RelateSegmentString> edgesA, List<RelateSegmentString> edgesB, Envelope env) {
        this.envelope = env;
        this.addEdges(edgesA);
        this.addEdges(edgesB);
        this.index.build();
    }

    private void addEdges(Collection<RelateSegmentString> segStrings) {
        for (SegmentString segmentString : segStrings) {
            this.addToIndex(segmentString);
        }
    }

    private void addToIndex(SegmentString segStr) {
        List segChains = MonotoneChainBuilder.getChains(segStr.getCoordinates(), segStr);
        for (MonotoneChain mc : segChains) {
            if (this.envelope != null && !this.envelope.intersects(mc.getEnvelope())) continue;
            mc.setId(this.idCounter++);
            this.index.insert(mc.getEnvelope(), mc);
            this.monoChains.add(mc);
        }
    }

    public void process(EdgeSegmentIntersector intersector) {
        EdgeSegmentOverlapAction overlapAction = new EdgeSegmentOverlapAction(intersector);
        for (MonotoneChain queryChain : this.monoChains) {
            List overlapChains = this.index.query(queryChain.getEnvelope());
            for (MonotoneChain testChain : overlapChains) {
                if (testChain.getId() <= queryChain.getId()) continue;
                testChain.computeOverlaps(queryChain, overlapAction);
                if (!intersector.isDone()) continue;
                return;
            }
        }
    }
}

