/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.operation.overlayng;

import com.databricks.internal.jts.algorithm.Orientation;
import com.databricks.internal.jts.algorithm.locate.IndexedPointInAreaLocator;
import com.databricks.internal.jts.algorithm.locate.PointOnGeometryLocator;
import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.CoordinateList;
import com.databricks.internal.jts.geom.Envelope;
import com.databricks.internal.jts.geom.GeometryFactory;
import com.databricks.internal.jts.geom.LinearRing;
import com.databricks.internal.jts.geom.Polygon;
import com.databricks.internal.jts.geom.TopologyException;
import com.databricks.internal.jts.operation.overlayng.OverlayEdge;
import java.util.ArrayList;
import java.util.List;

class OverlayEdgeRing {
    private OverlayEdge startEdge;
    private LinearRing ring;
    private boolean isHole;
    private Coordinate[] ringPts;
    private IndexedPointInAreaLocator locator;
    private OverlayEdgeRing shell;
    private List<OverlayEdgeRing> holes = new ArrayList<OverlayEdgeRing>();

    public OverlayEdgeRing(OverlayEdge start, GeometryFactory geometryFactory) {
        this.startEdge = start;
        this.ringPts = this.computeRingPts(start);
        this.computeRing(this.ringPts, geometryFactory);
    }

    public LinearRing getRing() {
        return this.ring;
    }

    private Envelope getEnvelope() {
        return this.ring.getEnvelopeInternal();
    }

    public boolean isHole() {
        return this.isHole;
    }

    public void setShell(OverlayEdgeRing shell) {
        this.shell = shell;
        if (shell != null) {
            shell.addHole(this);
        }
    }

    public boolean hasShell() {
        return this.shell != null;
    }

    public OverlayEdgeRing getShell() {
        if (this.isHole()) {
            return this.shell;
        }
        return this;
    }

    public void addHole(OverlayEdgeRing ring) {
        this.holes.add(ring);
    }

    private Coordinate[] computeRingPts(OverlayEdge start) {
        OverlayEdge edge = start;
        CoordinateList pts = new CoordinateList();
        do {
            if (edge.getEdgeRing() == this) {
                throw new TopologyException("Edge visited twice during ring-building at " + edge.getCoordinate(), edge.getCoordinate());
            }
            edge.addCoordinates(pts);
            edge.setEdgeRing(this);
            if (edge.nextResult() != null) continue;
            throw new TopologyException("Found null edge in ring", edge.dest());
        } while ((edge = edge.nextResult()) != start);
        pts.closeRing();
        return pts.toCoordinateArray();
    }

    private void computeRing(Coordinate[] ringPts, GeometryFactory geometryFactory) {
        if (this.ring != null) {
            return;
        }
        this.ring = geometryFactory.createLinearRing(ringPts);
        this.isHole = Orientation.isCCW(this.ring.getCoordinates());
    }

    private Coordinate[] getCoordinates() {
        return this.ringPts;
    }

    public OverlayEdgeRing findEdgeRingContaining(List<OverlayEdgeRing> erList) {
        OverlayEdgeRing minContainingRing = null;
        for (OverlayEdgeRing edgeRing : erList) {
            if (!edgeRing.contains(this) || minContainingRing != null && !super.getEnvelope().contains(edgeRing.getEnvelope())) continue;
            minContainingRing = edgeRing;
        }
        return minContainingRing;
    }

    private PointOnGeometryLocator getLocator() {
        if (this.locator == null) {
            this.locator = new IndexedPointInAreaLocator(this.getRing());
        }
        return this.locator;
    }

    public int locate(Coordinate pt) {
        return this.getLocator().locate(pt);
    }

    private boolean contains(OverlayEdgeRing ring) {
        Envelope testEnv;
        Envelope env = this.getEnvelope();
        if (!env.containsProperly(testEnv = ring.getEnvelope())) {
            return false;
        }
        return this.isPointInOrOut(ring);
    }

    private boolean isPointInOrOut(OverlayEdgeRing ring) {
        for (Coordinate pt : ring.getCoordinates()) {
            int loc = this.locate(pt);
            if (loc == 0) {
                return true;
            }
            if (loc != 2) continue;
            return false;
        }
        return false;
    }

    public Coordinate getCoordinate() {
        return this.ringPts[0];
    }

    public Polygon toPolygon(GeometryFactory factory) {
        LinearRing[] holeLR = null;
        if (this.holes != null) {
            holeLR = new LinearRing[this.holes.size()];
            for (int i = 0; i < this.holes.size(); ++i) {
                holeLR[i] = this.holes.get(i).getRing();
            }
        }
        Polygon poly = factory.createPolygon(this.ring, holeLR);
        return poly;
    }

    public OverlayEdge getEdge() {
        return this.startEdge;
    }
}

