/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.coverage;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.Envelope;
import com.databricks.internal.jts.geom.GeometryFactory;
import com.databricks.internal.jts.geom.LineString;
import com.databricks.internal.jts.geom.Triangle;
import com.databricks.internal.jts.simplify.LinkedLine;

class Corner
implements Comparable<Corner> {
    private LinkedLine edge;
    private int index;
    private int prev;
    private int next;
    private double area;

    public Corner(LinkedLine edge, int i, double area) {
        this.edge = edge;
        this.index = i;
        this.prev = edge.prev(i);
        this.next = edge.next(i);
        this.area = area;
    }

    public boolean isVertex(int index) {
        return index == this.index || index == this.prev || index == this.next;
    }

    public int getIndex() {
        return this.index;
    }

    public Coordinate getCoordinate() {
        return this.edge.getCoordinate(this.index);
    }

    public double getArea() {
        return this.area;
    }

    public Coordinate prev() {
        return this.edge.getCoordinate(this.prev);
    }

    public Coordinate next() {
        return this.edge.getCoordinate(this.next);
    }

    @Override
    public int compareTo(Corner o) {
        int comp = Double.compare(this.area, o.area);
        if (comp != 0) {
            return comp;
        }
        return Integer.compare(this.index, o.index);
    }

    public Envelope envelope() {
        Coordinate pp = this.edge.getCoordinate(this.prev);
        Coordinate p = this.edge.getCoordinate(this.index);
        Coordinate pn = this.edge.getCoordinate(this.next);
        Envelope env = new Envelope(pp, pn);
        env.expandToInclude(p);
        return env;
    }

    public boolean isVertex(Coordinate v) {
        if (v.equals2D(this.edge.getCoordinate(this.prev))) {
            return true;
        }
        if (v.equals2D(this.edge.getCoordinate(this.index))) {
            return true;
        }
        return v.equals2D(this.edge.getCoordinate(this.next));
    }

    public boolean isBaseline(Coordinate p0, Coordinate p1) {
        Coordinate prev = this.prev();
        Coordinate next = this.next();
        if (prev.equals2D(p0) && next.equals2D(p1)) {
            return true;
        }
        return prev.equals2D(p1) && next.equals2D(p0);
    }

    public boolean intersects(Coordinate v) {
        Coordinate pp = this.edge.getCoordinate(this.prev);
        Coordinate p = this.edge.getCoordinate(this.index);
        Coordinate pn = this.edge.getCoordinate(this.next);
        return Triangle.intersects(pp, p, pn, v);
    }

    public boolean isRemoved() {
        return this.edge.prev(this.index) != this.prev || this.edge.next(this.index) != this.next;
    }

    public LineString toLineString() {
        Coordinate pp = this.edge.getCoordinate(this.prev);
        Coordinate p = this.edge.getCoordinate(this.index);
        Coordinate pn = this.edge.getCoordinate(this.next);
        return new GeometryFactory().createLineString(new Coordinate[]{Corner.safeCoord(pp), Corner.safeCoord(p), Corner.safeCoord(pn)});
    }

    public String toString() {
        return this.toLineString().toString();
    }

    private static Coordinate safeCoord(Coordinate p) {
        if (p == null) {
            return new Coordinate(Double.NaN, Double.NaN);
        }
        return p;
    }
}

