/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.algorithm.construct;

import com.databricks.internal.jts.algorithm.construct.IndexedPointInPolygonsLocator;
import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.Point;
import com.databricks.internal.jts.operation.distance.IndexedFacetDistance;

class IndexedDistanceToPoint {
    private Geometry targetGeometry;
    private IndexedFacetDistance facetDistance;
    private IndexedPointInPolygonsLocator ptLocater;

    public IndexedDistanceToPoint(Geometry geom) {
        this.targetGeometry = geom;
    }

    private void init() {
        if (this.facetDistance != null) {
            return;
        }
        this.facetDistance = new IndexedFacetDistance(this.targetGeometry);
        this.ptLocater = new IndexedPointInPolygonsLocator(this.targetGeometry);
    }

    public double distance(Point pt) {
        this.init();
        if (this.isInArea(pt)) {
            return 0.0;
        }
        return this.facetDistance.distance(pt);
    }

    private boolean isInArea(Point pt) {
        return 2 != this.ptLocater.locate(pt.getCoordinate());
    }

    public Coordinate[] nearestPoints(Point pt) {
        this.init();
        if (this.isInArea(pt)) {
            Coordinate p = pt.getCoordinate();
            return new Coordinate[]{p.copy(), p.copy()};
        }
        return this.facetDistance.nearestPoints(pt);
    }
}

