/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.cms;

import com.databricks.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.databricks.internal.bouncycastle.asn1.ASN1Set;
import com.databricks.internal.bouncycastle.asn1.cms.AttributeTable;
import com.databricks.internal.bouncycastle.asn1.cms.AuthEnvelopedData;
import com.databricks.internal.bouncycastle.asn1.cms.ContentInfo;
import com.databricks.internal.bouncycastle.asn1.cms.EncryptedContentInfo;
import com.databricks.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.databricks.internal.bouncycastle.cms.CMSEnvelopedHelper;
import com.databricks.internal.bouncycastle.cms.CMSException;
import com.databricks.internal.bouncycastle.cms.CMSSecureReadableWithAAD;
import com.databricks.internal.bouncycastle.cms.CMSUtils;
import com.databricks.internal.bouncycastle.cms.InputStreamWithMAC;
import com.databricks.internal.bouncycastle.cms.OriginatorInformation;
import com.databricks.internal.bouncycastle.cms.RecipientInformationStore;
import com.databricks.internal.bouncycastle.util.Arrays;
import com.databricks.internal.bouncycastle.util.Encodable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CMSAuthEnvelopedData
implements Encodable {
    RecipientInformationStore recipientInfoStore;
    ContentInfo contentInfo;
    private OriginatorInformation originatorInfo;
    private AlgorithmIdentifier authEncAlg;
    private ASN1Set authAttrs;
    private byte[] mac;
    private ASN1Set unauthAttrs;

    public CMSAuthEnvelopedData(byte[] byArray) throws CMSException {
        this(CMSUtils.readContentInfo(byArray));
    }

    public CMSAuthEnvelopedData(InputStream inputStream) throws CMSException {
        this(CMSUtils.readContentInfo(inputStream));
    }

    public CMSAuthEnvelopedData(ContentInfo contentInfo) throws CMSException {
        this.contentInfo = contentInfo;
        AuthEnvelopedData authEnvelopedData = AuthEnvelopedData.getInstance(contentInfo.getContent());
        if (authEnvelopedData.getOriginatorInfo() != null) {
            this.originatorInfo = new OriginatorInformation(authEnvelopedData.getOriginatorInfo());
        }
        ASN1Set aSN1Set = authEnvelopedData.getRecipientInfos();
        final EncryptedContentInfo encryptedContentInfo = authEnvelopedData.getAuthEncryptedContentInfo();
        this.authEncAlg = encryptedContentInfo.getContentEncryptionAlgorithm();
        this.mac = authEnvelopedData.getMac().getOctets();
        CMSSecureReadableWithAAD cMSSecureReadableWithAAD = new CMSSecureReadableWithAAD(){
            private OutputStream aadStream;

            @Override
            public ASN1Set getAuthAttrSet() {
                return CMSAuthEnvelopedData.this.authAttrs;
            }

            @Override
            public void setAuthAttrSet(ASN1Set aSN1Set) {
            }

            @Override
            public boolean hasAdditionalData() {
                return this.aadStream != null && CMSAuthEnvelopedData.this.authAttrs != null;
            }

            @Override
            public ASN1ObjectIdentifier getContentType() {
                return encryptedContentInfo.getContentType();
            }

            @Override
            public InputStream getInputStream() throws IOException {
                if (this.aadStream != null && CMSAuthEnvelopedData.this.authAttrs != null) {
                    this.aadStream.write(CMSAuthEnvelopedData.this.authAttrs.getEncoded("DER"));
                }
                return new InputStreamWithMAC((InputStream)new ByteArrayInputStream(encryptedContentInfo.getEncryptedContent().getOctets()), CMSAuthEnvelopedData.this.mac);
            }

            @Override
            public void setAADStream(OutputStream outputStream) {
                this.aadStream = outputStream;
            }

            @Override
            public OutputStream getAADStream() {
                return this.aadStream;
            }

            @Override
            public byte[] getMAC() {
                return Arrays.clone(CMSAuthEnvelopedData.this.mac);
            }
        };
        this.authAttrs = authEnvelopedData.getAuthAttrs();
        this.unauthAttrs = authEnvelopedData.getUnauthAttrs();
        this.recipientInfoStore = CMSEnvelopedHelper.buildRecipientInformationStore(aSN1Set, this.authEncAlg, cMSSecureReadableWithAAD);
    }

    public OriginatorInformation getOriginatorInfo() {
        return this.originatorInfo;
    }

    public RecipientInformationStore getRecipientInfos() {
        return this.recipientInfoStore;
    }

    public AttributeTable getAuthAttrs() {
        if (this.authAttrs == null) {
            return null;
        }
        return new AttributeTable(this.authAttrs);
    }

    public AttributeTable getUnauthAttrs() {
        if (this.unauthAttrs == null) {
            return null;
        }
        return new AttributeTable(this.unauthAttrs);
    }

    public byte[] getMac() {
        return Arrays.clone(this.mac);
    }

    public ContentInfo toASN1Structure() {
        return this.contentInfo;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.contentInfo.getEncoded();
    }
}

