/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.apache.hc.client5.http.impl.io;

import com.databricks.internal.apache.hc.core5.http.ClassicHttpResponse;
import com.databricks.internal.apache.hc.core5.http.HttpException;
import com.databricks.internal.apache.hc.core5.http.HttpResponseFactory;
import com.databricks.internal.apache.hc.core5.http.config.Http1Config;
import com.databricks.internal.apache.hc.core5.http.impl.io.DefaultHttpResponseParser;
import com.databricks.internal.apache.hc.core5.http.message.LineParser;
import com.databricks.internal.apache.hc.core5.util.CharArrayBuffer;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;
import java.io.IOException;

public class LenientHttpResponseParser
extends DefaultHttpResponseParser {
    private static final Logger LOG = LoggerFactory.getLogger(LenientHttpResponseParser.class);

    public LenientHttpResponseParser(LineParser lineParser, HttpResponseFactory<ClassicHttpResponse> responseFactory, Http1Config h1Config) {
        super(lineParser, responseFactory, h1Config);
    }

    public LenientHttpResponseParser(Http1Config h1Config) {
        this(null, null, h1Config);
    }

    @Override
    protected ClassicHttpResponse createMessage(CharArrayBuffer buffer) throws IOException {
        try {
            return super.createMessage(buffer);
        }
        catch (HttpException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Garbage in response: {}", (Object)buffer);
            }
            return null;
        }
    }
}

