/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.apache.arrow.vector.complex.impl;

import com.databricks.internal.apache.arrow.vector.complex.impl.AbstractFieldReader;
import com.databricks.internal.apache.arrow.vector.holders.DecimalHolder;
import com.databricks.internal.apache.arrow.vector.holders.NullableDecimalHolder;
import com.databricks.internal.apache.arrow.vector.types.Types;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NullableDecimalHolderReaderImpl
extends AbstractFieldReader {
    private NullableDecimalHolder holder;

    public NullableDecimalHolderReaderImpl(NullableDecimalHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.DECIMAL;
    }

    @Override
    public boolean isSet() {
        return this.holder.isSet == 1;
    }

    @Override
    public void read(DecimalHolder h2) {
        h2.start = this.holder.start;
        h2.buffer = this.holder.buffer;
        h2.scale = this.holder.scale;
        h2.precision = this.holder.precision;
    }

    @Override
    public void read(NullableDecimalHolder h2) {
        h2.start = this.holder.start;
        h2.buffer = this.holder.buffer;
        h2.scale = this.holder.scale;
        h2.precision = this.holder.precision;
        h2.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public BigDecimal readBigDecimal() {
        if (!this.isSet()) {
            return null;
        }
        byte[] bytes = new byte[16];
        this.holder.buffer.getBytes(this.holder.start, bytes, 0, 16);
        BigDecimal value = new BigDecimal(new BigInteger(bytes), this.holder.scale);
        return value;
    }

    @Override
    public Object readObject() {
        return this.readBigDecimal();
    }
}

