/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.precision;

import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.precision.CommonBitsRemover;

public class CommonBitsOp {
    private boolean returnToOriginalPrecision = true;
    private CommonBitsRemover cbr;

    public CommonBitsOp() {
        this(true);
    }

    public CommonBitsOp(boolean returnToOriginalPrecision) {
        this.returnToOriginalPrecision = returnToOriginalPrecision;
    }

    public Geometry intersection(Geometry geom0, Geometry geom1) {
        Geometry[] geom = this.removeCommonBits(geom0, geom1);
        return this.computeResultPrecision(geom[0].intersection(geom[1]));
    }

    public Geometry union(Geometry geom0, Geometry geom1) {
        Geometry[] geom = this.removeCommonBits(geom0, geom1);
        return this.computeResultPrecision(geom[0].union(geom[1]));
    }

    public Geometry difference(Geometry geom0, Geometry geom1) {
        Geometry[] geom = this.removeCommonBits(geom0, geom1);
        return this.computeResultPrecision(geom[0].difference(geom[1]));
    }

    public Geometry symDifference(Geometry geom0, Geometry geom1) {
        Geometry[] geom = this.removeCommonBits(geom0, geom1);
        return this.computeResultPrecision(geom[0].symDifference(geom[1]));
    }

    public Geometry buffer(Geometry geom0, double distance) {
        Geometry geom = this.removeCommonBits(geom0);
        return this.computeResultPrecision(geom.buffer(distance));
    }

    private Geometry computeResultPrecision(Geometry result) {
        if (this.returnToOriginalPrecision) {
            this.cbr.addCommonBits(result);
        }
        return result;
    }

    private Geometry removeCommonBits(Geometry geom0) {
        this.cbr = new CommonBitsRemover();
        this.cbr.add(geom0);
        Geometry geom = this.cbr.removeCommonBits(geom0.copy());
        return geom;
    }

    private Geometry[] removeCommonBits(Geometry geom0, Geometry geom1) {
        this.cbr = new CommonBitsRemover();
        this.cbr.add(geom0);
        this.cbr.add(geom1);
        Geometry[] geom = new Geometry[]{this.cbr.removeCommonBits(geom0.copy()), this.cbr.removeCommonBits(geom1.copy())};
        return geom;
    }
}

