/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.operation.overlayng;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.operation.overlayng.OverlayEdge;
import com.databricks.internal.jts.operation.overlayng.OverlayLabel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class OverlayGraph {
    private List<OverlayEdge> edges = new ArrayList<OverlayEdge>();
    private Map<Coordinate, OverlayEdge> nodeMap = new HashMap<Coordinate, OverlayEdge>();

    public Collection<OverlayEdge> getEdges() {
        return this.edges;
    }

    public Collection<OverlayEdge> getNodeEdges() {
        return this.nodeMap.values();
    }

    public OverlayEdge getNodeEdge(Coordinate nodePt) {
        return this.nodeMap.get(nodePt);
    }

    public List<OverlayEdge> getResultAreaEdges() {
        ArrayList<OverlayEdge> resultEdges = new ArrayList<OverlayEdge>();
        for (OverlayEdge edge : this.getEdges()) {
            if (!edge.isInResultArea()) continue;
            resultEdges.add(edge);
        }
        return resultEdges;
    }

    public OverlayEdge addEdge(Coordinate[] pts, OverlayLabel label) {
        OverlayEdge e = OverlayEdge.createEdgePair(pts, label);
        this.insert(e);
        this.insert(e.symOE());
        return e;
    }

    private void insert(OverlayEdge e) {
        this.edges.add(e);
        OverlayEdge nodeEdge = this.nodeMap.get(e.orig());
        if (nodeEdge != null) {
            nodeEdge.insert(e);
        } else {
            this.nodeMap.put(e.orig(), e);
        }
    }
}

