/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.algorithm.construct;

import com.databricks.internal.jts.algorithm.locate.IndexedPointInAreaLocator;
import com.databricks.internal.jts.algorithm.locate.PointOnGeometryLocator;
import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.Envelope;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.util.PolygonalExtracter;
import com.databricks.internal.jts.index.strtree.STRtree;
import java.util.List;

class IndexedPointInPolygonsLocator
implements PointOnGeometryLocator {
    private Geometry geom;
    private STRtree index;

    public IndexedPointInPolygonsLocator(Geometry geom) {
        this.geom = geom;
    }

    private void init() {
        if (this.index != null) {
            return;
        }
        List<Geometry> polys = PolygonalExtracter.getPolygonals(this.geom);
        this.index = new STRtree();
        for (int i = 0; i < polys.size(); ++i) {
            Geometry poly = polys.get(i);
            this.index.insert(poly.getEnvelopeInternal(), (Object)new IndexedPointInAreaLocator(poly));
        }
    }

    @Override
    public int locate(Coordinate p) {
        this.init();
        List results = this.index.query(new Envelope(p));
        for (IndexedPointInAreaLocator ptLocater : results) {
            int loc = ptLocater.locate(p);
            if (loc == 2) continue;
            return loc;
        }
        return 2;
    }
}

