/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.operator.bc;

import com.databricks.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.databricks.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.databricks.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.databricks.internal.bouncycastle.crypto.AsymmetricBlockCipher;
import com.databricks.internal.bouncycastle.crypto.encodings.PKCS1Encoding;
import com.databricks.internal.bouncycastle.crypto.engines.RSABlindedEngine;
import com.databricks.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.databricks.internal.bouncycastle.crypto.util.PublicKeyFactory;
import com.databricks.internal.bouncycastle.operator.bc.BcAsymmetricKeyWrapper;
import java.io.IOException;

public class BcRSAAsymmetricKeyWrapper
extends BcAsymmetricKeyWrapper {
    public BcRSAAsymmetricKeyWrapper(AlgorithmIdentifier algorithmIdentifier, AsymmetricKeyParameter asymmetricKeyParameter) {
        super(algorithmIdentifier, asymmetricKeyParameter);
    }

    public BcRSAAsymmetricKeyWrapper(AlgorithmIdentifier algorithmIdentifier, SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        super(algorithmIdentifier, PublicKeyFactory.createKey(subjectPublicKeyInfo));
    }

    @Override
    protected AsymmetricBlockCipher createAsymmetricWrapper(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return new PKCS1Encoding(new RSABlindedEngine());
    }
}

