/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.provisioning;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.provisioning.CreateWorkspaceRequest;
import com.databricks.internal.sdk.service.provisioning.DeleteWorkspaceRequest;
import com.databricks.internal.sdk.service.provisioning.GetWorkspaceRequest;
import com.databricks.internal.sdk.service.provisioning.UpdateWorkspaceRequest;
import com.databricks.internal.sdk.service.provisioning.Workspace;
import com.databricks.internal.sdk.service.provisioning.WorkspacesService;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;
import java.util.Collection;

@Generated
class WorkspacesImpl
implements WorkspacesService {
    private final ApiClient apiClient;

    public WorkspacesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public Workspace create(CreateWorkspaceRequest request) {
        String path = String.format("/api/2.0/accounts/%s/workspaces", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, Workspace.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteWorkspaceRequest request) {
        String path = String.format("/api/2.0/accounts/%s/workspaces/%s", this.apiClient.configuredAccountID(), request.getWorkspaceId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Workspace get(GetWorkspaceRequest request) {
        String path = String.format("/api/2.0/accounts/%s/workspaces/%s", this.apiClient.configuredAccountID(), request.getWorkspaceId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, Workspace.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Collection<Workspace> list() {
        String path = String.format("/api/2.0/accounts/%s/workspaces", this.apiClient.configuredAccountID());
        Request req = new Request("GET", path);
        req.withHeader("Accept", "application/json");
        return this.apiClient.getCollection(req, Workspace.class);
    }

    @Override
    public void update(UpdateWorkspaceRequest request) {
        String path = String.format("/api/2.0/accounts/%s/workspaces/%s", this.apiClient.configuredAccountID(), request.getWorkspaceId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

