/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.catalog;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.catalog.CreateExternalLineageRelationshipRequest;
import com.databricks.internal.sdk.service.catalog.DeleteExternalLineageRelationshipRequest;
import com.databricks.internal.sdk.service.catalog.DeleteRequestExternalLineage;
import com.databricks.internal.sdk.service.catalog.ExternalLineageImpl;
import com.databricks.internal.sdk.service.catalog.ExternalLineageInfo;
import com.databricks.internal.sdk.service.catalog.ExternalLineageObject;
import com.databricks.internal.sdk.service.catalog.ExternalLineageRelationship;
import com.databricks.internal.sdk.service.catalog.ExternalLineageService;
import com.databricks.internal.sdk.service.catalog.LineageDirection;
import com.databricks.internal.sdk.service.catalog.ListExternalLineageRelationshipsRequest;
import com.databricks.internal.sdk.service.catalog.ListExternalLineageRelationshipsResponse;
import com.databricks.internal.sdk.service.catalog.UpdateExternalLineageRelationshipRequest;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ExternalLineageAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalLineageAPI.class);
    private final ExternalLineageService impl;

    public ExternalLineageAPI(ApiClient apiClient) {
        this.impl = new ExternalLineageImpl(apiClient);
    }

    public ExternalLineageAPI(ExternalLineageService mock) {
        this.impl = mock;
    }

    public ExternalLineageRelationship createExternalLineageRelationship(CreateExternalLineageRelationshipRequest request) {
        return this.impl.createExternalLineageRelationship(request);
    }

    public void deleteExternalLineageRelationship(DeleteRequestExternalLineage externalLineageRelationship) {
        this.deleteExternalLineageRelationship(new DeleteExternalLineageRelationshipRequest().setExternalLineageRelationship(externalLineageRelationship));
    }

    public void deleteExternalLineageRelationship(DeleteExternalLineageRelationshipRequest request) {
        this.impl.deleteExternalLineageRelationship(request);
    }

    public Iterable<ExternalLineageInfo> listExternalLineageRelationships(ExternalLineageObject objectInfo, LineageDirection lineageDirection) {
        return this.listExternalLineageRelationships(new ListExternalLineageRelationshipsRequest().setObjectInfo(objectInfo).setLineageDirection(lineageDirection));
    }

    public Iterable<ExternalLineageInfo> listExternalLineageRelationships(ListExternalLineageRelationshipsRequest request) {
        return new Paginator(request, this.impl::listExternalLineageRelationships, ListExternalLineageRelationshipsResponse::getExternalLineageRelationships, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public ExternalLineageRelationship updateExternalLineageRelationship(UpdateExternalLineageRelationshipRequest request) {
        return this.impl.updateExternalLineageRelationship(request);
    }

    public ExternalLineageService impl() {
        return this.impl;
    }
}

