/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.pkcs.jcajce;

import com.databricks.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.databricks.internal.bouncycastle.asn1.DERNull;
import com.databricks.internal.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import com.databricks.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.databricks.internal.bouncycastle.jcajce.PKCS12Key;
import com.databricks.internal.bouncycastle.jcajce.io.MacOutputStream;
import com.databricks.internal.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import com.databricks.internal.bouncycastle.jcajce.util.JcaJceHelper;
import com.databricks.internal.bouncycastle.jcajce.util.NamedJcaJceHelper;
import com.databricks.internal.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import com.databricks.internal.bouncycastle.operator.GenericKey;
import com.databricks.internal.bouncycastle.operator.MacCalculator;
import com.databricks.internal.bouncycastle.operator.OperatorCreationException;
import com.databricks.internal.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import com.databricks.internal.bouncycastle.pkcs.PKCS12MacCalculatorBuilderProvider;
import java.io.OutputStream;
import java.security.Provider;
import javax.crypto.Mac;
import javax.crypto.spec.PBEParameterSpec;

public class JcePKCS12MacCalculatorBuilderProvider
implements PKCS12MacCalculatorBuilderProvider {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JcePKCS12MacCalculatorBuilderProvider setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePKCS12MacCalculatorBuilderProvider setProvider(String string) {
        this.helper = new NamedJcaJceHelper(string);
        return this;
    }

    @Override
    public PKCS12MacCalculatorBuilder get(final AlgorithmIdentifier algorithmIdentifier) {
        return new PKCS12MacCalculatorBuilder(){

            @Override
            public MacCalculator build(char[] cArray) throws OperatorCreationException {
                final PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                try {
                    final ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
                    final Mac mac = JcePKCS12MacCalculatorBuilderProvider.this.helper.createMac(aSN1ObjectIdentifier.getId());
                    PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
                    final PKCS12Key pKCS12Key = new PKCS12Key(cArray);
                    mac.init(pKCS12Key, pBEParameterSpec);
                    return new MacCalculator(){

                        @Override
                        public AlgorithmIdentifier getAlgorithmIdentifier() {
                            return new AlgorithmIdentifier(aSN1ObjectIdentifier, pKCS12PBEParams);
                        }

                        @Override
                        public OutputStream getOutputStream() {
                            return new MacOutputStream(mac);
                        }

                        @Override
                        public byte[] getMac() {
                            return mac.doFinal();
                        }

                        @Override
                        public GenericKey getKey() {
                            return new GenericKey(this.getAlgorithmIdentifier(), pKCS12Key.getEncoded());
                        }
                    };
                }
                catch (Exception exception) {
                    throw new OperatorCreationException("unable to create MAC calculator: " + exception.getMessage(), exception);
                }
            }

            @Override
            public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
                return new AlgorithmIdentifier(algorithmIdentifier.getAlgorithm(), DERNull.INSTANCE);
            }
        };
    }
}

