/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.pkcs.bc;

import com.databricks.internal.bouncycastle.asn1.DERNull;
import com.databricks.internal.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.databricks.internal.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import com.databricks.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.databricks.internal.bouncycastle.crypto.ExtendedDigest;
import com.databricks.internal.bouncycastle.crypto.digests.SHA1Digest;
import com.databricks.internal.bouncycastle.operator.MacCalculator;
import com.databricks.internal.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import com.databricks.internal.bouncycastle.pkcs.bc.PKCS12PBEUtils;
import java.security.SecureRandom;

public class BcPKCS12MacCalculatorBuilder
implements PKCS12MacCalculatorBuilder {
    private ExtendedDigest digest;
    private AlgorithmIdentifier algorithmIdentifier;
    private SecureRandom random;
    private int saltLength;
    private int iterationCount = 1024;

    public BcPKCS12MacCalculatorBuilder() {
        this(new SHA1Digest(), new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, DERNull.INSTANCE));
    }

    public BcPKCS12MacCalculatorBuilder(ExtendedDigest extendedDigest, AlgorithmIdentifier algorithmIdentifier) {
        this.digest = extendedDigest;
        this.algorithmIdentifier = algorithmIdentifier;
        this.saltLength = extendedDigest.getDigestSize();
    }

    public BcPKCS12MacCalculatorBuilder setIterationCount(int n) {
        this.iterationCount = n;
        return this;
    }

    @Override
    public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    @Override
    public MacCalculator build(char[] cArray) {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        byte[] byArray = new byte[this.saltLength];
        this.random.nextBytes(byArray);
        return PKCS12PBEUtils.createMacCalculator(this.algorithmIdentifier.getAlgorithm(), this.digest, new PKCS12PBEParams(byArray, this.iterationCount), cArray);
    }
}

