/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.streams;

import java.io.IOException;
import java.io.InputStream;

public class TruncatedInputStream
extends InputStream {
    private final InputStream m_wrapped;
    private long m_allowedLength;

    public TruncatedInputStream(InputStream inputStream, long l) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        if (l < 0L) {
            throw new IllegalArgumentException("allowedLength cannot be negative!");
        }
        this.m_wrapped = inputStream;
        this.m_allowedLength = l;
    }

    @Override
    public int read() throws IOException {
        if (this.m_allowedLength == 0L) {
            return -1;
        }
        int n = this.m_wrapped.read();
        if (n != -1) {
            --this.m_allowedLength;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.m_allowedLength == 0L) {
            return -1;
        }
        int n3 = this.m_wrapped.read(byArray, n, n2 = (int)Math.min((long)n2, this.m_allowedLength));
        if (n3 != -1) {
            assert ((long)n3 <= this.m_allowedLength);
            this.m_allowedLength -= (long)n3;
        }
        return n3;
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min((long)this.m_wrapped.available(), this.m_allowedLength);
    }

    @Override
    public void close() throws IOException {
        this.m_wrapped.close();
    }
}

