/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.value.functor.arithmetic;

import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.value.functor.arithmetic.IBinaryArithmeticFunctor;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.exceptions.ErrorException;

public abstract class AbstractIntBinArithFunctor
implements IBinaryArithmeticFunctor {
    protected boolean m_isSigned;

    protected AbstractIntBinArithFunctor(boolean bl) {
        this.m_isSigned = bl;
    }

    @Override
    public boolean execute(ETDataRequest eTDataRequest, ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2, IWarningListener iWarningListener) throws ErrorException {
        long l;
        if (iSqlDataWrapper.isNull() || iSqlDataWrapper2.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        long l2 = iSqlDataWrapper.getInteger();
        long l3 = this.calculate(l2, l = iSqlDataWrapper2.getInteger());
        if (!this.checkRange(l3)) {
            throw SQLEngineExceptionFactory.numArithOverflowException();
        }
        eTDataRequest.getData().setInteger(l3);
        return false;
    }

    protected abstract long calculate(long var1, long var3) throws ErrorException;

    private boolean checkRange(long l) {
        if (this.m_isSigned) {
            return Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE;
        }
        return 0L <= l && l <= 0xFFFFFFFFL;
    }
}

