/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.relation.join;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.dsi.dataengine.utilities.CursorType;
import com.databricks.client.sqlengine.aeprocessor.aetree.AEComparisonType;
import com.databricks.client.sqlengine.aeprocessor.aetree.AESortSpec;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEJoin;
import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.sqlengine.executor.conversions.ISqlConverter;
import com.databricks.client.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.databricks.client.sqlengine.executor.etree.ETCancelState;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.IMemManagerAgent;
import com.databricks.client.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.databricks.client.sqlengine.executor.etree.relation.join.AbstractJoinAlgorithmAdaper;
import com.databricks.client.sqlengine.executor.etree.relation.join.ETConvertColRelation;
import com.databricks.client.sqlengine.executor.etree.relation.join.HHJoinDataSource;
import com.databricks.client.sqlengine.executor.etree.relation.join.HasherFactory;
import com.databricks.client.sqlengine.executor.etree.relation.join.IJoinUnit;
import com.databricks.client.sqlengine.executor.etree.relation.join.IMasterJoinUnit;
import com.databricks.client.sqlengine.executor.etree.relation.join.ISlaveJoinUnit;
import com.databricks.client.sqlengine.executor.etree.relation.join.NBFallBackJoinAlgorithm;
import com.databricks.client.sqlengine.executor.etree.relation.join.Partition;
import com.databricks.client.sqlengine.executor.etree.temptable.IRowView;
import com.databricks.client.sqlengine.executor.etree.temptable.InMemTable;
import com.databricks.client.sqlengine.executor.etree.temptable.LongDataStore;
import com.databricks.client.sqlengine.executor.etree.temptable.RowComparator;
import com.databricks.client.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.databricks.client.sqlengine.utilities.ExternalAlgorithmUtil;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.Pair;
import com.databricks.client.support.exceptions.ErrorException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class HybridHashJoinAlgorithm
extends AbstractJoinAlgorithmAdaper {
    private static final int BUFFER_SIZE = 8192;
    private LinkedList<Pair<Partition, Partition>> m_toJoin;
    private LinkedList<Pair<Partition, Partition>> m_joined;
    private Pair<Partition, Partition> m_repartionPair;
    private boolean m_isMasterOnLeft;
    private NBFallBackJoinAlgorithm m_fallback;
    private ExternalAlgorithmUtil.ExternalAlgorithmProperties m_extAlgoProperties;
    private boolean m_needsReset;
    private ETConvertColRelation m_leftRelation;
    private ETConvertColRelation m_rightRelation;
    private HashJoinProperties m_property;
    private LongDataStore m_longDataStore;
    private long m_memoryAvailable;
    private IMemManagerAgent m_memAgent;
    private HasherFactory m_hsFactory;
    private RowComparator m_comparator;
    private int m_leftOverHead;
    private int m_rightOverHead;
    private boolean m_needMemory;
    private final ETCancelState m_cancelState;
    private boolean m_loadNextJoinUnitCalledSinceLastReset = false;
    private boolean m_doneFirstPass = false;

    public HybridHashJoinAlgorithm(ETRelationalExpr eTRelationalExpr, ETRelationalExpr eTRelationalExpr2, int[] nArray, int[] nArray2, AEJoin.AEJoinType aEJoinType, ExternalAlgorithmUtil.ExternalAlgorithmProperties externalAlgorithmProperties, List<IColumn> list, List<ISqlConverter> list2, List<ISqlConverter> list3, ETCancelState eTCancelState, boolean[] blArray) throws ErrorException {
        super(aEJoinType);
        int n;
        IColumn[] iColumnArray;
        Object object;
        if (null != externalAlgorithmProperties.getLogger()) {
            LogUtilities.logFunctionEntrance(externalAlgorithmProperties.getLogger(), new Object[0]);
        }
        assert (nArray.length == nArray2.length);
        for (int i = 0; i < nArray.length; ++i) {
            object = eTRelationalExpr.getColumn(nArray[i]);
            iColumnArray = eTRelationalExpr2.getColumn(nArray2[i]);
            if (!ColumnSizeCalculator.isLongData((IColumn)object, externalAlgorithmProperties.getCellMemoryLimit()) && !ColumnSizeCalculator.isLongData((IColumn)iColumnArray, externalAlgorithmProperties.getCellMemoryLimit())) continue;
            throw SQLEngineExceptionFactory.joinOnLongData(nArray[i]);
        }
        this.m_hsFactory = new HasherFactory();
        this.m_memoryAvailable = 0L;
        this.m_extAlgoProperties = externalAlgorithmProperties;
        this.m_needsReset = false;
        this.m_cancelState = eTCancelState;
        this.m_needMemory = true;
        this.m_joined = new LinkedList();
        this.m_toJoin = new LinkedList();
        this.m_leftRelation = this.wrapInputRelation(eTRelationalExpr, nArray, list, list2, Arrays.copyOfRange(blArray, 0, eTRelationalExpr.getColumnCount()));
        this.m_rightRelation = this.wrapInputRelation(eTRelationalExpr2, nArray2, list, list3, Arrays.copyOfRange(blArray, eTRelationalExpr.getColumnCount(), blArray.length));
        IColumn[] iColumnArray2 = new IColumn[this.m_leftRelation.getColumnCount()];
        object = new boolean[this.m_leftRelation.getColumnCount()];
        iColumnArray = new IColumn[this.m_rightRelation.getColumnCount()];
        boolean[] blArray2 = new boolean[this.m_rightRelation.getColumnCount()];
        boolean bl = false;
        for (n = 0; n < iColumnArray2.length; ++n) {
            iColumnArray2[n] = this.m_leftRelation.getColumn(n);
            if (!bl && ColumnSizeCalculator.isLongData(iColumnArray2[n], externalAlgorithmProperties.getCellMemoryLimit())) {
                bl = true;
            }
            object[n] = this.m_leftRelation.getDataNeeded(n);
        }
        for (n = 0; n < iColumnArray.length; ++n) {
            iColumnArray[n] = this.m_rightRelation.getColumn(n);
            if (!bl && ColumnSizeCalculator.isLongData(iColumnArray[n], externalAlgorithmProperties.getCellMemoryLimit())) {
                bl = true;
            }
            blArray2[n] = this.m_rightRelation.getDataNeeded(n);
        }
        this.m_longDataStore = null;
        if (bl) {
            this.m_longDataStore = new LongDataStore(externalAlgorithmProperties.getStorageDir(), 8192L, externalAlgorithmProperties.getLogger());
        }
        this.m_comparator = this.createHashColComparator(list);
        this.m_leftOverHead = new InMemTable(iColumnArray2, externalAlgorithmProperties.getCellMemoryLimit(), -1, (boolean[])object, externalAlgorithmProperties.getLogger()).getMemOverhead();
        this.m_rightOverHead = new InMemTable(iColumnArray, externalAlgorithmProperties.getCellMemoryLimit(), -1, blArray2, externalAlgorithmProperties.getLogger()).getMemOverhead();
        this.m_property = new HashJoinProperties(externalAlgorithmProperties.getStorageDir(), externalAlgorithmProperties.getCellMemoryLimit(), ExternalAlgorithmUtil.calculateRowSize(Arrays.asList(iColumnArray), blArray2, externalAlgorithmProperties.getCellMemoryLimit()), ExternalAlgorithmUtil.calculateRowSize(Arrays.asList(iColumnArray2), (boolean[])object, externalAlgorithmProperties.getCellMemoryLimit()), externalAlgorithmProperties.getLogger(), this.m_joinType, new HasherFactory(), (boolean[])object, blArray2, iColumnArray2, iColumnArray, nArray, nArray2, list.toArray(new IColumn[list.size()]));
    }

    @Override
    public boolean isMasterJoinUnitOnLeft() {
        if (null != this.m_fallback) {
            return this.m_fallback.isMasterJoinUnitOnLeft();
        }
        return this.m_isMasterOnLeft;
    }

    @Override
    public void closeRelations(boolean bl) {
        if (null != this.m_property.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_property.m_logger, new Object[0]);
        }
        if (this.m_fallback != null) {
            this.m_fallback.closeRelations(bl);
            this.m_fallback = null;
        }
        this.m_leftRelation.close(bl);
        this.m_rightRelation.close(bl);
        this.destroyPartitions(this.m_joined);
        this.destroyPartitions(this.m_toJoin);
        if (null != this.m_longDataStore) {
            this.m_longDataStore.destroy();
            this.m_longDataStore = null;
        }
        if (!bl) {
            this.m_memAgent.recycleMemory(this.m_memoryAvailable);
            this.m_memAgent.unregisterConsumer();
        }
    }

    @Override
    public void open(CursorType cursorType) throws ErrorException {
        if (null != this.m_property.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_property.m_logger, new Object[0]);
        }
        assert (CursorType.FORWARD_ONLY == cursorType);
        this.m_leftRelation.open(cursorType);
        this.m_rightRelation.open(cursorType);
        this.m_toJoin.clear();
        this.loadFirstPartition();
    }

    @Override
    public void reset() throws ErrorException {
        if (null != this.m_property.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_property.m_logger, new Object[0]);
        }
        if (!this.m_needsReset || !this.m_loadNextJoinUnitCalledSinceLastReset) {
            this.m_needsReset = true;
            this.m_leftRelation.reset();
            this.m_rightRelation.reset();
            this.destroyPartitions(this.m_toJoin);
            this.m_toJoin.clear();
            this.loadFirstPartition();
        } else {
            if (this.m_repartionPair != null) {
                this.m_repartionPair.key().finishExecution();
                this.m_repartionPair.value().finishExecution();
            }
            this.disposeCurrentPartion();
            this.m_toJoin.addAll(this.m_joined);
            this.m_joined.clear();
            if (this.m_leftRelation.isOpen()) {
                this.m_leftRelation.close(this.m_leftRelation.canReopenAfterClosed());
            }
            if (this.m_rightRelation.isOpen()) {
                this.m_rightRelation.close(this.m_rightRelation.canReopenAfterClosed());
            }
        }
        this.m_loadNextJoinUnitCalledSinceLastReset = false;
    }

    @Override
    public void registerManagerAgent(IMemManagerAgent iMemManagerAgent) {
        this.m_memAgent = iMemManagerAgent;
    }

    @Override
    public long assign(long l) {
        if (this.m_needMemory) {
            this.m_memoryAvailable += l;
            return l;
        }
        return 0L;
    }

    @Override
    public long getRequiredMemory() {
        long l = this.m_property.m_leftRowSize < 8192L ? 8192L : this.m_property.m_leftRowSize;
        long l2 = this.m_property.m_rightRowSize < 8192L ? 8192L : this.m_property.m_rightRowSize;
        return (long)(this.m_leftOverHead + this.m_rightOverHead) + 2L * (l + l2) + 8192L;
    }

    @Override
    public Pair<? extends IJoinUnit, ? extends IJoinUnit> loadNextJoinUnit() throws ErrorException {
        this.m_loadNextJoinUnitCalledSinceLastReset = true;
        if (null != this.m_fallback) {
            Pair<? extends IJoinUnit, ? extends IJoinUnit> pair = this.m_fallback.loadNextJoinUnit();
            if (null != pair) {
                return pair;
            }
            this.m_fallback.closeRelations(this.m_canReopenAfterClosed);
            this.m_fallback = null;
        }
        return super.loadNextJoinUnit();
    }

    @Override
    public void match() throws ErrorException {
        if (null != this.m_fallback) {
            this.m_fallback.match();
            return;
        }
        super.match();
    }

    @Override
    public boolean isOuterRow() {
        if (null != this.m_fallback) {
            return this.m_fallback.isOuterRow();
        }
        return super.isOuterRow();
    }

    @Override
    public boolean moveMaster() throws ErrorException {
        if (null != this.m_fallback) {
            return this.m_fallback.moveMaster();
        }
        return super.moveMaster();
    }

    @Override
    public boolean moveSlave() throws ErrorException {
        if (null != this.m_fallback) {
            return this.m_fallback.moveSlave();
        }
        return super.moveSlave();
    }

    @Override
    public void seekSlave() {
        if (null != this.m_fallback) {
            this.m_fallback.seekSlave();
        } else {
            super.seekSlave();
        }
    }

    @Override
    public Pair<ISlaveJoinUnit, IMasterJoinUnit> loadMasterSlave() throws ErrorException {
        boolean bl;
        this.disposeCurrentPartion();
        if (this.m_toJoin.size() == 0) {
            return null;
        }
        this.m_repartionPair = this.m_toJoin.poll();
        Partition partition = this.m_repartionPair.key();
        Partition partition2 = this.m_repartionPair.value();
        if (partition == null || partition2 == null) {
            assert (partition != null || partition2 != null);
            this.m_isMasterOnLeft = partition2 == null;
            Partition partition3 = this.m_isMasterOnLeft ? partition : partition2;
            this.m_joined.add(this.m_repartionPair);
            this.m_repartionPair = null;
            partition3.initAsMaster(false, this.m_needsReset, this.m_memoryAvailable, null, this.computeSaveOuter(this.m_isMasterOnLeft), this.m_cancelState);
            return new Pair<ISlaveJoinUnit, IMasterJoinUnit>(new EmptySlaveUnit(), partition3);
        }
        boolean bl2 = this.requiredFitInMem(partition, true) <= this.m_memoryAvailable;
        boolean bl3 = bl = this.requiredFitInMem(partition2, false) <= this.m_memoryAvailable;
        if (bl2 && !bl || bl2 && partition.getSize() >= partition2.getSize()) {
            this.m_isMasterOnLeft = false;
            partition.initAsSlave(false, this.m_needsReset, this.getSlaveMemory(true), partition2, this.m_comparator, this.m_cancelState);
            partition2.initAsMaster(false, this.m_needsReset, 0L, partition, this.computeSaveOuter(this.m_isMasterOnLeft), this.m_cancelState);
            this.m_joined.add(this.m_repartionPair);
            this.m_repartionPair = null;
            return new Pair<ISlaveJoinUnit, IMasterJoinUnit>(partition, partition2);
        }
        if (bl && !bl2 || bl && partition.getSize() < partition2.getSize()) {
            this.m_isMasterOnLeft = true;
            partition2.initAsSlave(false, this.m_needsReset, this.getSlaveMemory(false), partition, this.m_comparator, this.m_cancelState);
            partition.initAsMaster(false, this.m_needsReset, 0L, partition2, this.computeSaveOuter(this.m_isMasterOnLeft), this.m_cancelState);
            this.m_joined.add(this.m_repartionPair);
            this.m_repartionPair = null;
            return new Pair<ISlaveJoinUnit, IMasterJoinUnit>(partition2, partition);
        }
        long l = this.m_memoryAvailable - (long)this.m_leftOverHead - (long)this.m_rightOverHead - 8192L;
        if (partition.canRepartition()) {
            this.m_isMasterOnLeft = false;
            partition.initAsSlave(true, this.m_needsReset, l - this.m_property.m_rightRowSize, partition2, this.m_comparator, this.m_cancelState);
            partition2.initAsMaster(true, this.m_needsReset, this.m_property.m_rightRowSize + partition.takeExtraMem(), partition, this.computeSaveOuter(this.m_isMasterOnLeft), this.m_cancelState);
            return new Pair<ISlaveJoinUnit, IMasterJoinUnit>(partition, partition2);
        }
        if (partition2.canRepartition()) {
            this.m_isMasterOnLeft = true;
            partition2.initAsSlave(true, this.m_needsReset, l - this.m_property.m_leftRowSize, partition, this.m_comparator, this.m_cancelState);
            partition.initAsMaster(true, this.m_needsReset, this.m_property.m_leftRowSize + partition2.takeExtraMem(), partition2, this.computeSaveOuter(this.m_isMasterOnLeft), this.m_cancelState);
            return new Pair<ISlaveJoinUnit, IMasterJoinUnit>(partition2, partition);
        }
        this.m_fallback = this.createFallback(partition, partition2);
        if (this.m_needsReset) {
            this.m_joined.add(this.m_repartionPair);
        }
        this.m_repartionPair = null;
        Pair<? extends IJoinUnit, ? extends IJoinUnit> pair = this.m_fallback.loadNextJoinUnit();
        if (this.m_fallback.isMasterJoinUnitOnLeft()) {
            return new Pair<ISlaveJoinUnit, IMasterJoinUnit>((ISlaveJoinUnit)pair.value(), (IMasterJoinUnit)pair.key());
        }
        return new Pair<ISlaveJoinUnit, IMasterJoinUnit>((ISlaveJoinUnit)pair.key(), (IMasterJoinUnit)pair.value());
    }

    private void loadFirstPartition() {
        Partition partition = new Partition(new HHJoinDataSource(this.m_leftRelation, this.m_longDataStore, this.m_property.m_leftDataNeeded, this.m_property.m_leftMetadata, this.m_property.m_maxInMemDataLen), this.m_property.m_leftMetadata, this.m_property.m_leftHashColumns, this.m_property.m_hashColMeta, this.m_hsFactory, this.m_property.m_leftDataNeeded, this.m_extAlgoProperties, this.m_longDataStore);
        Partition partition2 = new Partition(new HHJoinDataSource(this.m_rightRelation, this.m_longDataStore, this.m_property.m_rightDataNeeded, this.m_property.m_rightMetadata, this.m_property.m_maxInMemDataLen), this.m_property.m_rightMetadata, this.m_property.m_rightHashColumns, this.m_property.m_hashColMeta, this.m_hsFactory, this.m_property.m_rightDataNeeded, this.m_extAlgoProperties, this.m_longDataStore);
        this.m_toJoin.push(new Pair<Partition, Partition>(partition, partition2));
    }

    private void destroyPartitions(List<Pair<Partition, Partition>> list) {
        for (Pair<Partition, Partition> pair : list) {
            Partition partition = pair.key();
            Partition partition2 = pair.value();
            if (partition != null) {
                partition.destroy();
            }
            if (partition2 == null) continue;
            partition2.destroy();
        }
        list.clear();
    }

    private boolean computeSaveOuter(boolean bl) {
        return bl && (this.m_property.m_type == AEJoin.AEJoinType.FULL_OUTER_JOIN || this.m_property.m_type == AEJoin.AEJoinType.LEFT_OUTER_JOIN) || !bl && (this.m_property.m_type == AEJoin.AEJoinType.FULL_OUTER_JOIN || this.m_property.m_type == AEJoin.AEJoinType.RIGHT_OUTER_JOIN);
    }

    private void disposeCurrentPartion() throws ErrorException {
        if (this.m_repartionPair == null) {
            return;
        }
        Partition partition = this.m_repartionPair.key();
        Partition partition2 = this.m_repartionPair.value();
        if (partition.isRepartion()) {
            Map<Long, Partition> map = partition.takeSubPartition();
            if (!this.m_doneFirstPass && !this.m_canReopenAfterClosed) {
                if (map.isEmpty()) {
                    long l = this.m_property.m_rightRowSize + 8192L + partition.getMemUsage();
                    this.recycleMemory(l);
                }
                this.m_doneFirstPass = true;
            }
            this.mergePartition(map, partition2.takeSubPartition(), this.m_toJoin);
            if (this.m_needsReset) {
                this.mergePartition(partition.takeProcessedPartition(), partition2.takeProcessedPartition(), this.m_joined);
            }
        } else if (this.m_needsReset) {
            this.m_joined.add(this.m_repartionPair);
        }
        if (this.m_needsReset && !this.m_canReopenAfterClosed) {
            long l = this.calculateRequiredMem();
            this.recycleMemory(l);
        }
        this.m_repartionPair = null;
    }

    private void recycleMemory(long l) {
        boolean bl = this.m_needMemory = l > this.m_memoryAvailable;
        if (l < this.m_memoryAvailable) {
            this.m_memAgent.recycleMemory(this.m_memoryAvailable - l);
            this.m_memoryAvailable = l;
        }
    }

    private long calculateRequiredMem() {
        long l;
        long l2 = 0L;
        for (Pair pair : this.m_toJoin) {
            l = Math.min(this.requiredFitInMem((Partition)pair.key(), true), this.requiredFitInMem((Partition)pair.value(), false));
            if (l <= l2) continue;
            l2 = l;
        }
        for (Pair pair : this.m_joined) {
            l = Math.min(this.requiredFitInMem((Partition)pair.key(), true), this.requiredFitInMem((Partition)pair.value(), false));
            if (l <= l2) continue;
            l2 = l;
        }
        assert (l2 >= 0L);
        return l2;
    }

    private void mergePartition(Map<Long, Partition> map, Map<Long, Partition> map2, LinkedList<Pair<Partition, Partition>> linkedList) {
        boolean bl = this.computeSaveOuter(true);
        boolean bl2 = this.computeSaveOuter(false);
        for (Map.Entry<Long, Partition> entry : map.entrySet()) {
            if (map2.containsKey(entry.getKey())) {
                linkedList.add(new Pair(entry.getValue(), map2.get(entry.getKey())));
                map2.remove(entry.getKey());
                continue;
            }
            if (!bl) continue;
            linkedList.add(new Pair(entry.getValue(), null));
        }
        if (bl2) {
            for (Partition partition : map2.values()) {
                linkedList.add(new Pair<Object, Partition>(null, partition));
            }
        }
    }

    private long requiredFitInMem(Partition partition, boolean bl) {
        if (null == partition) {
            long l = bl ? this.m_property.m_rightRowSize : this.m_property.m_leftRowSize;
            return l + 8192L;
        }
        long l = this.m_property.m_leftRowSize + this.m_property.m_rightRowSize;
        long l2 = bl ? (long)this.m_leftOverHead : (long)this.m_rightOverHead;
        long l3 = partition.getSize() + l2 + l + 8192L;
        return l3 >= 0L ? l3 : Long.MAX_VALUE;
    }

    private long getSlaveMemory(boolean bl) {
        long l = bl ? this.m_property.m_rightRowSize : this.m_property.m_leftRowSize;
        long l2 = bl ? (long)this.m_leftOverHead : (long)this.m_rightOverHead;
        return this.m_memoryAvailable - l2 - l - 8192L;
    }

    private NBFallBackJoinAlgorithm createFallback(Partition partition, Partition partition2) throws ErrorException {
        if (null != this.m_property.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_property.m_logger, new Object[0]);
        }
        NBFallBackJoinAlgorithm nBFallBackJoinAlgorithm = new NBFallBackJoinAlgorithm(partition.getDataSource(), partition2.getDataSource(), this.m_joinType, this.m_cancelState, this.m_extAlgoProperties);
        for (int i = 0; i < this.m_property.m_leftHashColumns.length; ++i) {
            nBFallBackJoinAlgorithm.addFilter(this.m_property.m_leftHashColumns[i], this.m_property.m_rightHashColumns[i], AEComparisonType.EQUAL);
        }
        IMemManagerAgent iMemManagerAgent = new IMemManagerAgent(){

            @Override
            public void recycleMemory(long l) {
            }

            @Override
            public void unregisterConsumer() {
            }

            @Override
            public long require(long l, long l2) {
                return -1L;
            }
        };
        nBFallBackJoinAlgorithm.registerManagerAgent(iMemManagerAgent);
        long l = nBFallBackJoinAlgorithm.getRequiredMemory();
        if (l > this.m_memoryAvailable) {
            long l2 = l - this.m_memoryAvailable;
            long l3 = this.m_memAgent.require(l2, l2);
            if (l3 <= 0L) {
                throw SQLEngineExceptionFactory.failedToAllocateMemory("Unknown :: Hybrid Hash Join fall back");
            }
            assert (l3 >= l2);
            this.m_memoryAvailable += l3;
        }
        nBFallBackJoinAlgorithm.assign(this.m_memoryAvailable);
        nBFallBackJoinAlgorithm.open(CursorType.FORWARD_ONLY);
        return nBFallBackJoinAlgorithm;
    }

    private ETConvertColRelation wrapInputRelation(ETRelationalExpr eTRelationalExpr, int[] nArray, List<IColumn> list, List<ISqlConverter> list2, boolean[] blArray) throws ErrorException {
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>(eTRelationalExpr.getColumnCount());
        for (int i = 0; i < eTRelationalExpr.getColumnCount(); ++i) {
            arrayList.add(eTRelationalExpr.getDataNeeded(i));
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(nArray.length);
        ArrayList<IColumn> arrayList3 = new ArrayList<IColumn>(nArray.length);
        ArrayList<ISqlConverter> arrayList4 = new ArrayList<ISqlConverter>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            if (DefaultSqlDataWrapper.isImplicitConvSupported(eTRelationalExpr.getColumn(nArray[i]), list.get(i))) continue;
            arrayList2.add(nArray[i]);
            nArray[i] = eTRelationalExpr.getColumnCount() + arrayList2.size() - 1;
            arrayList3.add(list.get(i));
            ISqlConverter iSqlConverter = list2.get(i);
            assert (iSqlConverter != null);
            arrayList4.add(iSqlConverter);
            arrayList.add(true);
            if (nArray[i] >= eTRelationalExpr.getColumnCount() || blArray[nArray[i]]) continue;
            arrayList.set(nArray[i], false);
        }
        boolean[] blArray2 = new boolean[arrayList.size()];
        for (int i = 0; i < blArray2.length; ++i) {
            blArray2[i] = (Boolean)arrayList.get(i);
        }
        return new ETConvertColRelation(eTRelationalExpr, arrayList3.toArray(new IColumn[arrayList3.size()]), arrayList2.toArray(new Integer[arrayList2.size()]), arrayList4.toArray(new ISqlConverter[arrayList4.size()]), blArray2);
    }

    private RowComparator createHashColComparator(List<IColumn> list) throws ErrorException {
        IColumn[] iColumnArray = new IColumn[list.size()];
        ArrayList<AESortSpec> arrayList = new ArrayList<AESortSpec>(list.size());
        for (int i = 0; i < iColumnArray.length; ++i) {
            iColumnArray[i] = list.get(i);
            arrayList.add(RowComparator.createDefaultSortSpec(i));
        }
        return RowComparator.createComparator(iColumnArray, arrayList, RowComparator.getDefaultNullCollation());
    }

    static final class HashJoinProperties {
        public final IColumn[] m_hashColMeta;
        public final int m_maxInMemDataLen;
        public final long m_rightRowSize;
        public final long m_leftRowSize;
        public final File m_storageDir;
        public final ILogger m_logger;
        public final AEJoin.AEJoinType m_type;
        public final HasherFactory m_hasherFact;
        public final IColumn[] m_leftMetadata;
        public final IColumn[] m_rightMetadata;
        public final boolean[] m_leftDataNeeded;
        public final boolean[] m_rightDataNeeded;
        public final int[] m_leftHashColumns;
        public final int[] m_rightHashColumns;

        public HashJoinProperties(File file, int n, long l, long l2, ILogger iLogger, AEJoin.AEJoinType aEJoinType, HasherFactory hasherFactory, boolean[] blArray, boolean[] blArray2, IColumn[] iColumnArray, IColumn[] iColumnArray2, int[] nArray, int[] nArray2, IColumn[] iColumnArray3) {
            this.m_storageDir = file;
            this.m_maxInMemDataLen = n;
            this.m_rightRowSize = l;
            this.m_leftRowSize = l2;
            this.m_logger = iLogger;
            this.m_type = aEJoinType;
            this.m_hasherFact = hasherFactory;
            this.m_leftDataNeeded = blArray;
            this.m_rightDataNeeded = blArray2;
            this.m_leftMetadata = iColumnArray;
            this.m_rightMetadata = iColumnArray2;
            this.m_leftHashColumns = nArray;
            this.m_rightHashColumns = nArray2;
            this.m_hashColMeta = iColumnArray3;
        }
    }

    private static final class EmptySlaveUnit
    implements ISlaveJoinUnit {
        private EmptySlaveUnit() {
        }

        @Override
        public boolean retrieveData(int n, ETDataRequest eTDataRequest) throws ErrorException {
            throw new IllegalStateException();
        }

        @Override
        public boolean moveToNextRow() {
            return false;
        }

        @Override
        public void close() {
        }

        @Override
        public void seek(IRowView iRowView) {
        }

        @Override
        public boolean moveOuter() {
            return false;
        }

        @Override
        public void setOutputOuter() {
        }

        @Override
        public boolean hasOuterRows() {
            return false;
        }

        @Override
        public void match() {
        }
    }
}

