/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.aeprocessor.metadatautil;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.databricks.client.sqlengine.aeprocessor.aetree.IAENode;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEAdd;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEConcat;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AECountStarAggrFn;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AECustomScalarFn;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEDivide;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEGeneralAggrFn;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AELiteral;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEMultiply;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AENegate;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AENull;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEParameter;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEProxyColumn;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AERename;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEScalarFn;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AESearchedCase;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AESimpleCase;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AESubtract;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.value.AEValueSubQuery;
import com.databricks.client.sqlengine.aeprocessor.metadatautil.AEAbstractColumnInfo;
import com.databricks.client.sqlengine.dsiext.dataengine.IColumnInfo;
import com.databricks.client.support.exceptions.ErrorException;

public class AECoercionColumnInfo
extends AEAbstractColumnInfo {
    private AEValueExpr m_node = null;
    private IColumnInfo.ColumnType m_columnType = null;
    private String m_literalString = null;
    private IColumn m_colMeta = null;

    public AECoercionColumnInfo(AEValueExpr aEValueExpr) {
        this.m_node = aEValueExpr;
        this.m_colMeta = aEValueExpr.getColumn();
        if (aEValueExpr instanceof AEProxyColumn) {
            IColumnInfo iColumnInfo = ((AEProxyColumn)aEValueExpr).getProxiedColumnInfo();
            if (iColumnInfo == null) {
                throw new IllegalArgumentException("Invalid proxy column");
            }
            this.m_columnType = iColumnInfo.getColumnType();
            this.m_literalString = iColumnInfo.getLiteralString();
        }
    }

    @Override
    public IColumnInfo.ColumnType getColumnType() {
        if (this.m_columnType != null) {
            return this.m_columnType;
        }
        try {
            ColumnTypeFinder columnTypeFinder = new ColumnTypeFinder();
            this.m_columnType = this.m_node.acceptVisitor(columnTypeFinder);
            this.m_literalString = columnTypeFinder.getLiterString();
            return this.m_columnType;
        }
        catch (ErrorException errorException) {
            throw new IllegalStateException("Impossible state.", errorException);
        }
    }

    @Override
    public String getLiteralString() {
        if (this.m_columnType == null) {
            this.getColumnType();
        }
        return this.m_literalString;
    }

    @Override
    public IColumn getColumnMetadata() {
        return this.m_colMeta;
    }

    public static class ColumnTypeFinder
    extends AEDefaultVisitor<IColumnInfo.ColumnType> {
        private String m_literalString = null;

        public String getLiterString() {
            return this.m_literalString;
        }

        @Override
        public IColumnInfo.ColumnType visit(AEColumnReference aEColumnReference) {
            return IColumnInfo.ColumnType.COLUMN;
        }

        @Override
        public IColumnInfo.ColumnType visit(AESearchedCase aESearchedCase) {
            return IColumnInfo.ColumnType.CASE_EXPRESSION;
        }

        @Override
        public IColumnInfo.ColumnType visit(AESimpleCase aESimpleCase) {
            return IColumnInfo.ColumnType.CASE_EXPRESSION;
        }

        @Override
        public IColumnInfo.ColumnType visit(AECountStarAggrFn aECountStarAggrFn) {
            return IColumnInfo.ColumnType.SET_FUNCTION;
        }

        @Override
        public IColumnInfo.ColumnType visit(AEGeneralAggrFn aEGeneralAggrFn) {
            return IColumnInfo.ColumnType.SET_FUNCTION;
        }

        @Override
        public IColumnInfo.ColumnType visit(AERename aERename) {
            try {
                return aERename.getOperand().acceptVisitor(this);
            }
            catch (ErrorException errorException) {
                throw new RuntimeException();
            }
        }

        @Override
        public IColumnInfo.ColumnType visit(AEScalarFn aEScalarFn) {
            return IColumnInfo.ColumnType.SCALAR_FUNCTION;
        }

        @Override
        public IColumnInfo.ColumnType visit(AECustomScalarFn aECustomScalarFn) {
            return IColumnInfo.ColumnType.SCALAR_FUNCTION;
        }

        @Override
        public IColumnInfo.ColumnType visit(AELiteral aELiteral) {
            this.m_literalString = aELiteral.getStringValue();
            return IColumnInfo.ColumnType.LITERAL;
        }

        @Override
        public IColumnInfo.ColumnType visit(AENull aENull) {
            return IColumnInfo.ColumnType.NULL;
        }

        @Override
        public IColumnInfo.ColumnType visit(AENegate aENegate) {
            if (aENegate.getOperand() instanceof AELiteral) {
                try {
                    IColumnInfo.ColumnType columnType = aENegate.getOperand().acceptVisitor(this);
                    this.m_literalString = "-" + this.m_literalString;
                    return columnType;
                }
                catch (ErrorException errorException) {
                    throw new RuntimeException(errorException);
                }
            }
            return IColumnInfo.ColumnType.NEGATE;
        }

        @Override
        public IColumnInfo.ColumnType visit(AEAdd aEAdd) {
            return IColumnInfo.ColumnType.PLUS;
        }

        @Override
        public IColumnInfo.ColumnType visit(AEConcat aEConcat) {
            return IColumnInfo.ColumnType.CONCATENATION;
        }

        @Override
        public IColumnInfo.ColumnType visit(AEDivide aEDivide) {
            return IColumnInfo.ColumnType.DIVISION;
        }

        @Override
        public IColumnInfo.ColumnType visit(AEMultiply aEMultiply) {
            return IColumnInfo.ColumnType.MULIPLICATION;
        }

        @Override
        public IColumnInfo.ColumnType visit(AESubtract aESubtract) {
            return IColumnInfo.ColumnType.MINUS;
        }

        @Override
        public IColumnInfo.ColumnType visit(AEParameter aEParameter) {
            if (aEParameter.hasBeenSet()) {
                return IColumnInfo.ColumnType.PARAMETER_SET;
            }
            return IColumnInfo.ColumnType.PARAMETER_UNSET;
        }

        @Override
        public IColumnInfo.ColumnType visit(AEValueSubQuery aEValueSubQuery) {
            return IColumnInfo.ColumnType.SCALAR_SUBQUERY;
        }

        @Override
        public IColumnInfo.ColumnType visit(AEProxyColumn aEProxyColumn) {
            IColumnInfo iColumnInfo = aEProxyColumn.getProxiedColumnInfo();
            if (iColumnInfo == null) {
                throw new IllegalStateException("Proxy column is not properly initialized.");
            }
            this.m_literalString = iColumnInfo.getLiteralString();
            return iColumnInfo.getColumnType();
        }

        @Override
        public IColumnInfo.ColumnType defaultVisit(IAENode iAENode) {
            throw new IllegalStateException("Unexpected node visited. Node: " + iAENode.getLogString());
        }
    }
}

