/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.logging.log4j.core.jackson;

import com.databricks.client.jdbc42.internal.apache.logging.log4j.core.impl.ContextDataFactory;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.core.jackson.MapEntry;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.util.StringMap;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.core.JsonParser;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.core.type.TypeReference;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.databind.DeserializationContext;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.List;

public class ContextDataAsEntryListDeserializer
extends StdDeserializer<StringMap> {
    private static final long serialVersionUID = 1L;

    ContextDataAsEntryListDeserializer() {
        super(StringMap.class);
    }

    @Override
    public StringMap deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        List list = (List)jp.readValueAs(new TypeReference<List<MapEntry>>(){});
        StringMap contextData = ContextDataFactory.createContextData();
        for (MapEntry mapEntry : list) {
            contextData.putValue(mapEntry.getKey(), mapEntry.getValue());
        }
        return contextData;
    }
}

