/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.dsi.core.utilities.impl.future;

import com.databricks.client.dsi.core.utilities.impl.future.ConversionConfig;
import com.databricks.client.dsi.core.utilities.impl.future.NumericJDBCDataSource;
import com.databricks.client.dsi.exceptions.ConversionFailed;
import com.databricks.client.dsi.exceptions.IncorrectTypeException;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class UnsignedTinyIntJDBCDataSource
extends NumericJDBCDataSource {
    private static final short TWO_TO_8 = 256;

    public UnsignedTinyIntJDBCDataSource(IWarningListener iWarningListener, ConversionConfig conversionConfig) {
        super(iWarningListener, conversionConfig);
    }

    @Override
    public Short get() throws ErrorException {
        try {
            short s = this.getAndCheck();
            if (s == 0 && this.wasNull()) {
                return null;
            }
            return s;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public String getString() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        short s = this.getAndCheck();
        if (s == 0 && this.wasNull()) {
            return null;
        }
        return Short.toString(s);
    }

    @Override
    public boolean getBoolean() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        short s = this.getAndCheck();
        if (s > 1) {
            this.onOverflow(s, "getBoolean");
        }
        return s != 0;
    }

    @Override
    public byte getByte() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        short s = this.getAndCheck();
        if (s > 127) {
            this.onOverflow(s, "getByte");
        }
        return (byte)s;
    }

    @Override
    public abstract short getShort() throws ErrorException, SQLException;

    protected final short getAndCheck() throws ErrorException, SQLException {
        short s = this.getShort();
        assert (s >= 0 && s <= 256);
        return s;
    }

    @Override
    public int getInt() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return this.getAndCheck();
    }

    @Override
    public long getLong() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return this.getAndCheck();
    }

    @Override
    public float getFloat() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return this.getAndCheck();
    }

    @Override
    public double getDouble() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return this.getAndCheck();
    }

    @Override
    public BigDecimal getBigDecimal() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        short s = this.getAndCheck();
        if (s == 0 && this.wasNull()) {
            return null;
        }
        return BigDecimal.valueOf(s);
    }

    @Override
    public Object getObject() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        short s = this.getAndCheck();
        if (s == 0 && this.wasNull()) {
            return null;
        }
        return (int)s;
    }
}

