/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.dsi.core.utilities.impl.future;

import com.databricks.client.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.databricks.client.dsi.core.utilities.impl.future.ConversionConfig;
import com.databricks.client.dsi.core.utilities.impl.future.NumericJDBCDataSource;
import com.databricks.client.dsi.exceptions.ConversionFailed;
import com.databricks.client.dsi.exceptions.IncorrectTypeException;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class DecimalJDBCDataSource
extends NumericJDBCDataSource {
    public DecimalJDBCDataSource(IWarningListener iWarningListener, ConversionConfig conversionConfig) {
        super(iWarningListener, conversionConfig);
    }

    protected final void handleConversionResult(BigDecimal bigDecimal, int n, String string) throws ConversionFailed {
        switch (this.getListener().getStatus()) {
            case SUCCESS: {
                break;
            }
            case FRACTIONAL_TRUNCATION: {
                this.onFractionalTruncation(bigDecimal, n, string);
                break;
            }
            case OVERFLOW: {
                this.onOverflow(bigDecimal, string);
            }
        }
    }

    @Override
    public abstract BigDecimal get() throws ErrorException;

    @Override
    public String getString() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        BigDecimal bigDecimal = this.get();
        if (bigDecimal == null) {
            return null;
        }
        return bigDecimal.toPlainString();
    }

    @Override
    public boolean getBoolean() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        BigDecimal bigDecimal = this.get();
        if (bigDecimal == null) {
            return false;
        }
        boolean bl = NonTrivialJDBCConversions.doubleToBoolean(bigDecimal.doubleValue(), this.getAndClearListener());
        this.handleConversionResult(bigDecimal, 0, "getBoolean");
        return bl;
    }

    @Override
    public byte getByte() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        BigDecimal bigDecimal = this.get();
        if (bigDecimal == null) {
            return 0;
        }
        byte by = NonTrivialJDBCConversions.DecimalConverter.toByte(bigDecimal, this.getAndClearListener());
        this.handleConversionResult(bigDecimal, 0, "getByte");
        return by;
    }

    @Override
    public short getShort() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        BigDecimal bigDecimal = this.get();
        if (bigDecimal == null) {
            return 0;
        }
        short s = NonTrivialJDBCConversions.DecimalConverter.toShort(bigDecimal, this.getAndClearListener());
        this.handleConversionResult(bigDecimal, 0, "getShort");
        return s;
    }

    @Override
    public int getInt() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        BigDecimal bigDecimal = this.get();
        if (bigDecimal == null) {
            return 0;
        }
        int n = NonTrivialJDBCConversions.DecimalConverter.toInt(bigDecimal, this.getAndClearListener());
        this.handleConversionResult(bigDecimal, 0, "getInt");
        return n;
    }

    @Override
    public long getLong() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        BigDecimal bigDecimal = this.get();
        if (bigDecimal == null) {
            return 0L;
        }
        long l = NonTrivialJDBCConversions.DecimalConverter.toLong(bigDecimal, this.getAndClearListener());
        this.handleConversionResult(bigDecimal, 0, "getLong");
        return l;
    }

    @Override
    public float getFloat() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return (float)this.getDouble();
    }

    @Override
    public double getDouble() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        BigDecimal bigDecimal = this.get();
        if (bigDecimal == null) {
            return 0.0;
        }
        return bigDecimal.doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        return this.get();
    }
}

