/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import grpc_shaded.com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.connect.proto.Command;
import org.apache.spark.connect.proto.ExecutePlanResponse;
import org.apache.spark.connect.proto.StreamingQueryManagerCommand;
import org.apache.spark.connect.proto.StreamingQueryManagerCommandResult;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connect.common.InvalidPlanInput;
import org.apache.spark.sql.connect.common.InvalidPlanInput$;
import org.apache.spark.sql.connect.common.StreamingListenerPacket;
import org.apache.spark.sql.streaming.RemoteStreamingQuery$;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.util.SparkSerDeUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@Evolving
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001B\t\u0013\u0001uA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\u0007_\u0001!\t\u0001\u0006\u0019\t\u0011Q\u0002\u0001R1A\u0005\nUBQA\u0014\u0001\u0005\u0002=CQA\u0016\u0001\u0005\u0002]CQA\u0016\u0001\u0005\u0002yCQ\u0001\u0019\u0001\u0005\u0002\u0005DQ\u0001\u0019\u0001\u0005\u0002\u0015DQA\u001c\u0001\u0005\u0002\u0005DQa\u001c\u0001\u0005\u0002ADQa\u001d\u0001\u0005\u0002QDQA\u001e\u0001\u0005\u0002]DQ!\u001f\u0001\u0005\niDq!a\b\u0001\t\u0013\t\t\u0003C\u0004\u0002(\u0001!I!!\u000b\t\u000f\u00055\u0002\u0001\"\u0003\u00020\t)2\u000b\u001e:fC6LgnZ)vKJLX*\u00198bO\u0016\u0014(BA\n\u0015\u0003%\u0019HO]3b[&twM\u0003\u0002\u0016-\u0005\u00191/\u001d7\u000b\u0005]A\u0012!B:qCJ\\'BA\r\u001b\u0003\u0019\t\u0007/Y2iK*\t1$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001=\u0011\u0002\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012a!\u00118z%\u00164\u0007CA\u0013)\u001b\u00051#BA\u0014\u0017\u0003!Ig\u000e^3s]\u0006d\u0017BA\u0015'\u0005\u001daunZ4j]\u001e\fAb\u001d9be.\u001cVm]:j_:\u0004\"\u0001L\u0017\u000e\u0003QI!A\f\u000b\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\rqJg.\u001b;?)\t\t4\u0007\u0005\u00023\u00015\t!\u0003C\u0003+\u0005\u0001\u00071&A\u0007mSN$XM\\3s\u0007\u0006\u001c\u0007.Z\u000b\u0002mA!qG\u0010!L\u001b\u0005A$BA\u001d;\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003wq\nA!\u001e;jY*\tQ(\u0001\u0003kCZ\f\u0017BA 9\u00055\u0019uN\\2veJ,g\u000e^'baB\u0011\u0011\t\u0013\b\u0003\u0005\u001a\u0003\"a\u0011\u0011\u000e\u0003\u0011S!!\u0012\u000f\u0002\rq\u0012xn\u001c;?\u0013\t9\u0005%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0013*\u0013aa\u0015;sS:<'BA$!!\t\u0011D*\u0003\u0002N%\t12\u000b\u001e:fC6LgnZ)vKJLH*[:uK:,'/\u0001\u0004bGRLg/Z\u000b\u0002!B\u0019q$U*\n\u0005I\u0003#!B!se\u0006L\bC\u0001\u001aU\u0013\t)&C\u0001\bTiJ,\u0017-\\5oOF+XM]=\u0002\u0007\u001d,G\u000f\u0006\u0002T1\")\u0011,\u0002a\u00015\u0006\u0011\u0011\u000e\u001a\t\u00037rk\u0011AO\u0005\u0003;j\u0012A!V+J\tR\u00111k\u0018\u0005\u00063\u001a\u0001\r\u0001Q\u0001\u0014C^\f\u0017\u000e^!osR+'/\\5oCRLwN\u001c\u000b\u0002EB\u0011qdY\u0005\u0003I\u0002\u0012A!\u00168jiR\u0011a-\u001b\t\u0003?\u001dL!\u0001\u001b\u0011\u0003\u000f\t{w\u000e\\3b]\")!\u000e\u0003a\u0001W\u0006IA/[7f_V$Xj\u001d\t\u0003?1L!!\u001c\u0011\u0003\t1{gnZ\u0001\u0010e\u0016\u001cX\r\u001e+fe6Lg.\u0019;fI\u0006Y\u0011\r\u001a3MSN$XM\\3s)\t\u0011\u0017\u000fC\u0003s\u0015\u0001\u00071*\u0001\u0005mSN$XM\\3s\u00039\u0011X-\\8wK2K7\u000f^3oKJ$\"AY;\t\u000bI\\\u0001\u0019A&\u0002\u001b1L7\u000f\u001e'jgR,g.\u001a:t)\u0005A\bcA\u0010R\u0017\u0006\tR\r_3dkR,W*\u00198bO\u0016\u00148)\u001c3\u0015\u0007m\f9\u0001E\u0002}\u0003\u0007i\u0011! \u0006\u0003}~\fQ\u0001\u001d:pi>T1!!\u0001\u0017\u0003\u001d\u0019wN\u001c8fGRL1!!\u0002~\u0005\t\u001aFO]3b[&tw-U;fefl\u0015M\\1hKJ\u001cu.\\7b]\u0012\u0014Vm];mi\"9\u0011\u0011B\u0007A\u0002\u0005-\u0011\u0001C:fi\u000ekGM\u00128\u0011\r}\ti!!\u0005c\u0013\r\ty\u0001\t\u0002\n\rVt7\r^5p]F\u0002B!a\u0005\u0002\u001a9\u0019A0!\u0006\n\u0007\u0005]Q0\u0001\u000fTiJ,\u0017-\\5oOF+XM]=NC:\fw-\u001a:D_6l\u0017M\u001c3\n\t\u0005m\u0011Q\u0004\u0002\b\u0005VLG\u000eZ3s\u0015\r\t9\"`\u0001\u0012G\u0006\u001c\u0007.\u001a'jgR,g.\u001a:Cs&#G#\u00022\u0002$\u0005\u0015\u0002\"B-\u000f\u0001\u0004\u0001\u0005\"\u0002:\u000f\u0001\u0004Y\u0015aD4fi&#')\u001f'jgR,g.\u001a:\u0015\u0007\u0001\u000bY\u0003C\u0003s\u001f\u0001\u00071*\u0001\u000bsK6|g/Z\"bG\",G\rT5ti\u0016tWM\u001d\u000b\u0004\u0017\u0006E\u0002\"B-\u0011\u0001\u0004\u0001\u0005f\u0001\u0001\u00026A!\u0011qGA\u001f\u001b\t\tIDC\u0002\u0002<Y\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty$!\u000f\u0003\u0011\u00153x\u000e\u001c<j]\u001e\u0004")
public class StreamingQueryManager
implements Logging {
    private ConcurrentMap<String, StreamingQueryListener> listenerCache;
    private final SparkSession sparkSession;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentMap<String, StreamingQueryListener> listenerCache$lzycompute() {
        StreamingQueryManager streamingQueryManager = this;
        synchronized (streamingQueryManager) {
            if (!this.bitmap$0) {
                this.listenerCache = new ConcurrentHashMap<String, StreamingQueryListener>();
                this.bitmap$0 = true;
            }
        }
        return this.listenerCache;
    }

    private ConcurrentMap<String, StreamingQueryListener> listenerCache() {
        return !this.bitmap$0 ? this.listenerCache$lzycompute() : this.listenerCache;
    }

    public StreamingQuery[] active() {
        return (StreamingQuery[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.executeManagerCmd((Function1<StreamingQueryManagerCommand.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.setActive(true);
            return BoxedUnit.UNIT;
        }).getActive().getActiveQueriesList()).asScala()).map((Function1 & Serializable & scala.Serializable)q -> RemoteStreamingQuery$.MODULE$.fromStreamingQueryInstanceResponse($this.sparkSession, (StreamingQueryManagerCommandResult.StreamingQueryInstance)q), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StreamingQuery.class));
    }

    public StreamingQuery get(UUID id) {
        return this.get(id.toString());
    }

    public StreamingQuery get(String id) {
        StreamingQueryManagerCommandResult response = this.executeManagerCmd((Function1<StreamingQueryManagerCommand.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.setGetQuery(id);
            return BoxedUnit.UNIT;
        });
        return response.hasQuery() ? RemoteStreamingQuery$.MODULE$.fromStreamingQueryInstanceResponse(this.sparkSession, response.getQuery()) : null;
    }

    public void awaitAnyTermination() {
        this.executeManagerCmd((Function1<StreamingQueryManagerCommand.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$3 -> {
            StreamingQueryManager.$anonfun$awaitAnyTermination$1(x$3);
            return BoxedUnit.UNIT;
        });
    }

    public boolean awaitAnyTermination(long timeoutMs) {
        Predef$.MODULE$.require(timeoutMs > 0L, (Function0 & Serializable & scala.Serializable)() -> "Timeout has to be positive");
        return this.executeManagerCmd((Function1<StreamingQueryManagerCommand.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$4 -> {
            StreamingQueryManager.$anonfun$awaitAnyTermination$3(timeoutMs, x$4);
            return BoxedUnit.UNIT;
        }).getAwaitAnyTermination().getTerminated();
    }

    public void resetTerminated() {
        this.executeManagerCmd((Function1<StreamingQueryManagerCommand.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.setResetTerminated(true);
            return BoxedUnit.UNIT;
        });
    }

    public void addListener(StreamingQueryListener listener) {
        String id = UUID.randomUUID().toString();
        this.cacheListenerById(id, listener);
        this.executeManagerCmd((Function1<StreamingQueryManagerCommand.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$6 -> {
            StreamingQueryManager.$anonfun$addListener$1(id, listener, x$6);
            return BoxedUnit.UNIT;
        });
    }

    public void removeListener(StreamingQueryListener listener) {
        String id = this.getIdByListener(listener);
        this.executeManagerCmd((Function1<StreamingQueryManagerCommand.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$7 -> {
            StreamingQueryManager.$anonfun$removeListener$1(id, x$7);
            return BoxedUnit.UNIT;
        });
        this.removeCachedListener(id);
    }

    public StreamingQueryListener[] listListeners() {
        return (StreamingQueryListener[])((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)this.executeManagerCmd((Function1<StreamingQueryManagerCommand.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$8 -> {
            x$8.setListListeners(true);
            return BoxedUnit.UNIT;
        }).getListListeners().getListenerIdsList()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)StreamingQueryManager.$anonfun$listListeners$2(this, x$9)))).map((Function1 & Serializable & scala.Serializable)x$10 -> (StreamingQueryListener)this.listenerCache().get(x$10), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StreamingQueryListener.class));
    }

    private StreamingQueryManagerCommandResult executeManagerCmd(Function1<StreamingQueryManagerCommand.Builder, BoxedUnit> setCmdFn) {
        Command.Builder cmdBuilder = Command.newBuilder();
        StreamingQueryManagerCommand.Builder managerCmdBuilder = cmdBuilder.getStreamingQueryManagerCommandBuilder();
        setCmdFn.apply((Object)managerCmdBuilder);
        ExecutePlanResponse resp = (ExecutePlanResponse)this.sparkSession.execute(cmdBuilder.build()).head();
        if (!resp.hasStreamingQueryManagerCommandResult()) {
            throw new RuntimeException("Unexpected missing response for streaming query manager command");
        }
        return resp.getStreamingQueryManagerCommandResult();
    }

    private void cacheListenerById(String id, StreamingQueryListener listener) {
        this.listenerCache().putIfAbsent(id, listener);
    }

    private String getIdByListener(StreamingQueryListener listener) {
        Object object = new Object();
        try {
            this.listenerCache().forEach((k, v) -> {
                if (listener.equals(v)) {
                    throw new NonLocalReturnControl(object, k);
                }
            });
            throw new InvalidPlanInput(new StringBuilder(30).append("No id with listener ").append(listener).append(" is found.").toString(), InvalidPlanInput$.MODULE$.apply$default$2());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (String)ex.value();
        }
    }

    private StreamingQueryListener removeCachedListener(String id) {
        return (StreamingQueryListener)this.listenerCache().remove(id);
    }

    public static final /* synthetic */ void $anonfun$awaitAnyTermination$1(StreamingQueryManagerCommand.Builder x$3) {
        x$3.getAwaitAnyTerminationBuilder().build();
    }

    public static final /* synthetic */ void $anonfun$awaitAnyTermination$3(long timeoutMs$1, StreamingQueryManagerCommand.Builder x$4) {
        x$4.getAwaitAnyTerminationBuilder().setTimeoutMs(timeoutMs$1);
    }

    public static final /* synthetic */ void $anonfun$addListener$1(String id$2, StreamingQueryListener listener$1, StreamingQueryManagerCommand.Builder x$6) {
        x$6.getAddListenerBuilder().setListenerPayload(ByteString.copyFrom(SparkSerDeUtils$.MODULE$.serialize((Object)new StreamingListenerPacket(id$2, listener$1)))).setId(id$2);
    }

    public static final /* synthetic */ void $anonfun$removeListener$1(String id$3, StreamingQueryManagerCommand.Builder x$7) {
        x$7.getRemoveListenerBuilder().setId(id$3);
    }

    public static final /* synthetic */ boolean $anonfun$listListeners$2(StreamingQueryManager $this, String x$9) {
        return $this.listenerCache().containsKey(x$9);
    }

    public StreamingQueryManager(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.$init$((Logging)this);
    }
}

