/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.apache.spark.connect.proto.Command;
import org.apache.spark.connect.proto.ExecutePlanResponse;
import org.apache.spark.connect.proto.StreamingQueryCommand;
import org.apache.spark.connect.proto.StreamingQueryCommandResult;
import org.apache.spark.connect.proto.StreamingQueryManagerCommandResult;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.streaming.RemoteStreamingQuery$;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.StreamingQueryException;
import org.apache.spark.sql.streaming.StreamingQueryProgress;
import org.apache.spark.sql.streaming.StreamingQueryProgress$;
import org.apache.spark.sql.streaming.StreamingQueryStatus;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\u000e\u001d\u0001\u001dB\u0001B\r\u0001\u0003\u0006\u0004%\te\r\u0005\ty\u0001\u0011\t\u0011)A\u0005i!AQ\b\u0001BC\u0002\u0013\u00053\u0007\u0003\u0005?\u0001\t\u0005\t\u0015!\u00035\u0011!y\u0004A!b\u0001\n\u0003\u0002\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B!\t\u00115\u0003!Q1A\u0005B9C\u0001b\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\u0006)\u0002!\t!\u0016\u0005\u00067\u0002!\t\u0005\u0018\u0005\u0006A\u0002!\t%\u0019\u0005\u0006A\u0002!\t%\u001a\u0005\u0006W\u0002!\t\u0005\u001c\u0005\u0006a\u0002!\t%\u001d\u0005\u0006q\u0002!\t%\u001f\u0005\u0006u\u0002!\t%\u0019\u0005\u0006w\u0002!\t%\u0019\u0005\u0006y\u0002!\t%\u0019\u0005\u0006y\u0002!\t% \u0005\b\u0003\u0003\u0001A\u0011IA\u0002\u0011\u001d\t\t\u0002\u0001C\u0005\u0003'9q!!\u0010\u001d\u0011\u0003\tyD\u0002\u0004\u001c9!\u0005\u0011\u0011\t\u0005\u0007)^!\t!a\u0011\t\u000f\u0005\u0015s\u0003\"\u0001\u0002H!9\u0011QK\f\u0005\u0002\u0005]#\u0001\u0006*f[>$Xm\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018P\u0003\u0002\u001e=\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003?\u0001\n1a]9m\u0015\t\t#%A\u0003ta\u0006\u00148N\u0003\u0002$I\u00051\u0011\r]1dQ\u0016T\u0011!J\u0001\u0004_J<7\u0001A\n\u0004\u0001!r\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#AB!osJ+g\r\u0005\u00020a5\tA$\u0003\u000229\tq1\u000b\u001e:fC6LgnZ)vKJL\u0018AA5e+\u0005!\u0004CA\u001b;\u001b\u00051$BA\u001c9\u0003\u0011)H/\u001b7\u000b\u0003e\nAA[1wC&\u00111H\u000e\u0002\u0005+VKE)A\u0002jI\u0002\nQA];o\u0013\u0012\faA];o\u0013\u0012\u0004\u0013\u0001\u00028b[\u0016,\u0012!\u0011\t\u0003\u0005&s!aQ$\u0011\u0005\u0011SS\"A#\u000b\u0005\u00193\u0013A\u0002\u001fs_>$h(\u0003\u0002IU\u00051\u0001K]3eK\u001aL!AS&\u0003\rM#(/\u001b8h\u0015\tA%&A\u0003oC6,\u0007%\u0001\u0007ta\u0006\u00148nU3tg&|g.F\u0001P!\t\u0001\u0016+D\u0001\u001f\u0013\t\u0011fD\u0001\u0007Ta\u0006\u00148nU3tg&|g.A\u0007ta\u0006\u00148nU3tg&|g\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bY;\u0006,\u0017.\u0011\u0005=\u0002\u0001\"\u0002\u001a\n\u0001\u0004!\u0004\"B\u001f\n\u0001\u0004!\u0004\"B \n\u0001\u0004\t\u0005\"B'\n\u0001\u0004y\u0015\u0001C5t\u0003\u000e$\u0018N^3\u0016\u0003u\u0003\"!\u000b0\n\u0005}S#a\u0002\"p_2,\u0017M\\\u0001\u0011C^\f\u0017\u000e\u001e+fe6Lg.\u0019;j_:$\u0012A\u0019\t\u0003S\rL!\u0001\u001a\u0016\u0003\tUs\u0017\u000e\u001e\u000b\u0003;\u001aDQa\u001a\u0007A\u0002!\f\u0011\u0002^5nK>,H/T:\u0011\u0005%J\u0017B\u00016+\u0005\u0011auN\\4\u0002\rM$\u0018\r^;t+\u0005i\u0007CA\u0018o\u0013\tyGD\u0001\u000bTiJ,\u0017-\\5oOF+XM]=Ti\u0006$Xo]\u0001\u000fe\u0016\u001cWM\u001c;Qe><'/Z:t+\u0005\u0011\bcA\u0015tk&\u0011AO\u000b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003_YL!a\u001e\u000f\u0003-M#(/Z1nS:<\u0017+^3ssB\u0013xn\u001a:fgN\fA\u0002\\1tiB\u0013xn\u001a:fgN,\u0012!^\u0001\u0014aJ|7-Z:t\u00032d\u0017I^1jY\u0006\u0014G.Z\u0001\u0005gR|\u0007/A\u0004fqBd\u0017-\u001b8\u0015\u0005\tt\b\"B@\u0014\u0001\u0004i\u0016\u0001C3yi\u0016tG-\u001a3\u0002\u0013\u0015D8-\u001a9uS>tWCAA\u0003!\u0015I\u0013qAA\u0006\u0013\r\tIA\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007=\ni!C\u0002\u0002\u0010q\u0011qc\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u00180\u0012=dKB$\u0018n\u001c8\u0002\u001f\u0015DXmY;uKF+XM]=D[\u0012$B!!\u0006\u0002&A!\u0011qCA\u0011\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011!\u00029s_R|'bAA\u0010A\u000591m\u001c8oK\u000e$\u0018\u0002BA\u0012\u00033\u00111d\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018pQ8n[\u0006tGMU3tk2$\bbBA\u0014+\u0001\u0007\u0011\u0011F\u0001\tg\u0016$8)\u001c3G]B1\u0011&a\u000b\u00020\tL1!!\f+\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u00022\u0005]b\u0002BA\f\u0003gIA!!\u000e\u0002\u001a\u0005)2\u000b\u001e:fC6LgnZ)vKJL8i\\7nC:$\u0017\u0002BA\u001d\u0003w\u0011qAQ;jY\u0012,'O\u0003\u0003\u00026\u0005e\u0011\u0001\u0006*f[>$Xm\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018\u0010\u0005\u00020/M\u0011q\u0003\u000b\u000b\u0003\u0003\u007f\t\u0001D\u001a:p[N#\u0018M\u001d;D_6l\u0017M\u001c3SKN\u0004xN\\:f)\u00151\u0016\u0011JA&\u0011\u0015i\u0015\u00041\u0001P\u0011\u001d\ti%\u0007a\u0001\u0003\u001f\n\u0001B]3ta>t7/\u001a\t\u0005\u0003/\t\t&\u0003\u0003\u0002T\u0005e!aE#yK\u000e,H/\u001a)mC:\u0014Vm\u001d9p]N,\u0017A\t4s_6\u001cFO]3b[&tw-U;fefLen\u001d;b]\u000e,'+Z:q_:\u001cX\rF\u0003W\u00033\nY\u0006C\u0003N5\u0001\u0007q\nC\u0004\u0002^i\u0001\r!a\u0018\u0002\u0003E\u0004B!!\u0019\u0002|9!\u00111MA<\u001d\u0011\t)'!\u001e\u000f\t\u0005\u001d\u00141\u000f\b\u0005\u0003S\n\tH\u0004\u0003\u0002l\u0005=db\u0001#\u0002n%\tQ%\u0003\u0002$I%\u0011\u0011EI\u0005\u0004\u0003?\u0001\u0013\u0002BA\u000e\u0003;IA!!\u001f\u0002\u001a\u0005\u00113\u000b\u001e:fC6LgnZ)vKJLX*\u00198bO\u0016\u00148i\\7nC:$'+Z:vYRLA!! \u0002\u0000\t12\u000b\u001e:fC6LgnZ)vKJL\u0018J\\:uC:\u001cWM\u0003\u0003\u0002z\u0005e\u0001")
public class RemoteStreamingQuery
implements StreamingQuery {
    private final UUID id;
    private final UUID runId;
    private final String name;
    private final SparkSession sparkSession;

    public static RemoteStreamingQuery fromStreamingQueryInstanceResponse(SparkSession sparkSession, StreamingQueryManagerCommandResult.StreamingQueryInstance streamingQueryInstance) {
        return RemoteStreamingQuery$.MODULE$.fromStreamingQueryInstanceResponse(sparkSession, streamingQueryInstance);
    }

    public static RemoteStreamingQuery fromStartCommandResponse(SparkSession sparkSession, ExecutePlanResponse executePlanResponse) {
        return RemoteStreamingQuery$.MODULE$.fromStartCommandResponse(sparkSession, executePlanResponse);
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public UUID runId() {
        return this.runId;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    @Override
    public boolean isActive() {
        return this.executeQueryCmd((Function1<StreamingQueryCommand.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.setStatus(true);
            return BoxedUnit.UNIT;
        }).getStatus().getIsActive();
    }

    @Override
    public void awaitTermination() {
        this.executeQueryCmd((Function1<StreamingQueryCommand.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$2 -> {
            RemoteStreamingQuery.$anonfun$awaitTermination$1(x$2);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public boolean awaitTermination(long timeoutMs) {
        return this.executeQueryCmd((Function1<StreamingQueryCommand.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$3 -> {
            RemoteStreamingQuery.$anonfun$awaitTermination$2(timeoutMs, x$3);
            return BoxedUnit.UNIT;
        }).getAwaitTermination().getTerminated();
    }

    @Override
    public StreamingQueryStatus status() {
        StreamingQueryCommandResult.StatusResult statusResp = this.executeQueryCmd((Function1<StreamingQueryCommand.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.setStatus(true);
            return BoxedUnit.UNIT;
        }).getStatus();
        return new StreamingQueryStatus(statusResp.getStatusMessage(), statusResp.getIsDataAvailable(), statusResp.getIsTriggerActive());
    }

    @Override
    public StreamingQueryProgress[] recentProgress() {
        return (StreamingQueryProgress[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)this.executeQueryCmd((Function1<StreamingQueryCommand.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.setRecentProgress(true);
            return BoxedUnit.UNIT;
        }).getRecentProgress().getRecentProgressJsonList()).asScala()).map((Function1 & Serializable & scala.Serializable)json -> StreamingQueryProgress$.MODULE$.fromJson((String)json), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StreamingQueryProgress.class));
    }

    @Override
    public StreamingQueryProgress lastProgress() {
        return (StreamingQueryProgress)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)this.executeQueryCmd((Function1<StreamingQueryCommand.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.setLastProgress(true);
            return BoxedUnit.UNIT;
        }).getRecentProgress().getRecentProgressJsonList()).asScala()).headOption().map((Function1 & Serializable & scala.Serializable)json -> StreamingQueryProgress$.MODULE$.fromJson((String)json)).orNull(Predef$.MODULE$.$conforms());
    }

    @Override
    public void processAllAvailable() {
        this.executeQueryCmd((Function1<StreamingQueryCommand.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.setProcessAllAvailable(true);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void stop() {
        this.executeQueryCmd((Function1<StreamingQueryCommand.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$8 -> {
            x$8.setStop(true);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void explain() {
        this.explain(false);
    }

    @Override
    public void explain(boolean extended) {
        StreamingQueryCommand.ExplainCommand explainCmd = StreamingQueryCommand.ExplainCommand.newBuilder().setExtended(extended).build();
        String explain = this.executeQueryCmd((Function1<StreamingQueryCommand.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$9 -> {
            x$9.setExplain(explainCmd);
            return BoxedUnit.UNIT;
        }).getExplain().getResult();
        Predef$.MODULE$.println((Object)explain);
    }

    @Override
    public Option<StreamingQueryException> exception() {
        StreamingQueryCommandResult.ExceptionResult exception = this.executeQueryCmd((Function1<StreamingQueryCommand.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.setException(true);
            return BoxedUnit.UNIT;
        }).getException();
        return exception.hasExceptionMessage() ? new Some((Object)new StreamingQueryException(exception.getExceptionMessage(), exception.getErrorClass(), exception.getStackTrace())) : None$.MODULE$;
    }

    private StreamingQueryCommandResult executeQueryCmd(Function1<StreamingQueryCommand.Builder, BoxedUnit> setCmdFn) {
        Command.Builder cmdBuilder = Command.newBuilder();
        StreamingQueryCommand.Builder queryCmdBuilder = cmdBuilder.getStreamingQueryCommandBuilder();
        queryCmdBuilder.getQueryIdBuilder().setId(this.id().toString()).setRunId(this.runId().toString());
        setCmdFn.apply((Object)queryCmdBuilder);
        ExecutePlanResponse resp = (ExecutePlanResponse)this.sparkSession().execute(cmdBuilder.build()).head();
        if (!resp.hasStreamingQueryCommandResult()) {
            throw new RuntimeException("Unexpected missing response for streaming query command");
        }
        return resp.getStreamingQueryCommandResult();
    }

    public static final /* synthetic */ void $anonfun$awaitTermination$1(StreamingQueryCommand.Builder x$2) {
        x$2.getAwaitTerminationBuilder().build();
    }

    public static final /* synthetic */ void $anonfun$awaitTermination$2(long timeoutMs$1, StreamingQueryCommand.Builder x$3) {
        x$3.getAwaitTerminationBuilder().setTimeoutMs(timeoutMs$1);
    }

    public RemoteStreamingQuery(UUID id, UUID runId, String name, SparkSession sparkSession) {
        this.id = id;
        this.runId = runId;
        this.name = name;
        this.sparkSession = sparkSession;
    }
}

