/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import grpc_shaded.com.google.protobuf.ByteString;
import java.util.Locale;
import java.util.concurrent.TimeoutException;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.api.java.function.VoidFunction2;
import org.apache.spark.connect.proto.Command;
import org.apache.spark.connect.proto.ExecutePlanResponse;
import org.apache.spark.connect.proto.ScalarScalaUDF;
import org.apache.spark.connect.proto.WriteStreamOperationStart;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.ForeachWriter;
import org.apache.spark.sql.connect.common.DataTypeProtoConverter$;
import org.apache.spark.sql.connect.common.ForeachWriterPacket;
import org.apache.spark.sql.connect.common.UdfUtils$;
import org.apache.spark.sql.execution.streaming.AvailableNowTrigger$;
import org.apache.spark.sql.execution.streaming.ContinuousTrigger;
import org.apache.spark.sql.execution.streaming.OneTimeTrigger$;
import org.apache.spark.sql.execution.streaming.ProcessingTimeTrigger;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.RemoteStreamingQuery$;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.util.SparkSerDeUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Evolving
@ScalaSignature(bytes="\u0006\u0001\tma\u0001\u0002\r\u001a\u0005\u0011B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\u0007\u0005\u0002!\taG\"\t\u000b\u001d\u0003A\u0011\u0001%\t\u000b\u001d\u0003A\u0011A'\t\u000bi\u0003A\u0011A.\t\u000b\u0001\u0004A\u0011A1\t\u000b\r\u0004A\u0011\u00013\t\u000b\u001d\u0004A\u0011\u00015\t\u000bU\u0004A\u0011\u0001<\t\u000bU\u0004A\u0011A>\t\rU\u0004A\u0011AA\u0002\u0011\u0019)\b\u0001\"\u0001\u0002\u0010!9\u00111\u0004\u0001\u0005\u0002\u0005u\u0001bBA\u000e\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003\u007f\u0001A\u0011AA!\u0011\u001d\ti\u0005\u0001C\u0001\u0003\u001fBq!!\u0014\u0001\t\u0003\ti\u0007C\u0004\u0002\u000e\u0002!\t!a$\t\u000f\u00055\u0005\u0001\"\u0001\u0002\u001c\"9\u0011q\u001c\u0001\u0005\u0002\u0005\u0005\bbBAt\u0001\u0011\u0005\u0011\u0011\u001e\u0005\n\u0003w\u0004!\u0019!C\u0005\u0003{D\u0001Ba\u0006\u0001A\u0003%\u0011q \u0002\u0011\t\u0006$\u0018m\u0015;sK\u0006lwK]5uKJT!AG\u000e\u0002\u0013M$(/Z1nS:<'B\u0001\u000f\u001e\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003=}\tQa\u001d9be.T!\u0001I\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0013aA8sO\u000e\u0001QCA\u0013:'\r\u0001a\u0005\f\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=j\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005Er#a\u0002'pO\u001eLgnZ\u0001\u0003IN\u00042\u0001N\u001b8\u001b\u0005Y\u0012B\u0001\u001c\u001c\u0005\u001d!\u0015\r^1tKR\u0004\"\u0001O\u001d\r\u0001\u0011)!\b\u0001b\u0001w\t\tA+\u0005\u0002=\u007fA\u0011q%P\u0005\u0003}!\u0012qAT8uQ&tw\r\u0005\u0002(\u0001&\u0011\u0011\t\u000b\u0002\u0004\u0003:L\u0018A\u0002\u001fj]&$h\b\u0006\u0002E\rB\u0019Q\tA\u001c\u000e\u0003eAQA\r\u0002A\u0002M\n!b\\;uaV$Xj\u001c3f)\t!\u0015\nC\u0003H\u0007\u0001\u0007!\n\u0005\u0002F\u0017&\u0011A*\u0007\u0002\u000b\u001fV$\b/\u001e;N_\u0012,GC\u0001#O\u0011\u00159E\u00011\u0001P!\t\u0001vK\u0004\u0002R+B\u0011!\u000bK\u0007\u0002'*\u0011AkI\u0001\u0007yI|w\u000e\u001e \n\u0005YC\u0013A\u0002)sK\u0012,g-\u0003\u0002Y3\n11\u000b\u001e:j]\u001eT!A\u0016\u0015\u0002\u000fQ\u0014\u0018nZ4feR\u0011A\t\u0018\u0005\u00065\u0016\u0001\r!\u0018\t\u0003\u000bzK!aX\r\u0003\u000fQ\u0013\u0018nZ4fe\u0006I\u0011/^3ss:\u000bW.\u001a\u000b\u0003\t\nDQ\u0001\u0019\u0004A\u0002=\u000baAZ8s[\u0006$HC\u0001#f\u0011\u00151w\u00011\u0001P\u0003\u0019\u0019x.\u001e:dK\u0006Y\u0001/\u0019:uSRLwN\u001c\"z)\t!\u0015\u000eC\u0003k\u0011\u0001\u00071.\u0001\u0005d_2t\u0015-\\3t!\r9CnT\u0005\u0003[\"\u0012!\u0002\u0010:fa\u0016\fG/\u001a3?Q\tAq\u000e\u0005\u0002qg6\t\u0011O\u0003\u0002sQ\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Q\f(a\u0002<be\u0006\u0014xm]\u0001\u0007_B$\u0018n\u001c8\u0015\u0007\u0011;\u0018\u0010C\u0003y\u0013\u0001\u0007q*A\u0002lKfDQA_\u0005A\u0002=\u000bQA^1mk\u0016$2\u0001\u0012?~\u0011\u0015A(\u00021\u0001P\u0011\u0015Q(\u00021\u0001\u007f!\t9s0C\u0002\u0002\u0002!\u0012qAQ8pY\u0016\fg\u000eF\u0003E\u0003\u000b\t9\u0001C\u0003y\u0017\u0001\u0007q\n\u0003\u0004{\u0017\u0001\u0007\u0011\u0011\u0002\t\u0004O\u0005-\u0011bAA\u0007Q\t!Aj\u001c8h)\u0015!\u0015\u0011CA\n\u0011\u0015AH\u00021\u0001P\u0011\u0019QH\u00021\u0001\u0002\u0016A\u0019q%a\u0006\n\u0007\u0005e\u0001F\u0001\u0004E_V\u0014G.Z\u0001\b_B$\u0018n\u001c8t)\r!\u0015q\u0004\u0005\b\u00037i\u0001\u0019AA\u0011!\u0019\t\u0019#!\u000bP\u001f6\u0011\u0011Q\u0005\u0006\u0004\u0003OA\u0013AC2pY2,7\r^5p]&!\u00111FA\u0013\u0005\ri\u0015\r\u001d\u000b\u0004\t\u0006=\u0002bBA\u000e\u001d\u0001\u0007\u0011\u0011\u0007\t\u0007\u0003g\tidT(\u000e\u0005\u0005U\"\u0002BA\u001c\u0003s\tA!\u001e;jY*\u0011\u00111H\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002,\u0005U\u0012a\u00024pe\u0016\f7\r\u001b\u000b\u0004\t\u0006\r\u0003bBA#\u001f\u0001\u0007\u0011qI\u0001\u0007oJLG/\u001a:\u0011\tQ\nIeN\u0005\u0004\u0003\u0017Z\"!\u0004$pe\u0016\f7\r[,sSR,'/\u0001\u0007g_J,\u0017m\u00195CCR\u001c\u0007\u000eF\u0002E\u0003#Bq!a\u0015\u0011\u0001\u0004\t)&\u0001\u0005gk:\u001cG/[8o!!9\u0013qK\u001a\u0002\n\u0005m\u0013bAA-Q\tIa)\u001e8di&|gN\r\t\u0004O\u0005u\u0013bAA0Q\t!QK\\5uQ\r\u0001\u00121\r\t\u0005\u0003K\nI'\u0004\u0002\u0002h)\u0011!/H\u0005\u0005\u0003W\n9G\u0001\u0005Fm>dg/\u001b8h)\r!\u0015q\u000e\u0005\b\u0003'\n\u0002\u0019AA9!\u001d\t\u0019(! 4\u0003\u0003k!!!\u001e\u000b\t\u0005M\u0013q\u000f\u0006\u0005\u0003w\tIHC\u0002\u0002|u\t1!\u00199j\u0013\u0011\ty(!\u001e\u0003\u001bY{\u0017\u000e\u001a$v]\u000e$\u0018n\u001c83!\u0011\t\u0019)!#\u000e\u0005\u0005\u0015%\u0002BAD\u0003s\tA\u0001\\1oO&!\u0011QBACQ\r\t\u00121M\u0001\u0006gR\f'\u000f\u001e\u000b\u0005\u0003#\u000b9\nE\u0002F\u0003'K1!!&\u001a\u00059\u0019FO]3b[&tw-U;fefDa!!'\u0013\u0001\u0004y\u0015\u0001\u00029bi\"$\"!!%)\u000bM\ty*!-\u0011\u000b\u001d\n\t+!*\n\u0007\u0005\r\u0006F\u0001\u0004uQJ|wo\u001d\t\u0005\u0003O\u000bi+\u0004\u0002\u0002**!\u00111VA\u001b\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003_\u000bIK\u0001\tUS6,w.\u001e;Fq\u000e,\u0007\u000f^5p]F2adTAZ\u0003;\f\u0014bIA[\u0003w\u000b\u0019.!0\u0016\t\u0005]\u0016\u0011X\u000b\u0002\u001f\u00121!h\tb\u0001\u0003\u0007LA!!0\u0002@\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIER1!!1)\u0003\u0019!\bN]8xgF\u0019A(!2\u0011\t\u0005\u001d\u0017Q\u001a\b\u0004O\u0005%\u0017bAAfQ\u00059\u0001/Y2lC\u001e,\u0017\u0002BAh\u0003#\u0014\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005-\u0007&M\u0005$\u0003+\f9.!7\u0002B:\u0019q%a6\n\u0007\u0005\u0005\u0007&M\u0003#O!\nYNA\u0003tG\u0006d\u0017-M\u0002'\u0003K\u000bQ\u0001^1cY\u0016$B!!%\u0002d\"1\u0011Q\u001d\u000bA\u0002=\u000b\u0011\u0002^1cY\u0016t\u0015-\\3\u0002\u000fQ|G+\u00192mKR!\u0011\u0011SAv\u0011\u0019\t)/\u0006a\u0001\u001f\"*Q#a(\u0002pF2adTAy\u0003o\f\u0014bIA[\u0003w\u000b\u00190!02\u0013\r\n).a6\u0002v\u0006\u0005\u0017'\u0002\u0012(Q\u0005m\u0017g\u0001\u0014\u0002&\"\u001aQ#a\u0019\u0002\u0017MLgn\u001b\"vS2$WM]\u000b\u0003\u0003\u007f\u0004BA!\u0001\u0003\u00129!!1\u0001B\u0007\u001b\t\u0011)A\u0003\u0003\u0003\b\t%\u0011!\u00029s_R|'b\u0001B\u0006;\u000591m\u001c8oK\u000e$\u0018\u0002\u0002B\b\u0005\u000b\t\u0011d\u0016:ji\u0016\u001cFO]3b[>\u0003XM]1uS>t7\u000b^1si&!!1\u0003B\u000b\u0005\u001d\u0011U/\u001b7eKJTAAa\u0004\u0003\u0006\u0005a1/\u001b8l\u0005VLG\u000eZ3sA!\u001a\u0001!a\u0019")
public final class DataStreamWriter<T>
implements Logging {
    private final Dataset<T> ds;
    private final WriteStreamOperationStart.Builder sinkBuilder;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public DataStreamWriter<T> partitionBy(String ... colNames) {
        return this.partitionBy((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataStreamWriter<T> outputMode(OutputMode outputMode) {
        this.sinkBuilder().setOutputMode(outputMode.toString().toLowerCase(Locale.ROOT));
        return this;
    }

    public DataStreamWriter<T> outputMode(String outputMode) {
        this.sinkBuilder().setOutputMode(outputMode);
        return this;
    }

    public DataStreamWriter<T> trigger(Trigger trigger) {
        WriteStreamOperationStart.Builder builder;
        Trigger trigger2 = trigger;
        if (trigger2 instanceof ProcessingTimeTrigger) {
            ProcessingTimeTrigger processingTimeTrigger = (ProcessingTimeTrigger)trigger2;
            long intervalMs = processingTimeTrigger.intervalMs();
            builder = this.sinkBuilder().setProcessingTimeInterval(new StringBuilder(13).append(intervalMs).append(" milliseconds").toString());
        } else if (AvailableNowTrigger$.MODULE$.equals(trigger2)) {
            builder = this.sinkBuilder().setAvailableNow(true);
        } else if (OneTimeTrigger$.MODULE$.equals(trigger2)) {
            builder = this.sinkBuilder().setOnce(true);
        } else if (trigger2 instanceof ContinuousTrigger) {
            ContinuousTrigger continuousTrigger = (ContinuousTrigger)trigger2;
            long intervalMs = continuousTrigger.intervalMs();
            builder = this.sinkBuilder().setContinuousCheckpointInterval(new StringBuilder(13).append(intervalMs).append(" milliseconds").toString());
        } else {
            throw new MatchError((Object)trigger2);
        }
        return this;
    }

    public DataStreamWriter<T> queryName(String queryName) {
        this.sinkBuilder().setQueryName(queryName);
        return this;
    }

    public DataStreamWriter<T> format(String source) {
        this.sinkBuilder().setFormat(source);
        return this;
    }

    public DataStreamWriter<T> partitionBy(Seq<String> colNames) {
        this.sinkBuilder().clearPartitioningColumnNames();
        this.sinkBuilder().addAllPartitioningColumnNames((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(colNames).asJava());
        return this;
    }

    public DataStreamWriter<T> option(String key, String value) {
        this.sinkBuilder().putOptions(key, value);
        return this;
    }

    public DataStreamWriter<T> option(String key, boolean value) {
        return this.option(key, Boolean.toString(value));
    }

    public DataStreamWriter<T> option(String key, long value) {
        return this.option(key, Long.toString(value));
    }

    public DataStreamWriter<T> option(String key, double value) {
        return this.option(key, Double.toString(value));
    }

    public DataStreamWriter<T> options(Map<String, String> options) {
        this.options((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(options).asJava());
        return this;
    }

    public DataStreamWriter<T> options(java.util.Map<String, String> options) {
        this.sinkBuilder().putAllOptions(options);
        return this;
    }

    public DataStreamWriter<T> foreach(ForeachWriter<T> writer) {
        byte[] serialized = SparkSerDeUtils$.MODULE$.serialize((Object)new ForeachWriterPacket(writer, this.ds.agnosticEncoder()));
        ScalarScalaUDF.Builder scalaWriterBuilder = ScalarScalaUDF.newBuilder().setPayload(ByteString.copyFrom(serialized));
        this.sinkBuilder().getForeachWriterBuilder().setScalaFunction(scalaWriterBuilder);
        return this;
    }

    @Evolving
    public DataStreamWriter<T> foreachBatch(Function2<Dataset<T>, Object, BoxedUnit> function) {
        byte[] serializedFn = SparkSerDeUtils$.MODULE$.serialize(function);
        this.sinkBuilder().getForeachBatchBuilder().getScalaFunctionBuilder().setPayload(ByteString.copyFrom(serializedFn)).setOutputType(DataTypeProtoConverter$.MODULE$.toConnectProtoType((DataType)NullType$.MODULE$)).setNullable(true);
        return this;
    }

    @Evolving
    public DataStreamWriter<T> foreachBatch(VoidFunction2<Dataset<T>, Long> function) {
        return this.foreachBatch(UdfUtils$.MODULE$.foreachBatchFuncToScalaFunc(function));
    }

    public StreamingQuery start(String path) {
        this.sinkBuilder().setPath(path);
        return this.start();
    }

    public StreamingQuery start() throws TimeoutException {
        Command startCmd = Command.newBuilder().setWriteStreamOperationStart(this.sinkBuilder().build()).build();
        ExecutePlanResponse resp = (ExecutePlanResponse)this.ds.sparkSession().execute(startCmd).head();
        return RemoteStreamingQuery$.MODULE$.fromStartCommandResponse(this.ds.sparkSession(), resp);
    }

    public StreamingQuery table(String tableName) {
        return this.toTable(tableName);
    }

    @Evolving
    public StreamingQuery toTable(String tableName) throws TimeoutException {
        this.sinkBuilder().setTableName(tableName);
        return this.start();
    }

    private WriteStreamOperationStart.Builder sinkBuilder() {
        return this.sinkBuilder;
    }

    public DataStreamWriter(Dataset<T> ds) {
        this.ds = ds;
        Logging.$init$((Logging)this);
        this.sinkBuilder = WriteStreamOperationStart.newBuilder().setInput(ds.plan().getRoot());
    }
}

