/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.Serializable;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.connect.proto.Read;
import org.apache.spark.connect.proto.Relation;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Evolving
@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001B\f\u0019\u0005\rB\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\u0007k\u0001!\tA\u0007\u001c\t\u000bi\u0002A\u0011A\u001e\t\u000b%\u0003A\u0011\u0001&\t\u000b%\u0003A\u0011\u0001*\t\u000bU\u0003A\u0011\u0001,\t\u000bU\u0003A\u0011A.\t\u000bU\u0003A\u0011A1\t\u000bU\u0003A\u0011A4\t\u000b5\u0004A\u0011\u00018\t\u000b5\u0004A\u0011\u0001<\t\r}\u0004A\u0011AA\u0001\u0011\u0019y\b\u0001\"\u0001\u0002\"!9\u0011q\u0005\u0001\u0005\u0002\u0005%\u0002bBA\u0017\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003g\u0001A\u0011AA\u001b\u0011\u001d\tI\u0004\u0001C\u0001\u0003wAq!a\u0010\u0001\t\u0003\t\t\u0005C\u0004\u0002H\u0001!\t!!\u0013\t\u000f\u00055\u0003\u0001\"\u0001\u0002P!I\u0011\u0011\f\u0001C\u0002\u0013%\u00111\f\u0005\t\u0003\u0007\u0003\u0001\u0015!\u0003\u0002^\t\u0001B)\u0019;b'R\u0014X-Y7SK\u0006$WM\u001d\u0006\u00033i\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005ma\u0012aA:rY*\u0011QDH\u0001\u0006gB\f'o\u001b\u0006\u0003?\u0001\na!\u00199bG\",'\"A\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001!#\u0006\u0005\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIcE\u0001\u0004B]f\u0014VM\u001a\t\u0003W9j\u0011\u0001\f\u0006\u0003[q\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003_1\u0012q\u0001T8hO&tw-\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u00023g5\t!$\u0003\u000255\ta1\u000b]1sWN+7o]5p]\u00061A(\u001b8jiz\"\"aN\u001d\u0011\u0005a\u0002Q\"\u0001\r\t\u000bA\u0012\u0001\u0019A\u0019\u0002\r\u0019|'/\\1u)\t9D\bC\u0003>\u0007\u0001\u0007a(\u0001\u0004t_V\u00148-\u001a\t\u0003\u007f\u0019s!\u0001\u0011#\u0011\u0005\u00053S\"\u0001\"\u000b\u0005\r\u0013\u0013A\u0002\u001fs_>$h(\u0003\u0002FM\u00051\u0001K]3eK\u001aL!a\u0012%\u0003\rM#(/\u001b8h\u0015\t)e%\u0001\u0004tG\",W.\u0019\u000b\u0003o-CQ!\u0013\u0003A\u00021\u0003\"!\u0014)\u000e\u00039S!a\u0014\u000e\u0002\u000bQL\b/Z:\n\u0005Es%AC*ueV\u001cG\u000fV=qKR\u0011qg\u0015\u0005\u0006)\u0016\u0001\rAP\u0001\rg\u000eDW-\\1TiJLgnZ\u0001\u0007_B$\u0018n\u001c8\u0015\u0007]:\u0016\fC\u0003Y\r\u0001\u0007a(A\u0002lKfDQA\u0017\u0004A\u0002y\nQA^1mk\u0016$2a\u000e/^\u0011\u0015Av\u00011\u0001?\u0011\u0015Qv\u00011\u0001_!\t)s,\u0003\u0002aM\t9!i\\8mK\u0006tGcA\u001ccG\")\u0001\f\u0003a\u0001}!)!\f\u0003a\u0001IB\u0011Q%Z\u0005\u0003M\u001a\u0012A\u0001T8oOR\u0019q\u0007[5\t\u000baK\u0001\u0019\u0001 \t\u000biK\u0001\u0019\u00016\u0011\u0005\u0015Z\u0017B\u00017'\u0005\u0019!u.\u001e2mK\u00069q\u000e\u001d;j_:\u001cHCA\u001cp\u0011\u0015i'\u00021\u0001q!\u0011\tHO\u0010 \u000e\u0003IT!a\u001d\u0014\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002ve\n\u0019Q*\u00199\u0015\u0005]:\b\"B7\f\u0001\u0004A\b\u0003B=\u007f}yj\u0011A\u001f\u0006\u0003wr\fA!\u001e;jY*\tQ0\u0001\u0003kCZ\f\u0017BA;{\u0003\u0011aw.\u00193\u0015\u0005\u0005\r\u0001\u0003BA\u0003\u00037qA!a\u0002\u0002\u00189!\u0011\u0011BA\u000b\u001d\u0011\tY!a\u0005\u000f\t\u00055\u0011\u0011\u0003\b\u0004\u0003\u0006=\u0011\"A\u0011\n\u0005}\u0001\u0013BA\u000f\u001f\u0013\tYB$C\u0002\u0002\u001ai\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u001e\u0005}!!\u0003#bi\u00064%/Y7f\u0015\r\tIB\u0007\u000b\u0005\u0003\u0007\t\u0019\u0003\u0003\u0004\u0002&5\u0001\rAP\u0001\u0005a\u0006$\b.\u0001\u0003kg>tG\u0003BA\u0002\u0003WAa!!\n\u000f\u0001\u0004q\u0014aA2tmR!\u00111AA\u0019\u0011\u0019\t)c\u0004a\u0001}\u0005\u0019qN]2\u0015\t\u0005\r\u0011q\u0007\u0005\u0007\u0003K\u0001\u0002\u0019\u0001 \u0002\u000fA\f'/];fiR!\u00111AA\u001f\u0011\u0019\t)#\u0005a\u0001}\u0005)A/\u00192mKR!\u00111AA\"\u0011\u0019\t)E\u0005a\u0001}\u0005IA/\u00192mK:\u000bW.Z\u0001\u0005i\u0016DH\u000f\u0006\u0003\u0002\u0004\u0005-\u0003BBA\u0013'\u0001\u0007a(\u0001\u0005uKb$h)\u001b7f)\u0011\t\t&a\u0016\u0011\tI\n\u0019FP\u0005\u0004\u0003+R\"a\u0002#bi\u0006\u001cX\r\u001e\u0005\u0007\u0003K!\u0002\u0019\u0001 \u0002\u001bM|WO]2f\u0005VLG\u000eZ3s+\t\ti\u0006\u0005\u0003\u0002`\u0005ud\u0002BA1\u0003orA!a\u0019\u0002r9!\u0011QMA6\u001d\u0011\tI!a\u001a\n\u0007\u0005%D$A\u0004d_:tWm\u0019;\n\t\u00055\u0014qN\u0001\u0006aJ|Go\u001c\u0006\u0004\u0003Sb\u0012\u0002BA:\u0003k\nAAU3bI*!\u0011QNA8\u0013\u0011\tI(a\u001f\u0002\u0015\u0011\u000bG/Y*pkJ\u001cWM\u0003\u0003\u0002t\u0005U\u0014\u0002BA@\u0003\u0003\u0013qAQ;jY\u0012,'O\u0003\u0003\u0002z\u0005m\u0014AD:pkJ\u001cWMQ;jY\u0012,'\u000f\t\u0015\u0004\u0001\u0005\u001d\u0005\u0003BAE\u0003\u001fk!!a#\u000b\u0007\u00055E$\u0001\u0006b]:|G/\u0019;j_:LA!!%\u0002\f\nAQI^8mm&tw\r")
public final class DataStreamReader
implements Logging {
    private final SparkSession sparkSession;
    private final Read.DataSource.Builder sourceBuilder;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public DataStreamReader format(String source) {
        this.sourceBuilder().setFormat(source);
        return this;
    }

    public DataStreamReader schema(StructType schema) {
        Object object = schema != null ? this.sourceBuilder().setSchema(schema.json()) : BoxedUnit.UNIT;
        return this;
    }

    public DataStreamReader schema(String schemaString) {
        this.sourceBuilder().setSchema(schemaString);
        return this;
    }

    public DataStreamReader option(String key, String value) {
        this.sourceBuilder().putOptions(key, value);
        return this;
    }

    public DataStreamReader option(String key, boolean value) {
        return this.option(key, Boolean.toString(value));
    }

    public DataStreamReader option(String key, long value) {
        return this.option(key, Long.toString(value));
    }

    public DataStreamReader option(String key, double value) {
        return this.option(key, Double.toString(value));
    }

    public DataStreamReader options(Map<String, String> options) {
        this.options((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(options).asJava());
        return this;
    }

    public DataStreamReader options(java.util.Map<String, String> options) {
        this.sourceBuilder().putAllOptions(options);
        return this;
    }

    public Dataset<Row> load() {
        return this.sparkSession.newDataFrame((Function1<Relation.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)relationBuilder -> {
            DataStreamReader.$anonfun$load$1(this, relationBuilder);
            return BoxedUnit.UNIT;
        });
    }

    public Dataset<Row> load(String path) {
        this.sourceBuilder().clearPaths();
        this.sourceBuilder().addPaths(path);
        return this.load();
    }

    public Dataset<Row> json(String path) {
        return this.format("json").load(path);
    }

    public Dataset<Row> csv(String path) {
        return this.format("csv").load(path);
    }

    public Dataset<Row> orc(String path) {
        return this.format("orc").load(path);
    }

    public Dataset<Row> parquet(String path) {
        return this.format("parquet").load(path);
    }

    public Dataset<Row> table(String tableName) {
        Predef$.MODULE$.require(tableName != null, (Function0 & Serializable & scala.Serializable)() -> "The table name can't be null");
        return this.sparkSession.newDataFrame((Function1<Relation.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)builder -> {
            DataStreamReader.$anonfun$table$2(this, tableName, builder);
            return BoxedUnit.UNIT;
        });
    }

    public Dataset<Row> text(String path) {
        return this.format("text").load(path);
    }

    public Dataset<String> textFile(String path) {
        return this.text(path).select("value", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).as(AgnosticEncoders.StringEncoder$.MODULE$);
    }

    private Read.DataSource.Builder sourceBuilder() {
        return this.sourceBuilder;
    }

    public static final /* synthetic */ void $anonfun$load$1(DataStreamReader $this, Relation.Builder relationBuilder) {
        relationBuilder.getReadBuilder().setIsStreaming(true).setDataSource($this.sourceBuilder().build());
    }

    public static final /* synthetic */ void $anonfun$table$2(DataStreamReader $this, String tableName$1, Relation.Builder builder) {
        builder.getReadBuilder().setIsStreaming(true).getNamedTableBuilder().setUnparsedIdentifier(tableName$1).putAllOptions($this.sourceBuilder().getOptionsMap());
    }

    public DataStreamReader(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.$init$((Logging)this);
        this.sourceBuilder = Read.DataSource.newBuilder();
    }
}

