/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.common;

import grpc_shaded.com.google.protobuf.ByteString;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.List;
import org.apache.spark.connect.proto.DataType;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.sql.catalyst.ScalaReflection;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.util.SparkDateTimeUtils$;
import org.apache.spark.sql.catalyst.util.SparkIntervalUtils$;
import org.apache.spark.sql.connect.common.DataTypeProtoConverter$;
import org.apache.spark.sql.connect.common.InvalidPlanInput;
import org.apache.spark.sql.connect.common.InvalidPlanInput$;
import org.apache.spark.sql.connect.common.ProtoDataTypes$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.util.SparkClassUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.WrappedArray;
import scala.math.BigInt;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

public final class LiteralValueProtoConverter$ {
    public static LiteralValueProtoConverter$ MODULE$;

    static {
        new LiteralValueProtoConverter$();
    }

    public Expression.Literal.Builder toLiteralProtoBuilder(Object literal) {
        Expression.Literal.Builder builder;
        block36: {
            Object object;
            Expression.Literal.Builder builder2;
            while (true) {
                builder2 = Expression.Literal.newBuilder();
                object = literal;
                if (object instanceof Boolean) {
                    boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                    builder = builder2.setBoolean(bl);
                    break block36;
                }
                if (object instanceof Byte) {
                    byte by = BoxesRunTime.unboxToByte((Object)object);
                    builder = builder2.setByte(by);
                    break block36;
                }
                if (object instanceof Short) {
                    short s2 = BoxesRunTime.unboxToShort((Object)object);
                    builder = builder2.setShort(s2);
                    break block36;
                }
                if (object instanceof Integer) {
                    int n = BoxesRunTime.unboxToInt((Object)object);
                    builder = builder2.setInteger(n);
                    break block36;
                }
                if (object instanceof Long) {
                    long l = BoxesRunTime.unboxToLong((Object)object);
                    builder = builder2.setLong(l);
                    break block36;
                }
                if (object instanceof Float) {
                    float f = BoxesRunTime.unboxToFloat((Object)object);
                    builder = builder2.setFloat(f);
                    break block36;
                }
                if (object instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object);
                    builder = builder2.setDouble(d);
                    break block36;
                }
                if (object instanceof scala.math.BigDecimal) {
                    scala.math.BigDecimal bigDecimal = (scala.math.BigDecimal)object;
                    builder = builder2.setDecimal(LiteralValueProtoConverter$.decimalBuilder$1(bigDecimal.precision(), bigDecimal.scale(), bigDecimal.toString(), builder2));
                    break block36;
                }
                if (object instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)object;
                    builder = builder2.setDecimal(LiteralValueProtoConverter$.decimalBuilder$1(bigDecimal.precision(), bigDecimal.scale(), bigDecimal.toString(), builder2));
                    break block36;
                }
                if (object instanceof String) {
                    String string = (String)object;
                    builder = builder2.setString(string);
                    break block36;
                }
                if (object instanceof Character) {
                    char c = BoxesRunTime.unboxToChar((Object)object);
                    builder = builder2.setString(Character.toString(c));
                    break block36;
                }
                if (object instanceof char[]) {
                    char[] cArray = (char[])object;
                    builder = builder2.setString(String.valueOf(cArray));
                    break block36;
                }
                if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    builder = builder2.setBinary(ByteString.copyFrom(byArray));
                    break block36;
                }
                if (!(object instanceof WrappedArray)) break;
                WrappedArray wrappedArray = (WrappedArray)object;
                literal = wrappedArray.array();
            }
            if (object instanceof LocalDate) {
                LocalDate localDate = (LocalDate)object;
                builder = builder2.setDate((int)localDate.toEpochDay());
            } else if (object instanceof Decimal) {
                Decimal decimal = (Decimal)object;
                builder = builder2.setDecimal(LiteralValueProtoConverter$.decimalBuilder$1(Math.max(decimal.precision(), decimal.scale()), decimal.scale(), decimal.toString(), builder2));
            } else if (object instanceof Instant) {
                Instant instant = (Instant)object;
                builder = builder2.setTimestamp(SparkDateTimeUtils$.MODULE$.instantToMicros(instant));
            } else if (object instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)object;
                builder = builder2.setTimestamp(SparkDateTimeUtils$.MODULE$.fromJavaTimestamp(timestamp));
            } else if (object instanceof LocalDateTime) {
                LocalDateTime localDateTime = (LocalDateTime)object;
                builder = builder2.setTimestampNtz(SparkDateTimeUtils$.MODULE$.localDateTimeToMicros(localDateTime));
            } else if (object instanceof Date) {
                Date date = (Date)object;
                builder = builder2.setDate(SparkDateTimeUtils$.MODULE$.fromJavaDate(date));
            } else if (object instanceof Duration) {
                Duration duration = (Duration)object;
                builder = builder2.setDayTimeInterval(SparkIntervalUtils$.MODULE$.durationToMicros(duration));
            } else if (object instanceof Period) {
                Period period = (Period)object;
                builder = builder2.setYearMonthInterval(SparkIntervalUtils$.MODULE$.periodToMonths(period));
            } else if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
                Object object2 = object;
                builder = builder2.setArray(this.arrayBuilder$1(object2, builder2));
            } else if (object instanceof CalendarInterval) {
                CalendarInterval calendarInterval = (CalendarInterval)object;
                builder = builder2.setCalendarInterval(LiteralValueProtoConverter$.calendarIntervalBuilder$1(calendarInterval.months, calendarInterval.days, calendarInterval.microseconds, builder2));
            } else if (object == null) {
                builder = builder2.setNull(ProtoDataTypes$.MODULE$.NullType());
            } else {
                throw new UnsupportedOperationException(new StringBuilder(29).append("literal ").append(literal).append(" not supported (yet).").toString());
            }
        }
        return builder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Expression.Literal.Builder toLiteralProtoBuilder(Object literal, org.apache.spark.sql.types.DataType dataType) {
        Tuple2 tuple2;
        Expression.Literal.Builder builder;
        while (true) {
            builder = Expression.Literal.newBuilder();
            tuple2 = new Tuple2(literal, (Object)dataType);
            if (tuple2 == null) break;
            Object v = tuple2._1();
            org.apache.spark.sql.types.DataType dataType2 = (org.apache.spark.sql.types.DataType)tuple2._2();
            if (!(v instanceof WrappedArray)) break;
            WrappedArray wrappedArray = (WrappedArray)v;
            if (!(dataType2 instanceof ArrayType)) break;
            literal = wrappedArray.array();
        }
        if (tuple2 != null) {
            Object v = tuple2._1();
            org.apache.spark.sql.types.DataType dataType3 = (org.apache.spark.sql.types.DataType)tuple2._2();
            if (v instanceof byte[]) {
                byte[] byArray = (byte[])v;
                if (dataType3 instanceof ArrayType) {
                    return this.toLiteralProtoBuilder(byArray);
                }
            }
        }
        if (tuple2 != null) {
            Object v = tuple2._1();
            org.apache.spark.sql.types.DataType dataType4 = (org.apache.spark.sql.types.DataType)tuple2._2();
            if (dataType4 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType4;
                org.apache.spark.sql.types.DataType elementType = arrayType.elementType();
                return builder.setArray(LiteralValueProtoConverter$.arrayBuilder$2(v, elementType, builder));
            }
        }
        if (tuple2 != null) {
            Object v = tuple2._1();
            org.apache.spark.sql.types.DataType dataType5 = (org.apache.spark.sql.types.DataType)tuple2._2();
            if (dataType5 instanceof MapType) {
                MapType mapType = (MapType)dataType5;
                org.apache.spark.sql.types.DataType keyType = mapType.keyType();
                org.apache.spark.sql.types.DataType valueType = mapType.valueType();
                return builder.setMap(LiteralValueProtoConverter$.mapBuilder$1(v, keyType, valueType, builder));
            }
        }
        if (tuple2 != null) {
            Object v = tuple2._1();
            org.apache.spark.sql.types.DataType structType = (org.apache.spark.sql.types.DataType)tuple2._2();
            if (structType instanceof StructType) {
                StructType structType2 = (StructType)structType;
                return builder.setStruct(this.structBuilder$1(v, structType2, builder));
            }
        }
        if (tuple2 == null) return this.toLiteralProtoBuilder(literal);
        Object v = tuple2._1();
        if (!(v instanceof Option)) return this.toLiteralProtoBuilder(literal);
        Option option = (Option)v;
        if (tuple2._2() == null) return this.toLiteralProtoBuilder(literal);
        return option.isDefined() ? this.toLiteralProtoBuilder(option.get()) : builder.setNull(DataTypeProtoConverter$.MODULE$.toConnectProtoType(dataType));
    }

    public <T> Expression.Literal.Builder create(T v, TypeTags.TypeTag<T> evidence$1) {
        return (Expression.Literal.Builder)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            org.apache.spark.sql.types.DataType dataType;
            ScalaReflection.Schema schema = ScalaReflection$.MODULE$.schemaFor(evidence$1);
            if (schema == null) {
                throw new MatchError((Object)schema);
            }
            org.apache.spark.sql.types.DataType dataType2 = dataType = schema.dataType();
            org.apache.spark.sql.types.DataType dataType3 = dataType2;
            return MODULE$.toLiteralProtoBuilder(v, dataType3);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.toLiteralProtoBuilder(v));
    }

    public Expression.Literal toLiteralProto(Object literal) {
        return this.toLiteralProtoBuilder(literal).build();
    }

    public Expression.Literal toLiteralProto(Object literal, org.apache.spark.sql.types.DataType dataType) {
        return this.toLiteralProtoBuilder(literal, dataType).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private org.apache.spark.sql.types.DataType toDataType(Class<?> clz) {
        Class<?> clazz = clz;
        Class<Short> clazz2 = Short.TYPE;
        Class<?> clazz3 = clazz;
        if (clazz2 == null) {
            if (clazz3 == null) return ShortType$.MODULE$;
        } else if (clazz2.equals(clazz3)) {
            return ShortType$.MODULE$;
        }
        Class<Integer> clazz4 = Integer.TYPE;
        Class<?> clazz5 = clazz;
        if (clazz4 == null) {
            if (clazz5 == null) return IntegerType$.MODULE$;
        } else if (clazz4.equals(clazz5)) {
            return IntegerType$.MODULE$;
        }
        Class<Long> clazz6 = Long.TYPE;
        Class<?> clazz7 = clazz;
        if (clazz6 == null) {
            if (clazz7 == null) return LongType$.MODULE$;
        } else if (clazz6.equals(clazz7)) {
            return LongType$.MODULE$;
        }
        Class<Double> clazz8 = Double.TYPE;
        Class<?> clazz9 = clazz;
        if (clazz8 == null) {
            if (clazz9 == null) return DoubleType$.MODULE$;
        } else if (clazz8.equals(clazz9)) {
            return DoubleType$.MODULE$;
        }
        Class<Byte> clazz10 = Byte.TYPE;
        Class<?> clazz11 = clazz;
        if (clazz10 == null) {
            if (clazz11 == null) return ByteType$.MODULE$;
        } else if (clazz10.equals(clazz11)) {
            return ByteType$.MODULE$;
        }
        Class<Float> clazz12 = Float.TYPE;
        Class<?> clazz13 = clazz;
        if (clazz12 == null) {
            if (clazz13 == null) return FloatType$.MODULE$;
        } else if (clazz12.equals(clazz13)) {
            return FloatType$.MODULE$;
        }
        Class<Boolean> clazz14 = Boolean.TYPE;
        Class<?> clazz15 = clazz;
        if (clazz14 == null) {
            if (clazz15 == null) return BooleanType$.MODULE$;
        } else if (clazz14.equals(clazz15)) {
            return BooleanType$.MODULE$;
        }
        Class<Character> clazz16 = Character.TYPE;
        Class<?> clazz17 = clazz;
        if (clazz16 == null) {
            if (clazz17 == null) return StringType$.MODULE$;
        } else if (clazz16.equals(clazz17)) {
            return StringType$.MODULE$;
        }
        Class<?> clazz18 = clz;
        Class<LocalDate> clazz19 = LocalDate.class;
        if (clazz18 == null) {
            if (clazz19 == null) return DateType$.MODULE$;
        } else if (clazz18.equals(clazz19)) return DateType$.MODULE$;
        Class<?> clazz20 = clz;
        Class<Date> clazz21 = Date.class;
        if (clazz20 == null) {
            if (clazz21 == null) return DateType$.MODULE$;
        } else if (clazz20.equals(clazz21)) {
            return DateType$.MODULE$;
        }
        Class<?> clazz22 = clz;
        Class<Instant> clazz23 = Instant.class;
        if (clazz22 == null) {
            if (clazz23 == null) return TimestampType$.MODULE$;
        } else if (clazz22.equals(clazz23)) return TimestampType$.MODULE$;
        Class<?> clazz24 = clz;
        Class<Timestamp> clazz25 = Timestamp.class;
        if (clazz24 == null) {
            if (clazz25 == null) return TimestampType$.MODULE$;
        } else if (clazz24.equals(clazz25)) {
            return TimestampType$.MODULE$;
        }
        Class<?> clazz26 = clz;
        Class<LocalDateTime> clazz27 = LocalDateTime.class;
        if (clazz26 == null) {
            if (clazz27 == null) return TimestampNTZType$.MODULE$;
        } else if (clazz26.equals(clazz27)) {
            return TimestampNTZType$.MODULE$;
        }
        Class<?> clazz28 = clz;
        Class<Duration> clazz29 = Duration.class;
        if (clazz28 == null) {
            if (clazz29 == null) return DayTimeIntervalType$.MODULE$.DEFAULT();
        } else if (clazz28.equals(clazz29)) {
            return DayTimeIntervalType$.MODULE$.DEFAULT();
        }
        Class<?> clazz30 = clz;
        Class<Period> clazz31 = Period.class;
        if (clazz30 == null) {
            if (clazz31 == null) return YearMonthIntervalType$.MODULE$.DEFAULT();
        } else if (clazz30.equals(clazz31)) {
            return YearMonthIntervalType$.MODULE$.DEFAULT();
        }
        Class<?> clazz32 = clz;
        Class<BigDecimal> clazz33 = BigDecimal.class;
        if (clazz32 == null) {
            if (clazz33 == null) return DecimalType$.MODULE$.SYSTEM_DEFAULT();
        } else if (clazz32.equals(clazz33)) {
            return DecimalType$.MODULE$.SYSTEM_DEFAULT();
        }
        Class<?> clazz34 = clz;
        Class<byte[]> clazz35 = byte[].class;
        if (clazz34 == null) {
            if (clazz35 == null) return BinaryType$.MODULE$;
        } else if (clazz34.equals(clazz35)) {
            return BinaryType$.MODULE$;
        }
        Class<?> clazz36 = clz;
        Class<char[]> clazz37 = char[].class;
        if (clazz36 == null) {
            if (clazz37 == null) return StringType$.MODULE$;
        } else if (clazz36.equals(clazz37)) {
            return StringType$.MODULE$;
        }
        Class<?> clazz38 = clz;
        Class<Short> clazz39 = Short.class;
        if (clazz38 == null) {
            if (clazz39 == null) return ShortType$.MODULE$;
        } else if (clazz38.equals(clazz39)) {
            return ShortType$.MODULE$;
        }
        Class<?> clazz40 = clz;
        Class<Integer> clazz41 = Integer.class;
        if (clazz40 == null) {
            if (clazz41 == null) return IntegerType$.MODULE$;
        } else if (clazz40.equals(clazz41)) {
            return IntegerType$.MODULE$;
        }
        Class<?> clazz42 = clz;
        Class<Long> clazz43 = Long.class;
        if (clazz42 == null) {
            if (clazz43 == null) return LongType$.MODULE$;
        } else if (clazz42.equals(clazz43)) {
            return LongType$.MODULE$;
        }
        Class<?> clazz44 = clz;
        Class<Double> clazz45 = Double.class;
        if (clazz44 == null) {
            if (clazz45 == null) return DoubleType$.MODULE$;
        } else if (clazz44.equals(clazz45)) {
            return DoubleType$.MODULE$;
        }
        Class<?> clazz46 = clz;
        Class<Byte> clazz47 = Byte.class;
        if (clazz46 == null) {
            if (clazz47 == null) return ByteType$.MODULE$;
        } else if (clazz46.equals(clazz47)) {
            return ByteType$.MODULE$;
        }
        Class<?> clazz48 = clz;
        Class<Float> clazz49 = Float.class;
        if (clazz48 == null) {
            if (clazz49 == null) return FloatType$.MODULE$;
        } else if (clazz48.equals(clazz49)) {
            return FloatType$.MODULE$;
        }
        Class<?> clazz50 = clz;
        Class<Boolean> clazz51 = Boolean.class;
        if (clazz50 == null) {
            if (clazz51 == null) return BooleanType$.MODULE$;
        } else if (clazz50.equals(clazz51)) {
            return BooleanType$.MODULE$;
        }
        Class<?> clazz52 = clz;
        Class<String> clazz53 = String.class;
        if (clazz52 == null) {
            if (clazz53 == null) return StringType$.MODULE$;
        } else if (clazz52.equals(clazz53)) {
            return StringType$.MODULE$;
        }
        Class<?> clazz54 = clz;
        Class<BigInt> clazz55 = BigInt.class;
        if (clazz54 == null) {
            if (clazz55 == null) return DecimalType$.MODULE$.SYSTEM_DEFAULT();
        } else if (clazz54.equals(clazz55)) return DecimalType$.MODULE$.SYSTEM_DEFAULT();
        Class<?> clazz56 = clz;
        Class<scala.math.BigDecimal> clazz57 = scala.math.BigDecimal.class;
        if (clazz56 == null) {
            if (clazz57 == null) return DecimalType$.MODULE$.SYSTEM_DEFAULT();
        } else if (clazz56.equals(clazz57)) {
            return DecimalType$.MODULE$.SYSTEM_DEFAULT();
        }
        Class<?> clazz58 = clz;
        Class<CalendarInterval> clazz59 = CalendarInterval.class;
        if (clazz58 == null) {
            if (clazz59 == null) return CalendarIntervalType$.MODULE$;
        } else if (clazz58.equals(clazz59)) {
            return CalendarIntervalType$.MODULE$;
        }
        if (!clz.isArray()) throw new UnsupportedOperationException(new StringBuilder(38).append("Unsupported component type ").append(clz).append(" in arrays.").toString());
        return ArrayType$.MODULE$.apply(this.toDataType(clz.getComponentType()));
    }

    public Object toCatalystValue(Expression.Literal literal) {
        Object object;
        Expression.Literal.LiteralTypeCase literalTypeCase = literal.getLiteralTypeCase();
        if (Expression.Literal.LiteralTypeCase.NULL.equals(literalTypeCase)) {
            object = null;
        } else if (Expression.Literal.LiteralTypeCase.BINARY.equals(literalTypeCase)) {
            object = literal.getBinary().toByteArray();
        } else if (Expression.Literal.LiteralTypeCase.BOOLEAN.equals(literalTypeCase)) {
            object = BoxesRunTime.boxToBoolean((boolean)literal.getBoolean());
        } else if (Expression.Literal.LiteralTypeCase.BYTE.equals(literalTypeCase)) {
            object = BoxesRunTime.boxToByte((byte)((byte)literal.getByte()));
        } else if (Expression.Literal.LiteralTypeCase.SHORT.equals(literalTypeCase)) {
            object = BoxesRunTime.boxToShort((short)((short)literal.getShort()));
        } else if (Expression.Literal.LiteralTypeCase.INTEGER.equals(literalTypeCase)) {
            object = BoxesRunTime.boxToInteger((int)literal.getInteger());
        } else if (Expression.Literal.LiteralTypeCase.LONG.equals(literalTypeCase)) {
            object = BoxesRunTime.boxToLong((long)literal.getLong());
        } else if (Expression.Literal.LiteralTypeCase.FLOAT.equals(literalTypeCase)) {
            object = BoxesRunTime.boxToFloat((float)literal.getFloat());
        } else if (Expression.Literal.LiteralTypeCase.DOUBLE.equals(literalTypeCase)) {
            object = BoxesRunTime.boxToDouble((double)literal.getDouble());
        } else if (Expression.Literal.LiteralTypeCase.DECIMAL.equals(literalTypeCase)) {
            object = Decimal$.MODULE$.apply(literal.getDecimal().getValue());
        } else if (Expression.Literal.LiteralTypeCase.STRING.equals(literalTypeCase)) {
            object = literal.getString();
        } else if (Expression.Literal.LiteralTypeCase.DATE.equals(literalTypeCase)) {
            object = SparkDateTimeUtils$.MODULE$.toJavaDate(literal.getDate());
        } else if (Expression.Literal.LiteralTypeCase.TIMESTAMP.equals(literalTypeCase)) {
            object = SparkDateTimeUtils$.MODULE$.toJavaTimestamp(literal.getTimestamp());
        } else if (Expression.Literal.LiteralTypeCase.TIMESTAMP_NTZ.equals(literalTypeCase)) {
            object = SparkDateTimeUtils$.MODULE$.microsToLocalDateTime(literal.getTimestampNtz());
        } else if (Expression.Literal.LiteralTypeCase.CALENDAR_INTERVAL.equals(literalTypeCase)) {
            object = new CalendarInterval(literal.getCalendarInterval().getMonths(), literal.getCalendarInterval().getDays(), literal.getCalendarInterval().getMicroseconds());
        } else if (Expression.Literal.LiteralTypeCase.YEAR_MONTH_INTERVAL.equals(literalTypeCase)) {
            object = SparkIntervalUtils$.MODULE$.monthsToPeriod(literal.getYearMonthInterval());
        } else if (Expression.Literal.LiteralTypeCase.DAY_TIME_INTERVAL.equals(literalTypeCase)) {
            object = SparkIntervalUtils$.MODULE$.microsToDuration(literal.getDayTimeInterval());
        } else if (Expression.Literal.LiteralTypeCase.ARRAY.equals(literalTypeCase)) {
            object = this.toCatalystArray(literal.getArray());
        } else {
            throw new UnsupportedOperationException(new StringBuilder(29).append("Unsupported Literal Type: ").append(literalTypeCase.getNumber()).append(" (").append(literalTypeCase.name()).append(")").toString());
        }
        return object;
    }

    private Function1<Expression.Literal, Object> getConverter(DataType dataType) {
        Function1 & Serializable & scala.Serializable intersect;
        if (dataType.hasShort()) {
            intersect = (Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToShort((short)LiteralValueProtoConverter$.$anonfun$getConverter$1(v));
        } else if (dataType.hasInteger()) {
            intersect = (Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToInteger((int)v.getInteger());
        } else if (dataType.hasLong()) {
            intersect = (Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToLong((long)v.getLong());
        } else if (dataType.hasDouble()) {
            intersect = (Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToDouble((double)v.getDouble());
        } else if (dataType.hasByte()) {
            intersect = (Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToByte((byte)LiteralValueProtoConverter$.$anonfun$getConverter$5(v));
        } else if (dataType.hasFloat()) {
            intersect = (Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToFloat((float)v.getFloat());
        } else if (dataType.hasBoolean()) {
            intersect = (Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)v.getBoolean());
        } else if (dataType.hasString()) {
            intersect = (Function1 & Serializable & scala.Serializable)v -> v.getString();
        } else if (dataType.hasBinary()) {
            intersect = (Function1 & Serializable & scala.Serializable)v -> v.getBinary().toByteArray();
        } else if (dataType.hasDate()) {
            intersect = (Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToInteger((int)v.getDate());
        } else if (dataType.hasTimestamp()) {
            intersect = (Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToLong((long)v.getTimestamp());
        } else if (dataType.hasTimestampNtz()) {
            intersect = (Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToLong((long)v.getTimestampNtz());
        } else if (dataType.hasDayTimeInterval()) {
            intersect = (Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToLong((long)v.getDayTimeInterval());
        } else if (dataType.hasYearMonthInterval()) {
            intersect = (Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToInteger((int)v.getYearMonthInterval());
        } else if (dataType.hasDecimal()) {
            intersect = (Function1 & Serializable & scala.Serializable)v -> Decimal$.MODULE$.apply(v.getDecimal().getValue());
        } else if (dataType.hasCalendarInterval()) {
            intersect = (Function1 & Serializable & scala.Serializable)v -> {
                Expression.Literal.CalendarInterval interval = v.getCalendarInterval();
                return new CalendarInterval(interval.getMonths(), interval.getDays(), interval.getMicroseconds());
            };
        } else if (dataType.hasArray()) {
            intersect = (Function1 & Serializable & scala.Serializable)v -> MODULE$.toCatalystArray(v.getArray());
        } else if (dataType.hasMap()) {
            intersect = (Function1 & Serializable & scala.Serializable)v -> MODULE$.toCatalystMap(v.getMap());
        } else if (dataType.hasStruct()) {
            intersect = (Function1 & Serializable & scala.Serializable)v -> MODULE$.toCatalystStruct(v.getStruct());
        } else {
            throw new InvalidPlanInput(new StringBuilder(27).append("Unsupported Literal Type: ").append(dataType).append(")").toString(), InvalidPlanInput$.MODULE$.apply$default$2());
        }
        return intersect;
    }

    public Object toCatalystArray(Expression.Literal.Array array) {
        return LiteralValueProtoConverter$.makeArrayData$1(this.getConverter(array.getElementType()), ClassTag$.MODULE$.Any(), array);
    }

    public scala.collection.mutable.Map<?, ?> toCatalystMap(Expression.Literal.Map map) {
        return LiteralValueProtoConverter$.makeMapData$1(this.getConverter(map.getKeyType()), this.getConverter(map.getValueType()), ClassTag$.MODULE$.Any(), ClassTag$.MODULE$.Any(), map);
    }

    public Object toCatalystStruct(Expression.Literal.Struct struct) {
        Buffer elements = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(struct.getElementsList()).asScala();
        Buffer dataTypes = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(struct.getStructType().getStruct().getFieldsList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getDataType(), Buffer$.MODULE$.canBuildFrom());
        Seq structData = ((Seq)((TraversableLike)elements.zip((GenIterable)dataTypes, Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Expression.Literal element = (Expression.Literal)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            Object object = MODULE$.getConverter(dataType).apply((Object)element);
            return object;
        }, Buffer$.MODULE$.canBuildFrom())).toSeq();
        return LiteralValueProtoConverter$.toTuple$1(structData);
    }

    private static final Expression.Literal.Decimal.Builder decimalBuilder$1(int precision, int scale, String value, Expression.Literal.Builder builder$1) {
        return builder$1.getDecimalBuilder().setPrecision(precision).setScale(scale).setValue(value);
    }

    private static final Expression.Literal.CalendarInterval.Builder calendarIntervalBuilder$1(int months, int days, long microseconds, Expression.Literal.Builder builder$1) {
        return builder$1.getCalendarIntervalBuilder().setMonths(months).setDays(days).setMicroseconds(microseconds);
    }

    /*
     * WARNING - void declaration
     */
    private final Expression.Literal.Array.Builder arrayBuilder$1(Object array, Expression.Literal.Builder builder$1) {
        void var3_3;
        Expression.Literal.Array.Builder ab = builder$1.getArrayBuilder().setElementType(DataTypeProtoConverter$.MODULE$.toConnectProtoType(this.toDataType(array.getClass().getComponentType())));
        Predef$.MODULE$.genericArrayOps(array).foreach((Function1 & Serializable & scala.Serializable)x -> ab.addElements(MODULE$.toLiteralProto(x)));
        return var3_3;
    }

    private static final Expression.Literal.Array.Builder arrayBuilder$2(Object scalaValue, org.apache.spark.sql.types.DataType elementType, Expression.Literal.Builder builder$2) {
        Expression.Literal.Array.Builder ab = builder$2.getArrayBuilder().setElementType(DataTypeProtoConverter$.MODULE$.toConnectProtoType(elementType));
        Object object = scalaValue;
        if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object object2 = object;
            Predef$.MODULE$.genericArrayOps(object2).foreach((Function1 & Serializable & scala.Serializable)item -> ab.addElements(MODULE$.toLiteralProto(item, elementType)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Seq) {
            Seq seq = (Seq)object;
            seq.foreach((Function1 & Serializable & scala.Serializable)item -> ab.addElements(MODULE$.toLiteralProto(item, elementType)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new IllegalArgumentException(new StringBuilder(29).append("literal ").append(object).append(" not supported (yet).").toString());
        }
        return ab;
    }

    private static final Expression.Literal.Map.Builder mapBuilder$1(Object scalaValue, org.apache.spark.sql.types.DataType keyType, org.apache.spark.sql.types.DataType valueType, Expression.Literal.Builder builder$2) {
        Expression.Literal.Map.Builder mb = builder$2.getMapBuilder().setKeyType(DataTypeProtoConverter$.MODULE$.toConnectProtoType(keyType)).setValueType(DataTypeProtoConverter$.MODULE$.toConnectProtoType(valueType));
        Object object = scalaValue;
        if (!(object instanceof Map)) {
            throw new IllegalArgumentException(new StringBuilder(29).append("literal ").append(object).append(" not supported (yet).").toString());
        }
        Map map = (Map)object;
        map.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object k = tuple2._1();
            Object v = tuple2._2();
            mb.addKeys(MODULE$.toLiteralProto(k, keyType));
            Expression.Literal.Map.Builder builder = mb.addValues(MODULE$.toLiteralProto(v, valueType));
            return builder;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return mb;
    }

    private final Expression.Literal.Struct.Builder structBuilder$1(Object scalaValue, StructType structType, Expression.Literal.Builder builder$2) {
        Expression.Literal.Struct.Builder sb = builder$2.getStructBuilder().setStructType(DataTypeProtoConverter$.MODULE$.toConnectProtoType((org.apache.spark.sql.types.DataType)structType));
        org.apache.spark.sql.types.DataType[] dataTypes = (org.apache.spark.sql.types.DataType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataType(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(org.apache.spark.sql.types.DataType.class)));
        Object object = scalaValue;
        if (object instanceof Product) {
            Product product = (Product)object;
            Iterator iter = product.productIterator();
            for (int idx = 0; idx < structType.size(); ++idx) {
                sb.addElements(this.toLiteralProto(iter.next(), dataTypes[idx]));
            }
        } else {
            throw new IllegalArgumentException(new StringBuilder(29).append("literal ").append(object).append(" not supported (yet).").toString());
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return sb;
    }

    public static final /* synthetic */ short $anonfun$getConverter$1(Expression.Literal v) {
        return (short)v.getShort();
    }

    public static final /* synthetic */ byte $anonfun$getConverter$5(Expression.Literal v) {
        return (byte)v.getByte();
    }

    private static final Object makeArrayData$1(Function1 converter, ClassTag tag, Expression.Literal.Array array$1) {
        ArrayBuilder builder = ArrayBuilder$.MODULE$.make(tag);
        List<Expression.Literal> elementList = array$1.getElementsList();
        builder.sizeHint(elementList.size());
        java.util.Iterator<Expression.Literal> iter = elementList.iterator();
        while (iter.hasNext()) {
            builder.$plus$eq(converter.apply((Object)iter.next()));
        }
        return builder.result();
    }

    private static final scala.collection.mutable.Map makeMapData$1(Function1 keyConverter, Function1 valueConverter, ClassTag tagK, ClassTag tagV, Expression.Literal.Map map$1) {
        HashMap builder = HashMap$.MODULE$.empty();
        Buffer keys = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(map$1.getKeysList()).asScala();
        Buffer values = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(map$1.getValuesList()).asScala();
        builder.sizeHint(keys.size());
        ((IterableLike)keys.zip((GenIterable)values, Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Expression.Literal key = (Expression.Literal)tuple2._1();
            Expression.Literal value = (Expression.Literal)tuple2._2();
            HashMap hashMap = builder.$plus$eq(new Tuple2(keyConverter.apply((Object)key), valueConverter.apply((Object)value)));
            return hashMap;
        });
        return builder;
    }

    private static final Product toTuple$1(Seq data) {
        Product product;
        try {
            Class tupleClass = SparkClassUtils$.MODULE$.classForName(new StringBuilder(11).append("scala.Tuple").append(data.length()).toString(), SparkClassUtils$.MODULE$.classForName$default$2(), SparkClassUtils$.MODULE$.classForName$default$3());
            product = (Product)((Constructor)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tupleClass.getConstructors())).head()).newInstance((Object[])data.toArray(ClassTag$.MODULE$.Object()));
        }
        catch (Exception exception) {
            throw new InvalidPlanInput(new StringBuilder(22).append("Unsupported Literal: ").append(data.mkString("Array(", ", ", ")")).append(")").toString(), InvalidPlanInput$.MODULE$.apply$default$2());
        }
        return product;
    }

    private LiteralValueProtoConverter$() {
        MODULE$ = this;
    }
}

