/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client.arrow;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.spark.sql.catalyst.util.SparkDateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.connect.client.arrow.TypedArrowVectorReader;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001a4Q!\u0004\b\u0001\u001dqA\u0011\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\t\u0016\t\u0011-\u0002!\u0011!Q\u0001\n1BQ!\u000f\u0001\u0005\u0002iBqA\u0010\u0001C\u0002\u0013%q\b\u0003\u0004I\u0001\u0001\u0006I\u0001\u0011\u0005\t\u0013\u0002A)\u0019!C\u0005\u0015\")1\u000b\u0001C\u0005)\")a\f\u0001C\u0005?\")\u0011\r\u0001C!E\")\u0011\u000e\u0001C!U\")q\u000e\u0001C!a\")Q\u000f\u0001C!m\nQB+[7f'R\fW\u000e]'jGJ|g+Z2u_J\u0014V-\u00193fe*\u0011q\u0002E\u0001\u0006CJ\u0014xn\u001e\u0006\u0003#I\taa\u00197jK:$(BA\n\u0015\u0003\u001d\u0019wN\u001c8fGRT!!\u0006\f\u0002\u0007M\fHN\u0003\u0002\u00181\u0005)1\u000f]1sW*\u0011\u0011DG\u0001\u0007CB\f7\r[3\u000b\u0003m\t1a\u001c:h'\t\u0001Q\u0004E\u0002\u001f?\u0005j\u0011AD\u0005\u0003A9\u0011a\u0003V=qK\u0012\f%O]8x-\u0016\u001cGo\u001c:SK\u0006$WM\u001d\t\u0003E\u0019j\u0011a\t\u0006\u0003I\u0015\naA^3di>\u0014(BA\b\u0019\u0013\t93E\u0001\u000bUS6,7\u000b^1na6K7M]8WK\u000e$xN]\u0001\u0002m\u000e\u0001\u0011B\u0001\u0013 \u0003)!\u0018.\\3[_:,\u0017\n\u001a\t\u0003[Yr!A\f\u001b\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005EJ\u0013A\u0002\u001fs_>$hHC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$'\u0001\u0004Qe\u0016$WMZ\u0005\u0003oa\u0012aa\u0015;sS:<'BA\u001b3\u0003\u0019a\u0014N\\5u}Q\u00191\bP\u001f\u0011\u0005y\u0001\u0001\"\u0002\u0015\u0004\u0001\u0004\t\u0003\"B\u0016\u0004\u0001\u0004a\u0013\u0001\u0002>p]\u0016,\u0012\u0001\u0011\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000bA\u0001^5nK*\tQ)\u0001\u0003kCZ\f\u0017BA$C\u0005\u0019QvN\\3JI\u0006)!p\u001c8fA\u0005Iam\u001c:nCR$XM]\u000b\u0002\u0017B\u0011A*U\u0007\u0002\u001b*\u0011ajT\u0001\u0005kRLGN\u0003\u0002Q)\u0005A1-\u0019;bYf\u001cH/\u0003\u0002S\u001b\n\u0011B+[7fgR\fW\u000e\u001d$pe6\fG\u000f^3s\u0003!!(0T5de>\u001cHCA+Z!\t1v+D\u00013\u0013\tA&G\u0001\u0003M_:<\u0007\"\u0002.\b\u0001\u0004Y\u0016!A5\u0011\u0005Yc\u0016BA/3\u0005\rIe\u000e^\u0001\nkR\u001cW*[2s_N$\"!\u00161\t\u000biC\u0001\u0019A.\u0002\u0019\u001d,G\u000fV5nKN$\u0018-\u001c9\u0015\u0005\rD\u0007C\u00013g\u001b\u0005)'BA\u000bE\u0013\t9WMA\u0005US6,7\u000f^1na\")!,\u0003a\u00017\u0006Qq-\u001a;J]N$\u0018M\u001c;\u0015\u0005-t\u0007CA!m\u0013\ti'IA\u0004J]N$\u0018M\u001c;\t\u000biS\u0001\u0019A.\u0002!\u001d,G\u000fT8dC2$\u0015\r^3US6,GCA9u!\t\t%/\u0003\u0002t\u0005\niAj\\2bY\u0012\u000bG/\u001a+j[\u0016DQAW\u0006A\u0002m\u000b\u0011bZ3u'R\u0014\u0018N\\4\u0015\u00051:\b\"\u0002.\r\u0001\u0004Y\u0006")
public class TimeStampMicroVectorReader
extends TypedArrowVectorReader<TimeStampMicroVector> {
    private TimestampFormatter formatter;
    private final ZoneId zone;
    private volatile boolean bitmap$0;

    private ZoneId zone() {
        return this.zone;
    }

    private TimestampFormatter formatter$lzycompute() {
        TimeStampMicroVectorReader timeStampMicroVectorReader = this;
        synchronized (timeStampMicroVectorReader) {
            if (!this.bitmap$0) {
                this.formatter = TimestampFormatter$.MODULE$.getFractionFormatter((ZoneId)ZoneOffset.UTC);
                this.bitmap$0 = true;
            }
        }
        return this.formatter;
    }

    private TimestampFormatter formatter() {
        return !this.bitmap$0 ? this.formatter$lzycompute() : this.formatter;
    }

    private long tzMicros(int i) {
        return SparkDateTimeUtils$.MODULE$.convertTz(this.utcMicros(i), (ZoneId)ZoneOffset.UTC, this.zone());
    }

    private long utcMicros(int i) {
        return ((TimeStampVector)this.vector()).get(i);
    }

    @Override
    public Timestamp getTimestamp(int i) {
        return SparkDateTimeUtils$.MODULE$.toJavaTimestamp(this.tzMicros(i));
    }

    @Override
    public Instant getInstant(int i) {
        return SparkDateTimeUtils$.MODULE$.microsToInstant(this.tzMicros(i));
    }

    @Override
    public LocalDateTime getLocalDateTime(int i) {
        return SparkDateTimeUtils$.MODULE$.microsToLocalDateTime(this.utcMicros(i));
    }

    @Override
    public String getString(int i) {
        return this.formatter().format(this.utcMicros(i));
    }

    public TimeStampMicroVectorReader(TimeStampMicroVector v, String timeZoneId) {
        super(v);
        this.zone = SparkDateTimeUtils$.MODULE$.getZoneId(timeZoneId);
    }
}

