/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client.arrow;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.spark.sql.catalyst.util.SparkDateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.connect.client.arrow.TypedArrowVectorReader;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U4Q\u0001D\u0007\u0001\u001bmA\u0011b\n\u0001\u0003\u0002\u0003\u0006I\u0001I\u0015\t\u000b)\u0002A\u0011A\u0016\t\u000f9\u0002!\u0019!C\u0005_!1\u0001\b\u0001Q\u0001\nAB\u0001\"\u000f\u0001\t\u0006\u0004%IA\u000f\u0005\u0006\u0007\u0002!I\u0001\u0012\u0005\u0006!\u0002!\t%\u0015\u0005\u0006'\u0002!\t\u0005\u0016\u0005\u00067\u0002!\t\u0005\u0018\u0005\u0006C\u0002!\tE\u0019\u0005\u0006O\u0002!\t\u0005\u001b\u0002\u001d)&lWm\u0015;b[Bl\u0015n\u0019:p)j3Vm\u0019;peJ+\u0017\rZ3s\u0015\tqq\"A\u0003beJ|wO\u0003\u0002\u0011#\u000511\r\\5f]RT!AE\n\u0002\u000f\r|gN\\3di*\u0011A#F\u0001\u0004gFd'B\u0001\f\u0018\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0012$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00025\u0005\u0019qN]4\u0014\u0005\u0001a\u0002cA\u000f\u001fA5\tQ\"\u0003\u0002 \u001b\t1B+\u001f9fI\u0006\u0013(o\\<WK\u000e$xN\u001d*fC\u0012,'\u000f\u0005\u0002\"K5\t!E\u0003\u0002$I\u00051a/Z2u_JT!AD\f\n\u0005\u0019\u0012#A\u0006+j[\u0016\u001cF/Y7q\u001b&\u001c'o\u001c+[-\u0016\u001cGo\u001c:\u0002\u0003Y\u001c\u0001!\u0003\u0002$=\u00051A(\u001b8jiz\"\"\u0001L\u0017\u0011\u0005u\u0001\u0001\"B\u0014\u0003\u0001\u0004\u0001\u0013\u0001\u0002>p]\u0016,\u0012\u0001\r\t\u0003cYj\u0011A\r\u0006\u0003gQ\nA\u0001^5nK*\tQ'\u0001\u0003kCZ\f\u0017BA\u001c3\u0005\u0019QvN\\3JI\u0006)!p\u001c8fA\u0005Iam\u001c:nCR$XM]\u000b\u0002wA\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\u0005kRLGN\u0003\u0002A'\u0005A1-\u0019;bYf\u001cH/\u0003\u0002C{\t\u0011B+[7fgR\fW\u000e\u001d$pe6\fG\u000f^3s\u0003%)HoY'jGJ|7\u000f\u0006\u0002F\u0017B\u0011a)S\u0007\u0002\u000f*\t\u0001*A\u0003tG\u0006d\u0017-\u0003\u0002K\u000f\n!Aj\u001c8h\u0011\u0015ae\u00011\u0001N\u0003\u0005I\u0007C\u0001$O\u0013\tyuIA\u0002J]R\fqaZ3u\u0019>tw\r\u0006\u0002F%\")Aj\u0002a\u0001\u001b\u0006aq-\u001a;US6,7\u000f^1naR\u0011QK\u0017\t\u0003-bk\u0011a\u0016\u0006\u0003)QJ!!W,\u0003\u0013QKW.Z:uC6\u0004\b\"\u0002'\t\u0001\u0004i\u0015AC4fi&s7\u000f^1oiR\u0011Q\f\u0019\t\u0003cyK!a\u0018\u001a\u0003\u000f%s7\u000f^1oi\")A*\u0003a\u0001\u001b\u0006\u0001r-\u001a;M_\u000e\fG\u000eR1uKRKW.\u001a\u000b\u0003G\u001a\u0004\"!\r3\n\u0005\u0015\u0014$!\u0004'pG\u0006dG)\u0019;f)&lW\rC\u0003M\u0015\u0001\u0007Q*A\u0005hKR\u001cFO]5oOR\u0011\u0011\u000e\u001e\t\u0003UFt!a[8\u0011\u00051<U\"A7\u000b\u00059D\u0013A\u0002\u001fs_>$h(\u0003\u0002q\u000f\u00061\u0001K]3eK\u001aL!A]:\u0003\rM#(/\u001b8h\u0015\t\u0001x\tC\u0003M\u0017\u0001\u0007Q\n")
public class TimeStampMicroTZVectorReader
extends TypedArrowVectorReader<TimeStampMicroTZVector> {
    private TimestampFormatter formatter;
    private final ZoneId zone = SparkDateTimeUtils$.MODULE$.getZoneId(((TimeStampMicroTZVector)super.vector()).getTimeZone());
    private volatile boolean bitmap$0;

    private ZoneId zone() {
        return this.zone;
    }

    private TimestampFormatter formatter$lzycompute() {
        TimeStampMicroTZVectorReader timeStampMicroTZVectorReader = this;
        synchronized (timeStampMicroTZVectorReader) {
            if (!this.bitmap$0) {
                this.formatter = TimestampFormatter$.MODULE$.getFractionFormatter(this.zone());
                this.bitmap$0 = true;
            }
        }
        return this.formatter;
    }

    private TimestampFormatter formatter() {
        return !this.bitmap$0 ? this.formatter$lzycompute() : this.formatter;
    }

    private long utcMicros(int i) {
        return SparkDateTimeUtils$.MODULE$.convertTz(((TimeStampVector)this.vector()).get(i), this.zone(), (ZoneId)ZoneOffset.UTC);
    }

    @Override
    public long getLong(int i) {
        return Math.floorDiv(((TimeStampVector)this.vector()).get(i), 1000000L);
    }

    @Override
    public Timestamp getTimestamp(int i) {
        return SparkDateTimeUtils$.MODULE$.toJavaTimestamp(((TimeStampVector)this.vector()).get(i));
    }

    @Override
    public Instant getInstant(int i) {
        return SparkDateTimeUtils$.MODULE$.microsToInstant(((TimeStampVector)this.vector()).get(i));
    }

    @Override
    public LocalDateTime getLocalDateTime(int i) {
        return SparkDateTimeUtils$.MODULE$.microsToLocalDateTime(this.utcMicros(i));
    }

    @Override
    public String getString(int i) {
        return this.formatter().format(((TimeStampVector)this.vector()).get(i));
    }

    public TimeStampMicroTZVectorReader(TimeStampMicroTZVector v) {
        super(v);
    }
}

